/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import lphy.graphicalModel.ParameterInfo;

public class Argument
implements Comparable<Argument> {
    public final int index;
    public final String name;
    public final String description;
    public final boolean optional;
    public final Class type;

    public Argument(int index, ParameterInfo parameterInfo, Class type) {
        this.index = index;
        this.name = parameterInfo.name();
        this.description = parameterInfo.description();
        this.optional = parameterInfo.optional();
        this.type = type;
    }

    @Override
    public int compareTo(Argument a) {
        if (a.index != this.index) {
            return Integer.compare(this.index, a.index);
        }
        return this.name.compareTo(a.name);
    }

    public final String setMethodName() {
        return Argument.setMethodName(this.name);
    }

    public static String setMethodName(String name) {
        return "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public final String getMethodName() {
        return "get" + Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
    }

    public String toString() {
        return "argument " + this.name + " index=" + this.index + " type=" + this.type + " description=" + this.description + " optional=" + this.optional;
    }
}

