/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;

public abstract class Func
implements Generator {
    private String name = null;
    private String description = null;
    protected TreeMap<String, Value> paramMap = new TreeMap();

    @Override
    public String getName() {
        if (this.name == null) {
            return Func.getName(this.getClass());
        }
        return this.name;
    }

    public String getDescription() {
        if (this.description == null) {
            GeneratorInfo fInfo = Generator.getGeneratorInfo(this.getClass());
            this.description = fInfo != null ? fInfo.name() : this.getClass().getSimpleName();
        }
        return this.description;
    }

    @Override
    public Map<String, Value> getParams() {
        return this.paramMap;
    }

    public void setParam(String paramName, Value value) {
        this.paramMap.put(paramName, value);
    }

    @Override
    public String codeString() {
        return Func.codeString(this, this.getParams());
    }

    @Override
    public char generatorCodeChar() {
        return '=';
    }

    public static String getName(Class<? extends Func> funcClass) {
        GeneratorInfo fInfo = Generator.getGeneratorInfo(funcClass);
        if (fInfo != null) {
            return fInfo.name();
        }
        return funcClass.getSimpleName();
    }

    public static String codeString(Func function, Map<String, Value> params) {
        Map<String, Value> map = params;
        Class<?> funcClass = function.getClass();
        StringBuilder builder = new StringBuilder();
        builder.append(function.getName());
        builder.append("(");
        Constructor<?>[] constructors = funcClass.getConstructors();
        if (constructors.length == 1) {
            List<ParameterInfo> parameterInfoList = Generator.getParameterInfo(funcClass, 0);
            if (parameterInfoList.size() > 0) {
                int paramCount = 0;
                String name = parameterInfoList.get(0).name();
                if (!parameterInfoList.get(0).optional() || map.get(name) != null) {
                    builder.append(Generator.getArgumentCodeString(name, map.get(name)));
                    ++paramCount;
                }
                for (int i = 1; i < parameterInfoList.size(); ++i) {
                    name = parameterInfoList.get(i).name();
                    if (parameterInfoList.get(i).optional() && map.get(name) == null) continue;
                    if (paramCount > 0) {
                        builder.append(", ");
                    }
                    builder.append(Generator.getArgumentCodeString(name, map.get(name)));
                    ++paramCount;
                }
            }
        } else {
            Iterator<Map.Entry<String, Value>> iterator = map.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, Value> entry = iterator.next();
                builder.append(Generator.getArgumentCodeString(entry));
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    builder.append(", ");
                    builder.append(Generator.getArgumentCodeString(entry));
                }
            }
        }
        builder.append(")");
        return builder.toString();
    }
}

