/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.reflection.Utils;

public interface GenerativeDistribution<T>
extends Generator<T> {
    public RandomVariable<T> sample();

    @Override
    default public Value<T> generate() {
        return this.sample();
    }

    default public RandomVariable<T> sample(String id) {
        RandomVariable<T> v = this.sample();
        v.setId(id);
        return v;
    }

    default public double density(T t) {
        return Math.exp(this.logDensity(t));
    }

    default public double logDensity(T t) {
        return Math.log(this.density(t));
    }

    @Override
    default public String getName() {
        String name = this.getClass().getSimpleName();
        GeneratorInfo ginfo = this.getInfo();
        if (ginfo != null) {
            name = ginfo.name();
        }
        return name;
    }

    @Override
    default public String getUniqueId() {
        return "" + this.hashCode();
    }

    @Override
    default public String codeString() {
        Map<String, Value> map = this.getParams();
        Iterator<Map.Entry<String, Value>> iterator = map.entrySet().iterator();
        Map.Entry<String, Value> entry = iterator.next();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append("(").append(Generator.getArgumentCodeString(entry));
        while (iterator.hasNext()) {
            entry = iterator.next();
            builder.append(", ").append(Generator.getArgumentCodeString(entry));
        }
        builder.append(");");
        return builder.toString();
    }

    @Override
    default public char generatorCodeChar() {
        return '~';
    }

    @Override
    default public T value() {
        throw new UnsupportedOperationException();
    }

    public static Class<?> getReturnType(Class<? extends GenerativeDistribution> genClass) {
        try {
            Method method = genClass.getMethod("sample", new Class[0]);
            Class returnType = Utils.getGenericReturnType(method);
            return returnType;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("GenerativeDistribution has no sample method?!");
        }
    }
}

