/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.narrative.Narrative;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.NarrativeUtils;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Utils;
import lphy.graphicalModel.Value;
import lphy.parser.functions.ExpressionNode;
import net.steppschuh.markdowngenerator.link.Link;
import net.steppschuh.markdowngenerator.list.UnorderedList;
import net.steppschuh.markdowngenerator.text.Text;
import net.steppschuh.markdowngenerator.text.emphasis.BoldText;
import net.steppschuh.markdowngenerator.text.heading.Heading;

public interface Generator<T>
extends GraphicalModelNode<T> {
    public String getName();

    public Value<T> generate();

    public String codeString();

    public char generatorCodeChar();

    @Override
    default public List<GraphicalModelNode> getInputs() {
        return new ArrayList<GraphicalModelNode>(this.getParams().values());
    }

    public Map<String, Value> getParams();

    default public String getInferenceStatement(Value value, Narrative narrative) {
        StringBuilder builder = new StringBuilder();
        builder.append("P(");
        String name = narrative.getId(value, false);
        builder.append(name);
        Map<String, Value> params = this.getParams();
        List<ParameterInfo> parameterInfos = this.getParameterInfo(0);
        int count = 0;
        for (ParameterInfo parameterInfo : parameterInfos) {
            Value v = params.get(parameterInfo.name());
            if (v == null || !v.isRandom()) continue;
            if (count == 0) {
                builder.append(" | ");
            } else {
                builder.append(", ");
            }
            if (v.isAnonymous()) {
                builder.append(parameterInfo.name());
            } else {
                name = narrative.getId(v, false);
                builder.append(name);
            }
            ++count;
        }
        builder.append(")");
        return builder.toString();
    }

    default public String getInferenceNarrative(Value value, boolean unique, Narrative narrative) {
        String narrativeName = this.getNarrativeName();
        GeneratorInfo info = Generator.getGeneratorInfo(this.getClass());
        String citationString = narrative.cite(this.getCitation());
        String verbClause = info != null ? info.verbClause() : "comes from";
        StringBuilder builder = new StringBuilder();
        builder.append(NarrativeUtils.getValueClause(value, unique, narrative));
        builder.append(" ");
        builder.append(verbClause);
        builder.append(" ");
        if (!(this instanceof ExpressionNode)) {
            if (this instanceof DeterministicFunction) {
                builder.append(NarrativeUtils.getDefiniteArticle(narrativeName, true));
            } else {
                builder.append(NarrativeUtils.getIndefiniteArticle(narrativeName, true));
            }
        }
        builder.append(" ");
        builder.append(narrativeName);
        if (citationString != null && citationString != "") {
            builder.append(" ");
            builder.append(citationString);
        }
        Map<String, Value> params = this.getParams();
        String currentVerb = "";
        List<ParameterInfo> parameterInfos = this.getParameterInfo(0);
        int count = 0;
        for (ParameterInfo parameterInfo : parameterInfos) {
            Value v = params.get(parameterInfo.name());
            if (v == null) continue;
            if (count == 0) {
                builder.append(" ");
            }
            if (count > 0) {
                if (count == params.size() - 1) {
                    builder.append(" and ");
                } else {
                    builder.append(", ");
                }
            }
            if (!parameterInfo.verb().equals(currentVerb)) {
                currentVerb = parameterInfo.verb();
                builder.append(currentVerb);
                builder.append(" ");
            }
            builder.append(NarrativeUtils.getValueClause(v, false, true, false, this, narrative));
            ++count;
        }
        builder.append(".");
        return builder.toString();
    }

    default public String getTypeName() {
        return Generator.getReturnType(this.getClass()).getSimpleName();
    }

    default public void setParam(String paramName, Value<?> value) {
        String methodName = "set" + Character.toUpperCase(paramName.charAt(0)) + paramName.substring(1);
        try {
            Method method = this.getClass().getMethod(methodName, value.value().getClass());
            method.invoke((Object)this, value.value());
        }
        catch (NoSuchMethodException e) {
            Method[] methods;
            for (Method method : methods = this.getClass().getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                try {
                    method.invoke((Object)this, value.value());
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    default public void setInput(String paramName, Value<?> value) {
        this.setParam(paramName, value);
        value.addOutput(this);
    }

    default public void setInputs(Map<String, Value<?>> params) {
        params.forEach(this::setInput);
    }

    default public String getParamName(Value value) {
        Map<String, Value> params = this.getParams();
        for (String key : params.keySet()) {
            if (params.get(key) != value) continue;
            return key;
        }
        return null;
    }

    default public boolean hasRandomParameters() {
        for (Map.Entry<String, Value> entry : this.getParams().entrySet()) {
            Value v = entry.getValue();
            if (v == null) {
                throw new RuntimeException("Unexpected null value for param " + entry.getKey() + " in generator " + this.getName());
            }
            if (!v.isRandom()) continue;
            return true;
        }
        return false;
    }

    default public String getParamName(int paramIndex, int constructorIndex) {
        return this.getParameterInfo(constructorIndex).get(paramIndex).name();
    }

    @Deprecated
    default public String getParamName(int paramIndex) {
        return this.getParamName(paramIndex, 0);
    }

    default public List<ParameterInfo> getParameterInfo(int constructorIndex) {
        return Generator.getParameterInfo(this.getClass(), constructorIndex);
    }

    default public Citation getCitation() {
        return Generator.getCitation(this.getClass());
    }

    default public Class<?> getParamType(String name) {
        return this.getParams().get(name).getType();
    }

    default public GeneratorInfo getInfo() {
        Method[] methods;
        Class<?> classElement = this.getClass();
        for (Method method : methods = classElement.getMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!(annotation instanceof GeneratorInfo)) continue;
                return (GeneratorInfo)annotation;
            }
        }
        return null;
    }

    default public String getRichDescription(int index) {
        Citation citation;
        List<ParameterInfo> pInfo = this.getParameterInfo(index);
        Map<String, Value> paramValues = this.getParams();
        StringBuilder html = new StringBuilder("<html><h3>");
        html.append(this.getName());
        if (this instanceof GenerativeDistribution) {
            html.append(" distribution");
        }
        html.append("</h3>");
        GeneratorInfo info = this.getInfo();
        if (info != null) {
            html.append("<p>").append(this.getInfo().description()).append("</p>");
        }
        if (pInfo.size() > 0) {
            html.append("<p>parameters: <ul>");
            for (ParameterInfo pi : pInfo) {
                html.append("<li>").append(pi.name()).append(" (").append(paramValues.get(pi.name())).append("); <font color=\"#808080\">").append(pi.description()).append("</font></li>");
            }
            html.append("</ul>");
        }
        if ((citation = this.getCitation()) != null) {
            html.append("<h3>Reference</h3>");
            html.append(citation.value());
            if (citation.DOI().length() > 0) {
                String url = NarrativeUtils.sanitizeDOI(citation.DOI());
                html.append("<br><a href=\"" + url + "\">" + url + "</a><br>");
            }
        }
        html.append("</p></html>");
        return html.toString();
    }

    public static List<ParameterInfo> getParameterInfo(Class<?> c, int constructorIndex) {
        return Generator.getParameterInfo(c.getConstructors()[constructorIndex]);
    }

    public static Citation getCitation(Class<?> c) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = c.getAnnotations()) {
            if (!(annotation instanceof Citation)) continue;
            return (Citation)annotation;
        }
        return null;
    }

    public static List<ParameterInfo> getParameterInfo(Constructor constructor) {
        ArrayList<ParameterInfo> pInfo = new ArrayList<ParameterInfo>();
        Annotation[][] annotations = constructor.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] annotations1;
            for (Annotation annotation : annotations1 = annotations[i]) {
                if (!(annotation instanceof ParameterInfo)) continue;
                pInfo.add((ParameterInfo)annotation);
            }
        }
        return pInfo;
    }

    public static Class<?>[] getParameterTypes(Class<? extends Generator> c, int constructorIndex) {
        return Generator.getParameterTypes(c.getConstructors()[constructorIndex]);
    }

    public static Class[] getParameterTypes(Constructor constructor) {
        Type[] generics = constructor.getGenericParameterTypes();
        Class[] types = new Class[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            types[i] = lphy.reflection.Utils.getClass(generics[i]);
        }
        return types;
    }

    public static List<Argument> getArguments(Class<?> c, int constructorIndex) {
        return Generator.getArguments(c.getConstructors()[constructorIndex]);
    }

    public static List<Argument> getArguments(Constructor constructor) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        Annotation[][] annotations = constructor.getParameterAnnotations();
        Class[] parameterTypes = Generator.getParameterTypes(constructor);
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] annotations1;
            for (Annotation annotation : annotations1 = annotations[i]) {
                if (!(annotation instanceof ParameterInfo)) continue;
                arguments.add(new Argument(i, (ParameterInfo)annotation, parameterTypes[i]));
            }
        }
        return arguments;
    }

    public static String getGeneratorMarkdown(Class<? extends Generator> generatorClass) {
        GeneratorInfo generatorInfo = Generator.getGeneratorInfo(generatorClass);
        List<ParameterInfo> pInfo = Generator.getParameterInfo(generatorClass, 0);
        Class<?>[] types = Generator.getParameterTypes(generatorClass, 0);
        StringBuilder md = new StringBuilder();
        StringBuilder signature = new StringBuilder();
        signature.append(Generator.getGeneratorName(generatorClass)).append("(");
        int count = 0;
        for (int i = 0; i < pInfo.size(); ++i) {
            ParameterInfo pi = pInfo.get(i);
            if (count > 0) {
                signature.append(", ");
            }
            signature.append(new Text((Object)types[i].getSimpleName())).append(" ").append(new BoldText((Object)pi.name()));
            ++count;
        }
        signature.append(")");
        md.append(new Heading((Object)signature.toString(), 2)).append("\n\n");
        if (generatorInfo != null) {
            md.append(generatorInfo.description()).append("\n\n");
        }
        if (pInfo.size() > 0) {
            md.append(new Heading((Object)"Parameters", 3)).append("\n\n");
            ArrayList<Text> paramText = new ArrayList<Text>();
            for (int i = 0; i < pInfo.size(); ++i) {
                ParameterInfo pi = pInfo.get(i);
                paramText.add(new Text((Object)(types[i].getSimpleName() + " " + new BoldText((Object)pi.name()) + " - " + pi.description())));
            }
            md.append(new UnorderedList(paramText));
        }
        md.append("\n\n");
        md.append(new Heading((Object)"Return type", 3)).append("\n\n");
        List<String> returnType = Collections.singletonList(Generator.getReturnType(generatorClass).getSimpleName());
        md.append(new UnorderedList(returnType)).append("\n\n");
        Citation citation = Generator.getCitation(generatorClass);
        if (citation != null) {
            md.append(new Heading((Object)"Reference", 3)).append("\n\n");
            md.append(citation.value());
            if (citation.DOI().length() > 0) {
                Object url = citation.DOI();
                if (!((String)url).startsWith("http")) {
                    url = "http://doi.org/" + (String)url;
                }
                md.append(new Link(url, (String)url));
            }
        }
        return md.toString();
    }

    public static List<ParameterInfo> getAllParameterInfo(Class c) {
        ArrayList<ParameterInfo> pInfo = new ArrayList<ParameterInfo>();
        for (Constructor<?> constructor : c.getConstructors()) {
            pInfo.addAll(Generator.getParameterInfo(constructor));
        }
        return pInfo;
    }

    public static String getSignature(Class<?> aClass) {
        List<ParameterInfo> pInfo = Generator.getParameterInfo(aClass, 0);
        StringBuilder builder = new StringBuilder();
        builder.append(Generator.getGeneratorName(aClass));
        builder.append("(");
        if (pInfo.size() > 0) {
            builder.append(pInfo.get(0).name());
            for (int i = 1; i < pInfo.size(); ++i) {
                builder.append(", ");
                builder.append(pInfo.get(i).name());
            }
        }
        builder.append(")");
        return builder.toString();
    }

    public static String getGeneratorName(Class<?> c) {
        GeneratorInfo ginfo = Generator.getGeneratorInfo(c);
        if (ginfo != null) {
            return ginfo.name();
        }
        return c.getSimpleName();
    }

    public static String getGeneratorDescription(Class<?> c) {
        GeneratorInfo ginfo = Generator.getGeneratorInfo(c);
        if (ginfo != null) {
            return ginfo.description();
        }
        return "";
    }

    public static GeneratorInfo getGeneratorInfo(Class<?> c) {
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!(annotation instanceof GeneratorInfo)) continue;
                return (GeneratorInfo)annotation;
            }
        }
        return null;
    }

    public static String getArgumentCodeString(Map.Entry<String, Value> entry) {
        return Generator.getArgumentCodeString(entry.getKey(), entry.getValue());
    }

    public static String getArgumentCodeString(String name, Value value) {
        Object prefix = "";
        if (!Utils.isInteger(name)) {
            prefix = name + "=";
        }
        if (value == null) {
            throw new RuntimeException("Value of " + name + " is null!");
        }
        if (value.isAnonymous()) {
            return (String)prefix + value.codeString();
        }
        return (String)prefix + value.getId();
    }

    public static boolean matchingParameterTypes(List<Argument> arguments, Object[] initArgs, Map<String, Value> params, boolean lightweight) {
        int count = 0;
        for (int i = 0; i < arguments.size(); ++i) {
            Argument argumentInfo = arguments.get(i);
            Object arg = initArgs[i];
            if (arg != null) {
                Class<?> valueType;
                Class parameterType = argumentInfo.type;
                Class<?> clazz = valueType = lightweight ? arg.getClass() : ((Value)arg).value().getClass();
                if (!parameterType.isAssignableFrom(valueType)) {
                    return false;
                }
                ++count;
                continue;
            }
            if (argumentInfo.optional) continue;
            return false;
        }
        return params == null || count == params.size();
    }

    public static Map<String, Value> convertArgumentsToParameterMap(List<Argument> argumentInfos, Object[] initArgs) {
        TreeMap<String, Value> params = new TreeMap<String, Value>();
        for (int i = 0; i < argumentInfos.size(); ++i) {
            Argument argumentInfo = argumentInfos.get(i);
            Value value = (Value)initArgs[i];
            if (value == null) continue;
            params.put(argumentInfo.name, value);
        }
        return params;
    }

    public static Class<?> getReturnType(Class<?> genClass) {
        Method[] methods;
        for (Method method : methods = genClass.getMethods()) {
            GeneratorInfo generatorInfo = method.getAnnotation(GeneratorInfo.class);
            if (generatorInfo == null) continue;
            return lphy.reflection.Utils.getGenericReturnType(method);
        }
        if (GenerativeDistribution.class.isAssignableFrom(genClass)) {
            try {
                method = genClass.getMethod("sample", new Class[0]);
                return lphy.reflection.Utils.getGenericReturnType(method);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        } else if (DeterministicFunction.class.isAssignableFrom(genClass)) {
            try {
                method = genClass.getMethod("apply", new Class[0]);
                return lphy.reflection.Utils.getGenericReturnType(method);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return Object.class;
    }

    default public String getNarrativeName(Value value) {
        return this.getNarrativeName(this.getParamName(value));
    }

    default public String getNarrativeName(String paramName) {
        List<ParameterInfo> parameterInfos = this.getParameterInfo(0);
        for (ParameterInfo parameterInfo : parameterInfos) {
            if (!parameterInfo.name().equals(paramName)) continue;
            if (parameterInfo.suppressNameInNarrative()) {
                return "";
            }
            if (parameterInfo.narrativeName().length() <= 0) continue;
            return parameterInfo.narrativeName();
        }
        return paramName;
    }

    default public String getNarrativeName() {
        GeneratorInfo generatorInfo = Generator.getGeneratorInfo(this.getClass());
        if (generatorInfo != null && generatorInfo.narrativeName().length() > 0) {
            return generatorInfo.narrativeName();
        }
        return this.getName();
    }
}

