/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.RangeElement;

public class IndexedRandomVariable<T>
extends RandomVariable<T[]> {
    Map<RangeElement, GenerativeDistribution<T>> distributionMap = new HashMap<RangeElement, GenerativeDistribution<T>>();

    public IndexedRandomVariable(String id, RandomVariable<T> part, RangeElement rangeElement) {
        super(id, null, null);
        this.setId(id);
        List<Integer> range = Arrays.asList(rangeElement.range());
        int max = Collections.max(range);
        this.value = (Object[])Array.newInstance(part.value().getClass(), max + 1);
        if (range.size() > 1) {
            throw new IllegalArgumentException("Expected a range of length 1");
        }
        ((Object[])this.value)[range.get((int)0).intValue()] = part.value;
        this.distributionMap.put(rangeElement, part.getGenerativeDistribution());
    }

    @Override
    public List<GraphicalModelNode> getInputs() {
        TreeSet<GenerativeDistribution<T>> set = new TreeSet<GenerativeDistribution<T>>();
        set.addAll(this.distributionMap.values());
        ArrayList<GraphicalModelNode> list = new ArrayList<GraphicalModelNode>();
        list.addAll(set);
        return list;
    }
}

