/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lphy.core.narrative.Narrative;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

public class NarrativeUtils {
    static final Map<String, String> TYPE_MAP = Map.of("Alignment[]", "Alignments", "Double[]", "Vector", "Double[][]", "Matrix", "Integer[]", "Vector", "Integer[][]", "Matrix", "TimeTree", "Time Tree");
    static List<String> anNouns = new ArrayList<String>(List.of("n", "m", "HKY"));
    static List<String> pluralNouns = new ArrayList<String>(List.of("taxa"));

    public static String getArticle(Value value, boolean unique) {
        return NarrativeUtils.getArticle(value, NarrativeUtils.getName(value), unique, false);
    }

    public static String getArticle(Value value, String name, boolean unique, boolean lowercase) {
        String article;
        String string = article = lowercase ? "" : "The";
        if (!unique && value.isAnonymous()) {
            article = NarrativeUtils.getIndefiniteArticle(name, lowercase);
        }
        return article;
    }

    public static String sanitizeDOI(String doi) {
        if (doi.startsWith("http")) {
            return doi;
        }
        if (doi.startsWith("doi.org")) {
            return "https://" + doi;
        }
        if ("01923456789".indexOf(doi.charAt(0)) >= 0) {
            return "https://doi.org/" + doi;
        }
        return doi;
    }

    private static String sanitizeTypeName(String typeName) {
        String sanitizedTypeName = TYPE_MAP.get(typeName);
        if (sanitizedTypeName != null) {
            return sanitizedTypeName.toLowerCase();
        }
        return typeName.toLowerCase();
    }

    public static String getTypeName(Value value) {
        if (value.getGenerator() != null) {
            return NarrativeUtils.sanitizeTypeName(value.getGenerator().getTypeName());
        }
        return NarrativeUtils.getSimpleTypeName(value);
    }

    public static String getSimpleTypeName(Value value) {
        String s = value.getType().getSimpleName();
        String[] r = s.split("(?<=.)(?=\\p{Lu})");
        if (r.length > 1) {
            StringBuilder b = new StringBuilder();
            int count = 0;
            for (String part : r) {
                if (count > 0) {
                    b.append(" ");
                }
                b.append(part.toLowerCase());
                ++count;
            }
            return b.toString();
        }
        return NarrativeUtils.sanitizeTypeName(s);
    }

    public static boolean hasSingleGeneratorOutput(Value value) {
        return value.getOutputs().size() == 1 && value.getOutputs().get(0) instanceof Generator;
    }

    public static String getName(Value value) {
        String name;
        if (NarrativeUtils.hasSingleGeneratorOutput(value)) {
            Generator generator = (Generator)value.getOutputs().get(0);
            name = generator.getNarrativeName(value);
            if (name == null || name.equals("")) {
                name = NarrativeUtils.getTypeName(value);
            }
        } else {
            name = NarrativeUtils.getTypeName(value);
        }
        return name;
    }

    public static String getValueClause(Value value, boolean unique, Narrative narrative) {
        return NarrativeUtils.getValueClause(value, unique, false, false, narrative);
    }

    public static String getValueClause(Value value, boolean unique, boolean lowercase, boolean plural, Narrative narrative) {
        return NarrativeUtils.getValueClause(value, unique, lowercase, plural, null, narrative);
    }

    public static String getValueClause(Value value, boolean unique, boolean lowercase, boolean plural, Generator generator, Narrative narrative) {
        boolean match;
        Object name;
        StringBuilder builder = new StringBuilder();
        if (generator != null) {
            name = generator.getNarrativeName(value);
            if (name == null || ((String)name).equals("")) {
                name = NarrativeUtils.getName(value);
            }
        } else {
            name = NarrativeUtils.getName(value);
        }
        if (plural) {
            name = NarrativeUtils.pluralize((String)name);
        }
        Object narrativeId = null;
        if (!value.isAnonymous()) {
            narrativeId = narrative.getId(value, true);
        }
        boolean bl = match = !value.isAnonymous() && ((String)name).equals(value.getId());
        if (unique || !((String)name).endsWith("s") || plural) {
            String article = NarrativeUtils.getArticle(value, (String)name, unique, lowercase);
            if (match) {
                narrativeId = article + " " + (String)narrativeId;
            } else {
                name = article + " " + (String)name;
            }
        }
        String firstLetter = ((String)name).substring(0, 1);
        name = (lowercase ? firstLetter.toLowerCase() : firstLetter.toUpperCase()) + ((String)name).substring(1);
        if (match) {
            builder.append((String)narrativeId);
        } else {
            builder.append((String)name);
            builder.append((String)(value.isAnonymous() ? "" : ", " + (String)narrativeId));
        }
        if (value.getGenerator() == null && !value.isRandom()) {
            builder.append(" of ");
            builder.append(narrative.text(ValueUtils.valueToString(value.value)));
        }
        return builder.toString();
    }

    public static String getIndefiniteArticle(String noun, boolean lowercase) {
        String article = "A";
        if ("aeiou".indexOf(noun.charAt(0)) >= 0 || anNouns.contains(noun.split(" ")[0])) {
            article = "An";
        }
        if (lowercase) {
            article = article.toLowerCase();
        }
        return article;
    }

    public static String getDefiniteArticle(String noun, boolean lowercase) {
        String article = "The";
        if (lowercase) {
            article = article.toLowerCase();
        }
        return article;
    }

    public static String pluralize(String noun) {
        if (!noun.endsWith("s") && !pluralNouns.contains(noun)) {
            return noun + "s";
        }
        return noun;
    }
}

