/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lphy.core.VarFileLogger;
import lphy.graphicalModel.Loggable;
import lphy.graphicalModel.RandomValueLogger;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

public class RandomNumberLogger
implements RandomValueLogger {
    public Map<Class, Loggable> loggableMap;
    boolean logVariables;
    boolean logStatistics;
    public Map<String, List<Double[]>> variableValues = new HashMap<String, List<Double[]>>();
    public List<Value> firstValues = new ArrayList<Value>();
    int sampleCount;

    public RandomNumberLogger(boolean logVariables, boolean logStatistics) {
        this.logVariables = logVariables;
        this.logStatistics = logStatistics;
        this.loggableMap = VarFileLogger.loggableMap;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public void log(int rep, List<Value<?>> randomValues) {
        if (rep == 0) {
            this.firstValues.clear();
            this.variableValues.clear();
            this.firstValues.addAll(randomValues);
        }
        for (Value<?> randomValue : randomValues) {
            Loggable loggable;
            if (!this.isLogged(randomValue) || (loggable = this.loggableMap.get(randomValue.value().getClass())) == null) continue;
            Object[] logValues = loggable.getLogValues(randomValue);
            Double[] values = new Double[logValues.length];
            for (int i = 0; i < logValues.length; ++i) {
                if (logValues[i] instanceof Number) {
                    values[i] = ((Number)logValues[i]).doubleValue();
                    continue;
                }
                if (!(logValues[i] instanceof Boolean)) continue;
                values[i] = (Boolean)logValues[i] != false ? 1.0 : 0.0;
            }
            List varValues = this.variableValues.computeIfAbsent(randomValue.getId(), k -> new ArrayList());
            varValues.add(values);
        }
        this.sampleCount = rep + 1;
    }

    public boolean isLogged(Value randomValue) {
        boolean random = randomValue instanceof RandomVariable && this.logVariables || !(randomValue instanceof RandomVariable) && randomValue.isRandom() && this.logStatistics;
        boolean number = ValueUtils.isNumberOrNumberArray(randomValue) || ValueUtils.is2DNumberArray(randomValue) || randomValue.value() instanceof Boolean;
        return random && number && !randomValue.isAnonymous();
    }

    @Override
    public void close() {
    }
}

