/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lphy.core.LPhyParser;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GraphicalModel;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;

public class Utils {
    public static DecimalFormat FORMAT = new DecimalFormat();
    static boolean clusters;

    public static String toGraphvizDot(Collection<GraphicalModelNode> nodes, LPhyParser parser) {
        HashSet<GraphicalModelNode> done = new HashSet<GraphicalModelNode>();
        ArrayList<String> dataNodes = new ArrayList<String>();
        ArrayList<String> modelNodes = new ArrayList<String>();
        ArrayList<String> edges = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("digraph G {\n");
        builder.append("  ranksep=0.02;\n");
        for (GraphicalModelNode node : nodes) {
            Utils.toGraphvizDot(node, done, dataNodes, modelNodes, edges, parser, Utils.isDataNode(node, parser));
        }
        Utils.appendCluster("data", builder, dataNodes);
        Utils.appendCluster("model", builder, modelNodes);
        for (String edge : edges) {
            builder.append(edge);
        }
        builder.append("}\n");
        return builder.toString();
    }

    private static void appendCluster(String name, StringBuilder builder, List<String> nodes) {
        if (nodes.size() > 0) {
            if (clusters) {
                builder.append("subgraph cluster_").append(name).append(" {\n");
            }
            for (String node : nodes) {
                builder.append("  ").append(node);
            }
            if (clusters) {
                builder.append("  label = \"");
                builder.append(name);
                builder.append("\";\n");
                builder.append("  color=blue;\n");
                builder.append("  labeljust=\"l\";\n");
                builder.append("  fontcolor=blue;\n");
                builder.append("}\n");
            }
        }
        builder.append("\n");
    }

    private static void toGraphvizDot(GraphicalModelNode node, Set<GraphicalModelNode> done, List<String> dataNodes, List<String> modelNodes, List<String> edges, LPhyParser parser, boolean isData) {
        if (!done.contains(node)) {
            isData = isData || Utils.isDataNode(node, parser);
            for (GraphicalModelNode child : node.getInputs()) {
                Utils.toGraphvizDot(child, done, dataNodes, modelNodes, edges, parser, isData);
                done.add(child);
            }
            String name = Utils.getUniqueId(node, parser);
            String nodeString = Utils.graphvizNodeString(node, name) + ";\n";
            if (isData) {
                dataNodes.add(nodeString);
            } else {
                modelNodes.add(nodeString);
            }
            for (GraphicalModelNode child : node.getInputs()) {
                StringBuilder builder = new StringBuilder();
                builder.append(Utils.getUniqueId(child, parser));
                builder.append(" -> ");
                builder.append(name);
                builder.append(Utils.graphvizEdgeLabel(node, child));
                builder.append(";\n");
                edges.add(builder.toString());
            }
        }
    }

    private static boolean isDataNode(GraphicalModelNode node, LPhyParser parser) {
        Value value;
        if (node instanceof Value && !(node instanceof RandomVariable) && !(value = (Value)node).isAnonymous()) {
            return parser.hasValue(value.getId(), GraphicalModel.Context.data);
        }
        return false;
    }

    private static String getUniqueId(GraphicalModelNode node, LPhyParser parser) {
        Object name = node.getUniqueId();
        if (node instanceof Value && !((Value)node).isAnonymous() && parser.isClamped(((Value)node).getId())) {
            name = "" + node.hashCode();
        }
        return name;
    }

    private static String graphvizEdgeLabel(GraphicalModelNode node, GraphicalModelNode child) {
        Object label = "";
        String edgestyle = " arrowhead=vee, ";
        if (child instanceof Generator) {
            label = "taillabel=\"" + ((Generator)child).getName() + "\", ";
        } else if (child instanceof Value && ((Value)child).isAnonymous()) {
            label = "label=\"" + ((Value)child).getLabel() + "\", ";
        }
        if (node instanceof Generator) {
            edgestyle = "arrowhead=none, ";
        }
        return "[" + (String)label + edgestyle + "tailport=s]";
    }

    private static String graphvizLabel(GraphicalModelNode node) {
        Object label = null;
        if (node instanceof Value) {
            if (((Value)node).isAnonymous()) {
                String slot = ((Value)node).getLabel();
                Object val = ((Value)node).value();
                label = val instanceof Double || val instanceof Integer ? node.toString() : (val instanceof Double[] && ((Double[])val).length < 7 ? Arrays.toString((Object[])((Double[])val)) : (val instanceof String ? "'" + (String)val + "'" : slot));
            } else {
                label = ((Value)node).function == null && !(node instanceof RandomVariable) ? node.toString() : ((Value)node).getId();
            }
        } else if (node instanceof Generator) {
            label = "";
        }
        return label;
    }

    private static String graphvizNodeString(GraphicalModelNode node, String name) {
        String labelString = "label=\"" + Utils.graphvizLabel(node) + "\", ";
        if (node instanceof GenerativeDistribution) {
            return name + "[" + labelString + "shape=box, fixedsize=true, width=0.2, height=0.2, label=\"\", fillcolor=gray, style=filled]";
        }
        if (node instanceof DeterministicFunction) {
            return name + "[" + labelString + "shape=diamond, fixedsize=true, width=0.2, height=0.2, label=\"\", fillcolor=gray, style=filled]";
        }
        if (node instanceof RandomVariable) {
            return name + "[" + labelString + "shape=circle, fixedsize=true, width=0.8, height=0.8, fillcolor=\"#66ff66\"\t, style=filled]";
        }
        if (node instanceof Value) {
            if (((Value)node).function != null) {
                return name + "[" + labelString + "shape=diamond, fixedsize=true, width=0.8, height=0.8, fillcolor=\"#ff6666\", style=filled]";
            }
            return name + "[" + labelString + "shape=rect]";
        }
        return name;
    }

    public static boolean isInteger(String str) {
        try {
            int i = Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    static {
        FORMAT.setMaximumFractionDigits(6);
        clusters = true;
    }
}

