/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lphy.core.narrative.Narrative;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.GraphicalModelNodeVisitor;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.ValueListener;
import lphy.graphicalModel.ValueUtils;
import lphy.graphicalModel.types.DoubleValue;
import lphy.util.Symbols;

public class Value<T>
implements GraphicalModelNode<T> {
    T value;
    private String id;
    List<ValueListener> listeners = new ArrayList<ValueListener>();
    List<GraphicalModelNode> outputs = new ArrayList<GraphicalModelNode>();
    DeterministicFunction<T> function = null;
    public static final Value<Double> Double_1 = new DoubleValue(null, 1.0, null);

    public Value(String id, T value) {
        this.id = id;
        this.value = value;
    }

    public Value(String id, T value, DeterministicFunction<T> function) {
        this(id, value);
        this.function = function;
    }

    public final Class getType() {
        return this.value.getClass();
    }

    public Value(T value, DeterministicFunction<T> function) {
        this(null, value);
        this.function = function;
    }

    @Override
    public final T value() {
        return this.value;
    }

    public String getLabel() {
        if (this.isAnonymous()) {
            if (this.getOutputs().size() > 0) {
                return "[" + ((Generator)this.getOutputs().get(0)).getParamName(this) + "]";
            }
            return "[anonymous]";
        }
        return this.getId();
    }

    public String codeString() {
        StringBuilder builder = new StringBuilder();
        Generator<T> generator = this.getGenerator();
        if (generator != null) {
            if (!this.isAnonymous()) {
                builder.append(this.id);
                builder.append(" ");
                builder.append(generator.generatorCodeChar());
                builder.append(" ");
            }
            builder.append(generator.codeString());
        } else {
            builder.append(this.toString());
        }
        return builder.toString();
    }

    public String getNarrative(boolean unique, Narrative narrative) {
        if (this.getGenerator() != null) {
            return this.getGenerator().getInferenceNarrative(this, unique, narrative);
        }
        if (!this.isAnonymous()) {
            return this.toString();
        }
        return "";
    }

    public String toString() {
        if (this.isAnonymous()) {
            return this.valueToString();
        }
        return this.id + " = " + this.valueToString();
    }

    public String valueToString() {
        return ValueUtils.valueToString(this.value);
    }

    public void setValue(T value) {
        T oldValue = this.value;
        this.value = value;
        for (ValueListener listener : this.listeners) {
            listener.valueSet(oldValue, value);
        }
    }

    @Override
    public String getUniqueId() {
        if (!this.isAnonymous()) {
            return this.getId();
        }
        return "" + this.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public final String getCanonicalId() {
        if (!this.isAnonymous()) {
            return Symbols.getCanonical(this.getId());
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Generator<T> getGenerator() {
        return this.function;
    }

    public boolean isRandom() {
        return this instanceof RandomVariable || this.function != null && this.function.hasRandomParameters();
    }

    public void addValueListener(ValueListener listener) {
        this.listeners.add(listener);
    }

    public static void traverseGraphicalModel(Value value, GraphicalModelNodeVisitor visitor, boolean post) {
        if (!post) {
            visitor.visitValue(value);
        }
        if (value.getGenerator() != null) {
            Value.traverseGraphicalModel(value.getGenerator(), visitor, post);
        }
        if (post) {
            visitor.visitValue(value);
        }
    }

    private static void traverseGraphicalModel(Generator generator, GraphicalModelNodeVisitor visitor, boolean post) {
        if (!post) {
            visitor.visitGenerator(generator);
        }
        Map<String, Value> map = generator.getParams();
        for (Map.Entry<String, Value> e : map.entrySet()) {
            Value.traverseGraphicalModel(e.getValue(), visitor, post);
        }
        if (post) {
            visitor.visitGenerator(generator);
        }
    }

    public void addOutput(Generator p) {
        if (!this.outputs.contains(p)) {
            this.outputs.add(p);
        }
    }

    public void removeOutput(Generator p) {
        this.outputs.remove(p);
    }

    public List<GraphicalModelNode> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<GraphicalModelNode> getInputs() {
        if (this.function != null) {
            return Collections.singletonList(this.function);
        }
        return new ArrayList<GraphicalModelNode>();
    }

    public boolean isAnonymous() {
        return this.id == null || this.id.equals("");
    }

    public boolean isConstant() {
        return !(this instanceof RandomVariable) && this.getGenerator() == null;
    }

    public void setFunction(DeterministicFunction f) {
        this.function = f;
    }
}

