/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.util.Arrays;
import java.util.Map;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.MultiDimensional;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.BooleanArrayValue;
import lphy.graphicalModel.types.BooleanValue;
import lphy.graphicalModel.types.DoubleArrayValue;
import lphy.graphicalModel.types.DoubleValue;
import lphy.graphicalModel.types.IntegerArrayValue;
import lphy.graphicalModel.types.IntegerValue;

public class ValueUtils {
    public static boolean isValueOfDeterministicFunction(Value value) {
        return !ValueUtils.isRandomVariable(value) && value.getGenerator() != null;
    }

    public static boolean isFixedValue(Value value) {
        return value.getGenerator() == null && !(value instanceof RandomVariable);
    }

    public static boolean isRandomVariable(Value value) {
        return value instanceof RandomVariable;
    }

    public static boolean isNumberOrNumberArray(Value value) {
        Class<?> valueClass = value.value().getClass();
        return Number.class.isAssignableFrom(valueClass) || valueClass.isArray() && Number.class.isAssignableFrom(valueClass.getComponentType());
    }

    public static boolean is2DNumberArray(Value value) {
        Class<?> valueClass = value.value().getClass();
        return valueClass.isArray() && valueClass.getComponentType().isArray() && Number.class.isAssignableFrom(valueClass.getComponentType().getComponentType());
    }

    public static boolean isNumber(Value value) {
        Object val = value.value();
        return val instanceof Number;
    }

    public static boolean isMultiDimensional(Object v) {
        return v instanceof MultiDimensional || v instanceof Map || v.getClass().isArray();
    }

    public static boolean isInteger(String s) {
        try {
            int i = Integer.parseInt(s);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static double doubleValue(Value<Number> value) {
        return value.value().doubleValue();
    }

    public static Value createValue(Integer intValue, DeterministicFunction generator) {
        return new IntegerValue(null, intValue, generator);
    }

    public static Value createValue(Integer[] intArrayValue, DeterministicFunction generator) {
        return new IntegerArrayValue(null, intArrayValue, generator);
    }

    public static Value createValue(Double doubleValue, DeterministicFunction generator) {
        return new DoubleValue(null, doubleValue, generator);
    }

    public static Value createValue(Double[] doubleArrayValue, DeterministicFunction generator) {
        return new DoubleArrayValue(null, doubleArrayValue, generator);
    }

    public static Value createValue(Boolean booleanValue, DeterministicFunction generator) {
        return new BooleanValue(null, booleanValue, generator);
    }

    public static Value createValue(Boolean[] booleanArrayValue, DeterministicFunction generator) {
        return new BooleanArrayValue(null, booleanArrayValue, generator);
    }

    public static Value createValue(Object value, DeterministicFunction generator) {
        if (value instanceof Integer) {
            return ValueUtils.createValue((Integer)value, generator);
        }
        if (value instanceof Integer[]) {
            return ValueUtils.createValue((Integer[])value, generator);
        }
        if (value instanceof Double) {
            return ValueUtils.createValue((Double)value, generator);
        }
        if (value instanceof Double[]) {
            return ValueUtils.createValue((Double[])value, generator);
        }
        if (value instanceof Boolean) {
            return ValueUtils.createValue((Boolean)value, generator);
        }
        if (value instanceof Boolean[]) {
            return ValueUtils.createValue((Boolean[])value, generator);
        }
        return new Value<Object>(null, value, generator);
    }

    public static String valueToString(Object value) {
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                if (Boolean.TYPE.isAssignableFrom(componentType)) {
                    return Arrays.toString((boolean[])value);
                }
                if (Byte.TYPE.isAssignableFrom(componentType)) {
                    return Arrays.toString((byte[])value);
                }
                if (Character.TYPE.isAssignableFrom(componentType)) {
                    return Arrays.toString((char[])value);
                }
                if (Double.TYPE.isAssignableFrom(componentType)) {
                    return Arrays.toString((double[])value);
                }
                if (Float.TYPE.isAssignableFrom(componentType)) {
                    return Arrays.toString((float[])value);
                }
                if (Integer.TYPE.isAssignableFrom(componentType)) {
                    return Arrays.toString((int[])value);
                }
                if (Long.TYPE.isAssignableFrom(componentType)) {
                    return Arrays.toString((long[])value);
                }
                if (Short.TYPE.isAssignableFrom(componentType)) {
                    return Arrays.toString((short[])value);
                }
            } else {
                if (String.class.isAssignableFrom(componentType)) {
                    String[] stringArray = (String[])value;
                    StringBuilder builder = new StringBuilder();
                    builder.append("[");
                    if (stringArray.length > 0) {
                        builder.append(ValueUtils.quotedString(stringArray[0]));
                    }
                    for (int i = 1; i < stringArray.length; ++i) {
                        builder.append(", ");
                        builder.append(ValueUtils.quotedString(stringArray[i]));
                    }
                    builder.append("]");
                    return builder.toString();
                }
                return Arrays.toString((Object[])value);
            }
        }
        if (value instanceof String) {
            return ValueUtils.quotedString(value.toString());
        }
        return value.toString();
    }

    public static String quotedString(String str) {
        return "\"" + str + "\"";
    }

    public static Class<?> getType(Value[] var) {
        if (ValueUtils.allNull(var)) {
            return Double.class;
        }
        if (ValueUtils.allAssignableFrom(var, Double.class)) {
            return Double.class;
        }
        if (ValueUtils.allAssignableFrom(var, Integer.class)) {
            return Integer.class;
        }
        if (ValueUtils.allAssignableFrom(var, Number.class)) {
            return Number.class;
        }
        if (ValueUtils.allAssignableFrom(var, Boolean.class)) {
            return Boolean.class;
        }
        if (ValueUtils.allAssignableFrom(var, String.class)) {
            return String.class;
        }
        if (ValueUtils.allAssignableFrom(var, Double[].class)) {
            return Double[].class;
        }
        if (ValueUtils.allAssignableFrom(var, Integer[].class)) {
            return Integer[].class;
        }
        if (ValueUtils.allAssignableFrom(var, Boolean[].class)) {
            return Boolean[].class;
        }
        if (ValueUtils.allAssignableFrom(var, String[].class)) {
            return String[].class;
        }
        return Object.class;
    }

    private static boolean allNull(Value[] var) {
        for (Value value : var) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    private static boolean allAssignableFrom(Value[] var, Class superclass) {
        for (Value value : var) {
            if (value == null || superclass.isAssignableFrom(value.value().getClass())) continue;
            return false;
        }
        return true;
    }
}

