/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.IID;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.CompoundVector;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.Vector;
import lphy.graphicalModel.types.VectorValue;

public class VectorUtils {
    public static final String INDEX_SEPARATOR = "_";

    public static boolean isVectorizedParameter(String argumentName, Value value, Map<String, Class> baseTypes) {
        return VectorUtils.isArrayOfType(value, baseTypes.get(argumentName));
    }

    public static int getVectorSize(Map<String, Value> params, Map<String, Class> baseTypes) {
        int size = 1;
        for (Map.Entry<String, Value> entry : params.entrySet()) {
            String name = entry.getKey();
            Value v = entry.getValue();
            if (!VectorUtils.isArrayOfType(v, baseTypes.get(name))) continue;
            int vectorSize = Array.getLength(v.value());
            if (size == 1) {
                size = vectorSize;
                continue;
            }
            if (size == vectorSize) continue;
            throw new RuntimeException("Vector sizes do not match!");
        }
        return size;
    }

    public static int getVectorSize(List<Argument> argumentInfos, Object[] args) {
        int size = -1;
        for (int i = 0; i < argumentInfos.size(); ++i) {
            Argument argumentInfo = argumentInfos.get(i);
            Value argValue = (Value)args[i];
            if (argValue == null) {
                if (argumentInfo.optional) continue;
                throw new IllegalArgumentException("Required parameter " + argumentInfo.name + " not including in vector arguments");
            }
            Class<?> argValueClass = argValue.value().getClass();
            if (argumentInfo.type.isAssignableFrom(argValueClass) || !argValueClass.isArray() || !argumentInfo.type.isAssignableFrom(argValueClass.getComponentType())) continue;
            int length = Array.getLength(argValue.value());
            if (size == -1) {
                size = length;
                continue;
            }
            if (size == length) continue;
            throw new IllegalArgumentException("Vector lengths don't match!");
        }
        return size;
    }

    public static Value getReplicatesValue(Generator generator, int size) {
        for (Map.Entry<String, Value> entry : generator.getParams().entrySet()) {
            Value<Integer> replicatesValue;
            Generator paramGenerator = entry.getValue().getGenerator();
            if (paramGenerator == null || !(paramGenerator instanceof IID ? (replicatesValue = ((IID)entry.getValue().getGenerator()).getReplicates()).value() == size : (replicatesValue = VectorUtils.getReplicatesValue(paramGenerator, size)) != null)) continue;
            return replicatesValue;
        }
        return null;
    }

    public static List<Generator> getComponentGenerators(Constructor constructor, List<Argument> argumentInfos, Object[] vectorArgs) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        int size = VectorUtils.getVectorSize(argumentInfos, vectorArgs);
        ArrayList<Generator> generators = new ArrayList<Generator>(size);
        for (int component = 0; component < size; ++component) {
            generators.add(VectorUtils.getComponentGenerator(constructor, argumentInfos, vectorArgs, component));
        }
        return generators;
    }

    public static Generator getElementGenerator(Constructor constructor, List<Argument> argumentInfos, Object[] parentArgs) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = new Object[argumentInfos.size()];
        for (int i = 0; i < argumentInfos.size(); ++i) {
            Argument argumentInfo = argumentInfos.get(i);
            Value argValue = (Value)parentArgs[i];
            if (argValue == null) {
                if (argumentInfo.optional) continue;
                throw new IllegalArgumentException("Required parameter " + argumentInfo.name + " not including in arguments");
            }
            Class<?> argValueClass = argValue.value().getClass();
            if (!argumentInfo.type.isAssignableFrom(argValueClass)) continue;
            args[i] = parentArgs[i];
        }
        return (Generator)constructor.newInstance(args);
    }

    public static Generator getComponentGenerator(Constructor constructor, List<Argument> argumentInfos, Object[] vectorArgs, int component) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args = new Object[argumentInfos.size()];
        for (int i = 0; i < argumentInfos.size(); ++i) {
            Argument argumentInfo = argumentInfos.get(i);
            Value argValue = (Value)vectorArgs[i];
            if (argValue == null) {
                if (argumentInfo.optional) continue;
                throw new IllegalArgumentException("Required parameter " + argumentInfo.name + " not including in vector arguments");
            }
            Class<?> argValueClass = argValue.value().getClass();
            if (argumentInfo.type.isAssignableFrom(argValueClass)) {
                args[i] = vectorArgs[i];
                continue;
            }
            if (!argValueClass.isArray() || !argumentInfo.type.isAssignableFrom(argValueClass.getComponentType())) continue;
            Object array = argValue.value();
            int length = Array.getLength(array);
            if (Array.getLength(array) <= component) {
                throw new RuntimeException("Array " + array + " is length " + length + " but attempting to access element " + component);
            }
            args[i] = argValue instanceof CompoundVector ? ((CompoundVector)((Object)argValue)).getComponentValue(component) : new Value<Object>(argValue.isAnonymous() ? null : argValue.getId() + INDEX_SEPARATOR + component, Array.get(array, component));
        }
        return (Generator)constructor.newInstance(args);
    }

    public static Map<String, Value<?>> getComponentParameters(Map<String, Value> params, Map<String, Class> baseTypes, int component) {
        int size = 1;
        TreeMap componentParams = new TreeMap();
        for (Map.Entry<String, Value> entry : params.entrySet()) {
            String name = entry.getKey();
            Value v = entry.getValue();
            if (VectorUtils.isArrayOfType(v, baseTypes.get(name))) {
                int vectorSize = Array.getLength(v.value());
                if (size == 1) {
                    size = vectorSize;
                } else if (size != vectorSize) {
                    throw new RuntimeException("Vector sizes do not match!");
                }
                Object input = Array.get(v.value(), component);
                componentParams.put(name, new Value<Object>(v.getId() + INDEX_SEPARATOR + component, input));
                continue;
            }
            componentParams.put(name, v);
        }
        return componentParams;
    }

    public static boolean isArrayOfType(Value maybeArray, Class ofType) {
        if (maybeArray.value().getClass().isArray()) {
            Class<?> componentClass = maybeArray.value().getClass().getComponentType();
            return componentClass.isAssignableFrom(ofType);
        }
        return false;
    }

    public static Object getElement(Value value, int i) {
        if (value instanceof Vector) {
            return ((VectorValue)value).getComponent(i);
        }
        if (value.value().getClass().isArray()) {
            return Array.get(value.value(), i);
        }
        throw new IllegalArgumentException("Expected a Vector or array!");
    }
}

