/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import lphy.graphicalModel.CompoundVector;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.RandomVariable;

public class VectorizedRandomVariable<T>
extends RandomVariable<T[]>
implements CompoundVector<T> {
    List<RandomVariable<T>> componentVariables = new ArrayList<RandomVariable<T>>();

    public VectorizedRandomVariable(String id, List<RandomVariable> componentVariables, GenerativeDistribution<T[]> generativeDistribution) {
        super(id, VectorizedRandomVariable.unwrapValues(componentVariables), generativeDistribution);
        for (int i = 0; i < ((Object[])this.value).length; ++i) {
            this.componentVariables.add(componentVariables.get(i));
        }
    }

    private static Object[] unwrapValues(List<RandomVariable> values) {
        Object[] result = (Object[])Array.newInstance(values.get(0).value().getClass(), values.size());
        for (int i = 0; i < result.length; ++i) {
            result[i] = values.get(i).value();
        }
        return result;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        for (int i = 0; i < this.componentVariables.size(); ++i) {
            this.componentVariables.get(i).setId(id + "_" + i);
        }
    }

    @Override
    public Class<T> getComponentType() {
        return ((Object[])this.value())[0].getClass();
    }

    @Override
    public T getComponent(int i) {
        return (T)((Object[])this.value())[i];
    }

    @Override
    public int size() {
        return ((Object[])this.value()).length;
    }

    @Override
    public RandomVariable<T> getComponentValue(int i) {
        return this.componentVariables.get(i);
    }
}

