/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel.code;

import java.util.ArrayList;
import java.util.HashSet;
import lphy.core.LPhyParser;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GraphicalModelNodeVisitor;
import lphy.graphicalModel.Value;

public interface CodeBuilder {
    public String valueToCodeString(Value var1);

    public String generatorToCodeString(Generator var1);

    default public String getCode(final LPhyParser parser) {
        final HashSet visited = new HashSet();
        final ArrayList dataLines = new ArrayList();
        final ArrayList modelLines = new ArrayList();
        StringBuilder builder = new StringBuilder();
        for (Value<?> value : parser.getModelSinks()) {
            Value.traverseGraphicalModel(value, new GraphicalModelNodeVisitor(){

                @Override
                public void visitValue(Value value) {
                    if (!visited.contains(value)) {
                        if (!value.isAnonymous()) {
                            Object str = CodeBuilder.this.valueToCodeString(value);
                            if (!((String)str).endsWith(";")) {
                                str = (String)str + ";";
                            }
                            if (parser.isNamedDataValue(value)) {
                                dataLines.add(str);
                            } else {
                                modelLines.add(str);
                            }
                        }
                        visited.add(value);
                    }
                }

                @Override
                public void visitGenerator(Generator generator) {
                }
            }, true);
        }
        if (dataLines.size() > 0) {
            builder.append("data {\n");
            for (String dataLine : dataLines) {
                builder.append("  ");
                builder.append(dataLine);
                builder.append("\n");
            }
            builder.append("}\n");
        }
        if (modelLines.size() > 0) {
            builder.append("model {\n");
            for (String modelLine : modelLines) {
                builder.append("  ");
                builder.append(modelLine);
                builder.append("\n");
            }
            builder.append("}\n");
        }
        return builder.toString();
    }
}

