/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel.code;

import lphy.graphicalModel.Generator;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.code.CodeBuilder;

public class LaTexCodeBuilder
implements CodeBuilder {
    static String variableColor = "green";
    static String constantColor = "magenta";
    static String otherColor = "black";

    @Override
    public String valueToCodeString(Value value) {
        StringBuilder builder = new StringBuilder();
        Generator generator = value.getGenerator();
        if (!value.isAnonymous()) {
            builder.append("\\textcolor{");
            if (value instanceof RandomVariable) {
                builder.append(variableColor);
            } else if (value.getGenerator() == null) {
                builder.append(constantColor);
            } else {
                builder.append(otherColor);
            }
            builder.append("}{");
            builder.append(value.getId());
            builder.append("} ");
            builder.append(generator.generatorCodeChar());
            builder.append(" ");
            builder.append(this.generatorToCodeString(generator));
            return builder.toString();
        }
        return value.codeString();
    }

    @Override
    public String generatorToCodeString(Generator generator) {
        return generator.codeString();
    }
}

