/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel.types;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lphy.graphicalModel.CompoundVector;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.Value;

public class CompoundVectorValue<T>
extends Value<T[]>
implements CompoundVector<T> {
    List<Value<T>> componentValues = new ArrayList<Value<T>>();

    public CompoundVectorValue(String id, List<Value> values, DeterministicFunction function) {
        super(id, CompoundVectorValue.unwrapValues(values), function);
        for (Value value : values) {
            this.componentValues.add(value);
        }
    }

    private static Object[] unwrapValues(List<Value> values) {
        Object[] result = (Object[])Array.newInstance(values.get(0).value().getClass(), values.size());
        for (int i = 0; i < result.length; ++i) {
            result[i] = values.get(i).value();
        }
        return result;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        for (int i = 0; i < this.componentValues.size(); ++i) {
            this.componentValues.get(i).setId(id + "_" + i);
        }
    }

    @Override
    public String toString() {
        return (String)(this.isAnonymous() ? "" : this.getId() + " = ") + Arrays.toString((Object[])this.value());
    }

    @Override
    public Class<T> getComponentType() {
        return ((Object[])this.value())[0].getClass();
    }

    @Override
    public Value<T> getComponentValue(int i) {
        return this.componentValues.get(i);
    }

    @Override
    public T getComponent(int i) {
        return (T)((Object[])this.value())[i];
    }

    @Override
    public int size() {
        return ((Object[])this.value()).length;
    }
}

