/*
 * Decompiled with CFR 0.152.
 */
package lphy.graphicalModel.types;

import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.ValueUtils;
import lphy.graphicalModel.types.VectorValue;

public class StringArrayValue
extends VectorValue<String> {
    public StringArrayValue(String id, String[] value) {
        super(id, (T[])value);
    }

    public StringArrayValue(String id, String[] value, DeterministicFunction function) {
        super(id, (T[])value, function);
    }

    @Override
    public String valueToString() {
        String[] val = (String[])this.value();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (val.length > 0) {
            builder.append(ValueUtils.quotedString(val[0]));
        }
        for (int i = 1; i < val.length; ++i) {
            builder.append(", ");
            builder.append(ValueUtils.quotedString(val[i]));
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String toString() {
        return (String)(this.isAnonymous() ? "" : this.getId() + " = ") + this.valueToString();
    }
}

