/*
 * Decompiled with CFR 0.152.
 */
package lphy.layeredgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lphy.layeredgraph.LatticePoint;
import lphy.layeredgraph.LayeredGraph;
import lphy.layeredgraph.LayeredNode;

public class BrandesKopfHorizontalCoordinateAssignment {
    Map<LayeredNode, List<LayeredNode>> marks = new HashMap<LayeredNode, List<LayeredNode>>();
    LayeredGraph g;
    int delta = 2;

    public BrandesKopfHorizontalCoordinateAssignment(LayeredGraph g) {
        if (!this.proper(g)) {
            throw new IllegalArgumentException();
        }
        this.g = g;
        this.horizontalCoordinateAssignment();
    }

    boolean proper(LayeredGraph g) {
        for (LayeredNode v : g.getNodes()) {
            int layer = v.getLayer();
            for (LayeredNode u : v.getPredecessors()) {
                if (u.getLayer() == layer - 1) continue;
                return false;
            }
            for (LayeredNode w : v.getSuccessors()) {
                if (w.getLayer() == layer + 1) continue;
                return false;
            }
            if (!v.isDummy() || v.getPredecessors().size() != 0) continue;
            throw new IllegalArgumentException("dummy vertex has no predecessors!");
        }
        return true;
    }

    int countDummyNodes() {
        int count = 0;
        for (LayeredNode v : this.g.getNodes()) {
            if (!v.isDummy()) continue;
            ++count;
        }
        return count;
    }

    int countInnerEdges() {
        int count = 0;
        for (LayeredNode v : this.g.getNodes()) {
            if (!v.isDummy()) continue;
            for (LayeredNode u : v.getPredecessors()) {
                if (!u.isDummy()) continue;
                ++count;
            }
        }
        return count;
    }

    void preprocessing() {
        int h = this.g.layers.size();
        for (int i = 0; i < h - 2; ++i) {
            int k0 = 0;
            int l = 0;
            List<LayeredNode> layer0 = this.g.layers.get(i);
            List<LayeredNode> layer1 = this.g.layers.get(i + 1);
            int layer1Size = layer1.size();
            for (int l1 = 0; l1 < layer1Size; ++l1) {
                LayeredNode vl1iplus1 = layer1.get(l1);
                if (l1 != layer1Size - 1 && !this.isInnerSegmentAbove(vl1iplus1)) continue;
                int k1 = layer0.size() - 1;
                if (this.isInnerSegmentAbove(vl1iplus1)) {
                    k1 = vl1iplus1.getPredecessors().get(0).getIndex();
                }
                while (l <= l1) {
                    LayeredNode vliplus1 = layer1.get(l);
                    for (LayeredNode vki : vliplus1.getPredecessors()) {
                        int k = vki.getIndex();
                        if (k >= k0 && k <= k1) continue;
                        this.mark(vki, vliplus1);
                    }
                    ++l;
                }
                k0 = k1;
            }
        }
    }

    private void mark(LayeredNode upperNeighbour, LayeredNode node) {
        List<LayeredNode> edges = this.marks.get(node);
        if (edges == null) {
            edges = new ArrayList<LayeredNode>();
            this.marks.put(node, edges);
        }
        edges.add(upperNeighbour);
    }

    private boolean marked(LayeredNode upper, LayeredNode node) {
        List<LayeredNode> edges = this.marks.get(node);
        if (edges == null) {
            return false;
        }
        return edges.contains(upper);
    }

    void verticalAlignment(Alignment a, boolean reverse) {
        for (LayeredNode v : this.g.getNodes()) {
            a.root.put(v, v);
            a.align.put(v, v);
        }
        int layerCount = this.g.layers.size();
        for (int k = 0; k < layerCount; ++k) {
            List<LayeredNode> layer = reverse ? this.g.layers.get(layerCount - k - 1) : this.g.layers.get(k);
            int r = -1;
            for (LayeredNode v_ki : layer) {
                if (!this.hasOrderedUppers(v_ki, reverse)) continue;
                int d = this.getUppersSize(v_ki, reverse);
                for (int m = (int)Math.floor(((double)d + 1.0) / 2.0) - 1; m <= (int)Math.ceil(((double)d + 1.0) / 2.0) - 1; ++m) {
                    LayeredNode um = this.upper(v_ki, m, reverse);
                    if (a.align(v_ki) != v_ki || this.marked(um, v_ki) || r >= um.getIndex()) continue;
                    a.align.put(um, v_ki);
                    a.root.put(v_ki, a.root(um));
                    a.align.put(v_ki, a.root(um));
                    r = um.getIndex();
                }
            }
        }
    }

    private boolean hasOrderedUppers(LayeredNode node, boolean reverse) {
        List<LayeredNode> uppers;
        List<LayeredNode> list = uppers = reverse ? node.getSuccessors() : node.getPredecessors();
        if (uppers.size() == 0) {
            return false;
        }
        for (int i = 1; i < uppers.size(); ++i) {
            if (uppers.get(i).getIndex() >= uppers.get(i - 1).getIndex()) continue;
            return false;
        }
        return true;
    }

    private int getUppersSize(LayeredNode node, boolean reverse) {
        return reverse ? node.getSuccessors().size() : node.getPredecessors().size();
    }

    LayeredNode pred(LayeredNode v) {
        return this.g.layers.get(v.getLayer()).get(v.getIndex() - 1);
    }

    void placeBlock(LayeredNode v, Alignment a) {
        if (a.x.get(v) == null) {
            a.x.put(v, 0);
            LayeredNode w = v;
            do {
                if (w.getIndex() <= 0) continue;
                LayeredNode u = a.root.get(this.pred(w));
                this.placeBlock(u, a);
                if (a.sink(v) == v) {
                    a.sink.put(v, a.sink(u));
                }
                if (a.sink(v) != a.sink(u)) {
                    a.shift.put(a.sink(u), Math.min(a.shift.get(a.sink(u)), a.x(v) - a.x(u) - this.delta));
                    continue;
                }
                a.x.put(v, Math.max(a.x(v), a.x(u) + this.delta));
            } while ((w = a.align.get(w)) != v);
        }
    }

    void horizontalCompaction(Alignment a) {
        for (LayeredNode v : this.g.getNodes()) {
            a.sink.put(v, v);
            a.shift.put(v, Integer.MAX_VALUE);
        }
        a.x.clear();
        for (LayeredNode v : this.g.getNodes()) {
            if (a.root(v) != v) continue;
            this.placeBlock(v, a);
        }
        for (LayeredNode v : this.g.getNodes()) {
            a.x.put(v, a.x(a.root(v)));
        }
    }

    void horizontalCoordinateAssignment() {
        this.preprocessing();
        Alignment lu = new Alignment();
        this.verticalAlignment(lu, false);
        this.horizontalCompaction(lu);
        int maxXLeftUp = lu.computeFinalX();
        Alignment ld = new Alignment();
        this.verticalAlignment(ld, true);
        this.horizontalCompaction(ld);
        int maxXLeftDown = ld.computeFinalX();
        this.reverseLayers();
        Alignment ru = new Alignment();
        this.verticalAlignment(ru, false);
        this.horizontalCompaction(ru);
        int maxXRightUp = ru.computeFinalX();
        Alignment rd = new Alignment();
        this.verticalAlignment(rd, true);
        this.horizontalCompaction(rd);
        int maxXRightDown = rd.computeFinalX();
        for (LayeredNode v : this.g.getNodes()) {
            int newCol = (lu.finalX(v) + ld.finalX(v) + (maxXRightUp - ru.finalX(v)) + (maxXRightDown - rd.finalX(v))) / 2;
            v.setMetaData("latticePoint", new LatticePoint(newCol, v.getLayer() * 2));
        }
        this.reverseLayers();
        for (LayeredNode v : this.g.getNodes()) {
            LatticePoint latticePoint = (LatticePoint)v.getMetaData("latticePoint");
            latticePoint.y = v.getLayer() * 2;
        }
    }

    private void reverseLayers() {
        for (List<LayeredNode> layer : this.g.layers) {
            Collections.reverse(layer);
        }
        this.g.updateIndex();
    }

    private LayeredNode upper(LayeredNode node, int i, boolean reverse) {
        return reverse ? node.getSuccessors().get(i) : node.getPredecessors().get(i);
    }

    private boolean isInnerSegmentAbove(LayeredNode layeredNode) {
        return layeredNode.isDummy() && layeredNode.getPredecessors().get(0).isDummy();
    }

    class Alignment {
        Map<LayeredNode, LayeredNode> root = new HashMap<LayeredNode, LayeredNode>();
        Map<LayeredNode, LayeredNode> align = new HashMap<LayeredNode, LayeredNode>();
        Map<LayeredNode, LayeredNode> sink = new HashMap<LayeredNode, LayeredNode>();
        Map<LayeredNode, Integer> x = new HashMap<LayeredNode, Integer>();
        Map<LayeredNode, Integer> finalX = new HashMap<LayeredNode, Integer>();
        Map<LayeredNode, Integer> shift = new HashMap<LayeredNode, Integer>();

        Alignment() {
        }

        int computeFinalX() {
            int maxX = 0;
            for (LayeredNode v : BrandesKopfHorizontalCoordinateAssignment.this.g.getNodes()) {
                int x = this.x(v);
                int s = this.shift(this.sink(this.root(v)));
                if (s < Integer.MAX_VALUE) {
                    x += s;
                }
                if (x > maxX) {
                    maxX = x;
                }
                this.finalX.put(v, x);
            }
            return maxX;
        }

        int x(LayeredNode v) {
            return this.x.get(v);
        }

        int finalX(LayeredNode v) {
            return this.finalX.get(v);
        }

        int shift(LayeredNode v) {
            return this.shift.get(v);
        }

        LayeredNode align(LayeredNode v) {
            return this.align.get(v);
        }

        LayeredNode sink(LayeredNode v) {
            return this.sink.get(v);
        }

        LayeredNode root(LayeredNode v) {
            return this.root.get(v);
        }
    }
}

