/*
 * Decompiled with CFR 0.152.
 */
package lphy.layeredgraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lphy.layeredgraph.LayeredNode;
import lphy.layeredgraph.Layering;

public class LayeredGraph {
    List<LayeredNode> nodes = new ArrayList<LayeredNode>();
    List<List<LayeredNode>> layers = new ArrayList<List<LayeredNode>>();

    public LayeredGraph() {
    }

    public LayeredGraph(Collection<LayeredNode> nodes) {
        this.nodes.addAll(nodes);
        this.repopulateLayers();
    }

    public LayeredGraph(List<List<LayeredNode>> layers) {
        this.layers = layers;
        for (List<LayeredNode> layer : layers) {
            this.nodes.addAll(layer);
        }
    }

    public void applyLayering(Layering layering) {
        layering.apply(this.nodes);
        this.repopulateLayers();
    }

    public List<LayeredNode> getNodes() {
        return this.nodes;
    }

    public List<List<LayeredNode>> getLayers() {
        return this.layers;
    }

    public void addNode(LayeredNode node) {
        this.nodes.add(node);
        this.addNodeToLayers(node);
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public int getMaxIndex() {
        int maxIndex = 0;
        for (LayeredNode v : this.getNodes()) {
            if (v.getIndex() <= maxIndex) continue;
            maxIndex = v.getIndex();
        }
        return maxIndex;
    }

    public double getMaxX() {
        double maxX = 0.0;
        for (LayeredNode v : this.getNodes()) {
            if (!(v.getX() > maxX)) continue;
            maxX = v.getX();
        }
        return maxX;
    }

    private void addNodeToLayers(LayeredNode node) {
        while (this.layers.size() <= node.getLayer()) {
            this.layers.add(new ArrayList());
        }
        List<LayeredNode> layer = this.layers.get(node.getLayer());
        if (!layer.contains(node)) {
            layer.add(node);
        }
    }

    public List<LayeredNode> getLayer(int layer) {
        return this.layers.get(layer);
    }

    public void updateIndex() {
        for (List<LayeredNode> layer : this.layers) {
            LayeredGraph.updateIndex(layer);
        }
    }

    public void repopulateLayers() {
        for (List<LayeredNode> list : this.layers) {
            list.clear();
        }
        this.layers.clear();
        for (LayeredNode layeredNode : this.nodes) {
            this.addNodeToLayers(layeredNode);
        }
        for (List list : this.layers) {
            LayeredGraph.updateIndex(list);
        }
    }

    void updateIndex(int layerIndex) {
        LayeredGraph.updateIndex(this.getLayer(layerIndex));
    }

    static void updateIndex(List<? extends LayeredNode> layer) {
        for (int index = 0; index < layer.size(); ++index) {
            layer.get(index).setIndex(index);
        }
    }

    public static LayeredGraph testGraph() {
        ArrayList<List<LayeredNode>> layers = new ArrayList<List<LayeredNode>>();
        LayeredNode.Default v00 = new LayeredNode.Default(0, 0);
        LayeredNode.Default v01 = new LayeredNode.Default(0, 1);
        layers.add(Arrays.asList(v00, v01));
        LayeredNode.Default v10 = new LayeredNode.Default(1, 0);
        LayeredNode.Default v11 = new LayeredNode.Default(1, 1);
        LayeredNode.Dummy d12 = new LayeredNode.Dummy(1, 2);
        LayeredNode.Default v13 = new LayeredNode.Default(1, 3);
        LayeredNode.Dummy d14 = new LayeredNode.Dummy(1, 4);
        LayeredNode.Dummy d15 = new LayeredNode.Dummy(1, 5);
        LayeredNode.Default v16 = new LayeredNode.Default(1, 6);
        LayeredNode.Default v17 = new LayeredNode.Default(1, 7);
        layers.add(Arrays.asList(v10, v11, d12, v13, d14, d15, v16, v17));
        LayeredNode.Default v20 = new LayeredNode.Default(2, 0);
        LayeredNode.Default v21 = new LayeredNode.Default(2, 1);
        LayeredNode.Dummy d22 = new LayeredNode.Dummy(2, 2);
        LayeredNode.Dummy d23 = new LayeredNode.Dummy(2, 3);
        LayeredNode.Dummy d24 = new LayeredNode.Dummy(2, 4);
        LayeredNode.Default v25 = new LayeredNode.Default(2, 5);
        layers.add(Arrays.asList(v20, v21, d22, d23, d24, v25));
        LayeredNode.Default v30 = new LayeredNode.Default(3, 0);
        LayeredNode.Default v31 = new LayeredNode.Default(3, 1);
        LayeredNode.Dummy d32 = new LayeredNode.Dummy(3, 2);
        LayeredNode.Dummy d33 = new LayeredNode.Dummy(3, 3);
        LayeredNode.Dummy d34 = new LayeredNode.Dummy(3, 4);
        LayeredNode.Default v35 = new LayeredNode.Default(3, 5);
        LayeredNode.Dummy d36 = new LayeredNode.Dummy(3, 6);
        layers.add(Arrays.asList(v30, v31, d32, d33, d34, v35, d36));
        LayeredNode.Default v40 = new LayeredNode.Default(4, 0);
        LayeredNode.Default v41 = new LayeredNode.Default(4, 1);
        LayeredNode.Default v42 = new LayeredNode.Default(4, 2);
        layers.add(Arrays.asList(v40, v41, v42));
        v00.addSuccessor(v10);
        v00.addSuccessor(d15);
        v00.addSuccessor(v17);
        v01.addSuccessor(d12);
        v01.addSuccessor(d14);
        v11.addSuccessor(v21);
        d12.addSuccessor(v21);
        v13.addSuccessor(v21);
        d14.addSuccessor(d22);
        d15.addSuccessor(d23);
        v16.addSuccessor(v25);
        v17.addSuccessor(d24);
        v20.addSuccessor(v30);
        v20.addSuccessor(v31);
        v20.addSuccessor(v35);
        d22.addSuccessor(d33);
        d23.addSuccessor(d34);
        d24.addSuccessor(v35);
        v25.addSuccessor(d32);
        v25.addSuccessor(d36);
        v30.addSuccessor(v40);
        v30.addSuccessor(v41);
        v31.addSuccessor(v41);
        d32.addSuccessor(v40);
        d33.addSuccessor(v42);
        d34.addSuccessor(v42);
        v35.addSuccessor(v42);
        d36.addSuccessor(v42);
        return new LayeredGraph((List<List<LayeredNode>>)layers);
    }
}

