/*
 * Decompiled with CFR 0.152.
 */
package lphy.layeredgraph;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public interface LayeredNode {
    public List<LayeredNode> getSuccessors();

    public List<LayeredNode> getPredecessors();

    default public boolean isSink() {
        return this.getSuccessors().size() == 0;
    }

    default public boolean isSource() {
        return this.getPredecessors().size() == 0;
    }

    public int getLayer();

    public Object getMetaData(String var1);

    public void setMetaData(String var1, Object var2);

    public void setLayer(int var1);

    default public void setPosition(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public boolean isDummy();

    default public Point2D getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public double getX();

    public double getY();

    public void setX(double var1);

    public void setY(double var1);

    public int getIndex();

    public void setIndex(int var1);

    public static class Dummy
    extends Default {
        public Dummy(int layer) {
            super(layer, 0);
        }

        public Dummy(int layer, int index) {
            super(layer, index);
        }

        @Override
        public boolean isDummy() {
            return true;
        }

        @Override
        public String toString() {
            return "dummy(" + this.layer + "," + this.index + ")";
        }
    }

    public static class Default
    implements LayeredNode {
        protected double x = 0.0;
        protected double y = 0.0;
        private List<LayeredNode> successors = new ArrayList<LayeredNode>();
        private List<LayeredNode> predecessors = new ArrayList<LayeredNode>();
        protected int layer;
        int index;
        Map<String, Object> metadata = new TreeMap<String, Object>();

        public Default(int layer, int index) {
            this.layer = layer;
            this.index = index;
        }

        @Override
        public List<LayeredNode> getSuccessors() {
            return this.successors;
        }

        @Override
        public List<LayeredNode> getPredecessors() {
            return this.predecessors;
        }

        public void addSuccessor(LayeredNode successor) {
            this.getSuccessors().add(successor);
            if (!successor.getPredecessors().contains(this)) {
                successor.getPredecessors().add(this);
            }
        }

        @Override
        public int getLayer() {
            return this.layer;
        }

        @Override
        public Object getMetaData(String key) {
            return this.metadata.get(key);
        }

        @Override
        public void setMetaData(String name, Object value) {
            this.metadata.put(name, value);
        }

        @Override
        public void setLayer(int layer) {
            this.layer = layer;
        }

        @Override
        public boolean isDummy() {
            return false;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setX(double x) {
            this.x = x;
        }

        @Override
        public void setY(double y) {
            this.y = y;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public boolean isSource() {
            return this.predecessors.size() == 0;
        }

        public String toString() {
            return "v(" + this.layer + "," + this.index + ")";
        }
    }
}

