/*
 * Decompiled with CFR 0.152.
 */
package lphy.layeredgraph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lphy.layeredgraph.LayeredNode;

public interface Layering {
    public void apply(List<LayeredNode> var1);

    public static List<LayeredNode> getSinks(List<LayeredNode> nodes) {
        ArrayList<LayeredNode> sinks = new ArrayList<LayeredNode>();
        for (LayeredNode node : nodes) {
            if (!node.isSink()) continue;
            sinks.add(node);
        }
        return sinks;
    }

    public static List<LayeredNode> getSources(List<LayeredNode> nodes) {
        ArrayList<LayeredNode> sources = new ArrayList<LayeredNode>();
        for (LayeredNode node : nodes) {
            if (!node.isSource()) continue;
            sources.add(node);
        }
        return sources;
    }

    public static void setLayer(List<LayeredNode> nodes, int layer) {
        for (LayeredNode node : nodes) {
            node.setLayer(layer);
        }
    }

    public static class LongestPathFromSources
    implements Layering {
        int MAX_LAYERS = 20;

        @Override
        public void apply(List<LayeredNode> layeredNodes) {
            LinkedList<LayeredNode> nodes = new LinkedList<LayeredNode>();
            nodes.addAll(layeredNodes);
            List<LayeredNode> predecessors = Layering.getSources(nodes);
            nodes.removeAll(predecessors);
            Layering.setLayer(predecessors, 0);
            int layerIndex = 1;
            while (!nodes.isEmpty()) {
                if (layerIndex > this.MAX_LAYERS) {
                    throw new RuntimeException("Graphical tree exceeds maximum depth of " + this.MAX_LAYERS + "! (Graph not directed? Cycles?)");
                }
                ArrayList<LayeredNode> layer = new ArrayList<LayeredNode>();
                for (LayeredNode item : nodes) {
                    if (!predecessors.containsAll(item.getPredecessors())) continue;
                    layer.add(item);
                }
                nodes.removeAll(layer);
                predecessors.addAll(layer);
                Layering.setLayer(layer, layerIndex);
                ++layerIndex;
            }
        }

        public String toString() {
            return "From Sources";
        }
    }

    public static class LongestPathFromSinks
    implements Layering {
        @Override
        public void apply(List<LayeredNode> nodes) {
            for (LayeredNode node : nodes) {
                node.setLayer(0);
            }
            int[] minLayer = new int[]{0};
            for (LayeredNode sink : Layering.getSinks(nodes)) {
                this.traverseToSetLayers(sink, 0, minLayer);
            }
            for (LayeredNode node : nodes) {
                node.setLayer(node.getLayer() - minLayer[0]);
            }
        }

        private void traverseToSetLayers(LayeredNode node, int layer, int[] minLayer) {
            if (node.getLayer() > layer) {
                node.setLayer(layer);
                if (layer < minLayer[0]) {
                    minLayer[0] = layer;
                }
            }
            for (LayeredNode child : node.getPredecessors()) {
                this.traverseToSetLayers(child, layer - 1, minLayer);
            }
        }

        public String toString() {
            return "From Sinks";
        }
    }
}

