/*
 * Decompiled with CFR 0.152.
 */
package lphy.layeredgraph;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.layeredgraph.LayeredNode;

public class NodeWrapper
implements LayeredNode {
    private int index;
    private int layer;
    double dx = 0.0;
    private double x;
    private double y;
    private final LayeredNode node;
    private final List<LayeredNode> pred = new LinkedList<LayeredNode>();
    private final List<LayeredNode> succ = new LinkedList<LayeredNode>();
    boolean padding = false;
    Map<String, Object> metaData = new TreeMap<String, Object>();

    NodeWrapper(LayeredNode n, int layer) {
        this.node = n;
        this.layer = layer;
        if (n != null && n.getLayer() != layer) {
            throw new IllegalArgumentException();
        }
    }

    NodeWrapper(int l) {
        this(null, l);
    }

    NodeWrapper() {
        this(null, Integer.MAX_VALUE);
        this.padding = true;
    }

    void addPredecessor(NodeWrapper node) {
        this.pred.add(node);
    }

    void addSuccessor(NodeWrapper node) {
        this.succ.add(node);
    }

    @Override
    public boolean isDummy() {
        return this.node == null && !this.padding;
    }

    boolean isPadding() {
        return this.node == null && this.padding;
    }

    public LayeredNode wrappedNode() {
        return this.node;
    }

    @Override
    public List<LayeredNode> getSuccessors() {
        return this.succ;
    }

    @Override
    public List<LayeredNode> getPredecessors() {
        return this.pred;
    }

    @Override
    public int getLayer() {
        if (this.node != null) {
            return this.node.getLayer();
        }
        return this.layer;
    }

    @Override
    public Object getMetaData(String key) {
        if (this.node != null) {
            return this.node.getMetaData(key);
        }
        return this.metaData.get(key);
    }

    @Override
    public void setMetaData(String name, Object value) {
        if (this.node != null) {
            this.node.setMetaData(name, value);
        } else {
            this.metaData.put(name, value);
        }
    }

    @Override
    public void setLayer(int layer) {
        if (this.node != null) {
            this.node.setLayer(layer);
        } else {
            this.layer = layer;
        }
    }

    @Override
    public double getX() {
        if (this.node != null) {
            return this.node.getX();
        }
        return this.x;
    }

    @Override
    public double getY() {
        if (this.node != null) {
            return this.node.getY();
        }
        return this.y;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    @Override
    public void setX(double x) {
        if (this.node != null) {
            this.node.setX(x);
        }
        this.x = x;
    }

    @Override
    public void setY(double y) {
        if (this.node != null) {
            this.node.setY(y);
        }
        this.y = y;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        if (this.isPadding()) {
            return "padding";
        }
        if (this.isDummy()) {
            return "dummy";
        }
        return "wrapper(" + this.node.toString() + ")";
    }
}

