/*
 * Decompiled with CFR 0.152.
 */
package lphy.layeredgraph;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import lphy.layeredgraph.LayeredGraph;
import lphy.layeredgraph.LayeredNode;
import lphy.layeredgraph.Layering;
import lphy.layeredgraph.NodeWrapper;

public class ProperLayeredGraph
extends LayeredGraph {
    Layering layering;
    LayeredGraph wrappedGraph;
    final Map<LayeredNode, NodeWrapper> map = new IdentityHashMap<LayeredNode, NodeWrapper>();

    public ProperLayeredGraph(LayeredGraph wrappedGraph, Layering layering) {
        this.layering = layering;
        this.wrappedGraph = wrappedGraph;
        this.setup();
    }

    public void setWrappedGraph(LayeredGraph layeredGraph) {
        this.wrappedGraph = layeredGraph;
        this.setup();
    }

    void setup() {
        this.makeProper();
    }

    final void makeProper() {
        this.layers.clear();
        this.map.clear();
        this.wrappedGraph.applyLayering(this.layering);
        boolean i = false;
        for (List<LayeredNode> layer : this.wrappedGraph.layers) {
            this.addLayer(layer);
        }
        this.updateIndex();
    }

    @Override
    public List<LayeredNode> getNodes() {
        ArrayList<LayeredNode> nodes = new ArrayList<LayeredNode>();
        for (List layer : this.layers) {
            nodes.addAll(layer);
        }
        return nodes;
    }

    private void addLayer(List<LayeredNode> list) {
        ArrayList<NodeWrapper> layer = new ArrayList<NodeWrapper>(list.size());
        for (LayeredNode node : list) {
            NodeWrapper nw = new NodeWrapper(node, this.layers.size());
            this.map.put(node, nw);
            layer.add(nw);
            for (LayeredNode node_predecessor : node.getPredecessors()) {
                LayeredNode nw_predecessor = this.map.get(node_predecessor);
                if (nw_predecessor == null) {
                    throw new RuntimeException("Node wrapped Predecessor of node " + node + " was null!");
                }
                for (int layerIndex = nw_predecessor.getLayer() + 1; layerIndex < nw.getLayer(); ++layerIndex) {
                    NodeWrapper nw_dummy = new NodeWrapper(layerIndex);
                    nw_dummy.getPredecessors().add(nw_predecessor);
                    nw_predecessor.getSuccessors().add(nw_dummy);
                    nw_predecessor = nw_dummy;
                    ((List)this.layers.get(layerIndex)).add(nw_dummy);
                }
                nw.getPredecessors().add(nw_predecessor);
                nw_predecessor.getSuccessors().add(nw);
            }
        }
        this.layers.add(layer);
        this.updateIndex(this.layers.size() - 1);
    }
}

