/*
 * Decompiled with CFR 0.152.
 */
package lphy.mcmc;

import java.util.HashMap;
import java.util.Map;
import lphy.graphicalModel.GraphicalModel;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueListener;

public class MCMC {
    GraphicalModel model;
    Map<RandomVariable, Object> oldValues = new HashMap<RandomVariable, Object>();
    boolean inAcceptReject = false;

    public MCMC(GraphicalModel model) {
        this.model = model;
        for (final Value value : model.getModelValues()) {
            if (!(value instanceof RandomVariable)) continue;
            value.addValueListener(new ValueListener(){

                public void valueSet(Object oldValue, Object newValue) {
                    if (MCMC.this.inAcceptReject) {
                        MCMC.this.oldValues.put((RandomVariable)value, oldValue);
                    }
                }
            });
        }
    }

    public void run(int chainLength) {
        double logPosterior = this.model.computeLogPosterior();
        for (int i = 0; i < chainLength; ++i) {
            this.oldValues.clear();
            this.inAcceptReject = true;
        }
    }
}

