/*
 * Decompiled with CFR 0.152.
 */
package lphy.mcmc.operators;

import java.util.Collections;
import java.util.List;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.RandomVariable;
import lphy.mcmc.Operator;
import org.apache.commons.math3.random.RandomGenerator;

public class ScaleOperator
implements Operator<Double> {
    RandomVariable<Double> variable;
    RandomGenerator random = Utils.getRandom();
    double scaleFactor = 0.75;

    public ScaleOperator(RandomVariable<Double> variable, double scaleFactor) {
        this.variable = variable;
        this.scaleFactor = scaleFactor;
    }

    @Override
    public double operate() {
        Double oldValue = (Double)this.variable.value();
        double scale = this.getScaler();
        double newValue = scale * oldValue;
        this.variable.setValue(newValue);
        return -Math.log(scale);
    }

    protected double getScaler() {
        return this.scaleFactor + this.random.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
    }

    @Override
    public List<RandomVariable<Double>> getVariables() {
        return Collections.singletonList(this.variable);
    }
}

