/*
 * Decompiled with CFR 0.152.
 */
package lphy.nexus;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lphy.evolution.alignment.SimpleAlignment;
import lphy.nexus.NexusBlock;

public class CharactersBlock
extends NexusBlock {
    private final SimpleAlignment alignment;

    public CharactersBlock(SimpleAlignment alignment) {
        this.alignment = alignment;
    }

    @Override
    public String getBlockName() {
        return "characters";
    }

    @Override
    public List<String> getBlockLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("dimensions nchar=" + this.alignment.nchar());
        lines.add("format datatype=" + this.alignment.getSequenceTypeStr());
        StringBuilder matrix = new StringBuilder("matrix ");
        for (int i = 0; i < this.alignment.ntaxa(); ++i) {
            try {
                String taxonName = this.alignment.getTaxaNames()[i];
                String sequence = this.alignment.getSequence(i);
                matrix.append("\n\t\t").append(taxonName).append(" ").append(sequence);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(CharactersBlock.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        lines.add(matrix.toString());
        return lines;
    }
}

