/*
 * Decompiled with CFR 0.152.
 */
package lphy.nexus;

import java.io.PrintStream;
import java.util.List;
import lphy.evolution.alignment.SimpleAlignment;
import lphy.evolution.tree.TimeTree;
import lphy.nexus.CharactersBlock;
import lphy.nexus.NexusBlock;
import lphy.nexus.NexusBuilder;
import lphy.nexus.TaxaBlock;
import lphy.nexus.TreesBlock;

public class NexusWriter {
    public static void write(SimpleAlignment alignment, List<TimeTree> trees, PrintStream pstream) throws Exception {
        String[] taxa = null;
        if (alignment != null) {
            taxa = alignment.getTaxaNames();
        } else if (trees != null && !trees.isEmpty()) {
            taxa = trees.get(0).getTaxaNames();
        }
        NexusBuilder nb = new NexusBuilder(new NexusBlock[0]);
        if (taxa != null) {
            nb.append(new TaxaBlock(taxa));
        }
        if (alignment != null) {
            nb.append(new CharactersBlock(alignment));
        }
        if (trees != null && !trees.isEmpty()) {
            nb.append(new TreesBlock(trees));
        }
        nb.write(pstream);
    }
}

