/*
 * Decompiled with CFR 0.152.
 */
package lphy.nexus;

import java.util.ArrayList;
import java.util.List;
import lphy.evolution.tree.TimeTree;
import lphy.nexus.NexusBlock;

public class TreesBlock
extends NexusBlock {
    private final List<TimeTree> trees;
    private final List<String> names;

    public TreesBlock() {
        this.trees = new ArrayList<TimeTree>();
        this.names = new ArrayList<String>();
    }

    public TreesBlock(List<TimeTree> trees) {
        this.trees = trees;
        this.names = new ArrayList<String>();
        for (int i = 0; i < trees.size(); ++i) {
            this.names.add("TREE_" + i);
        }
    }

    public TreesBlock addTree(TimeTree tree) {
        this.trees.add(tree);
        this.names.add("TREE_" + this.names.size());
        return this;
    }

    public TreesBlock addTree(TimeTree tree, String name) {
        this.trees.add(tree);
        this.names.add(name);
        return this;
    }

    public String getTreeString(TimeTree tree) {
        return tree.toString();
    }

    @Override
    public String getBlockName() {
        return "trees";
    }

    @Override
    public List<String> getBlockLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.trees.isEmpty()) {
            return lines;
        }
        for (int i = 0; i < this.trees.size(); ++i) {
            String newick = this.getTreeString(this.trees.get(i));
            if (newick.endsWith(";")) {
                newick = newick.substring(0, newick.length() - 1);
            }
            lines.add(String.format("tree %s = [&R] %s", this.names.get(i), newick));
        }
        return lines;
    }
}

