/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import lphy.core.functions.BinaryRateMatrix;
import lphy.core.functions.MigrationCount;
import lphy.core.functions.MigrationMatrix;
import lphy.core.functions.Newick;
import lphy.core.functions.NodeCount;
import lphy.core.functions.Range;
import lphy.core.lightweight.distributions.Beta;
import lphy.core.lightweight.distributions.Dirichlet;
import lphy.core.lightweight.distributions.DiscretizedGamma;
import lphy.core.lightweight.distributions.Exp;
import lphy.core.lightweight.distributions.Gamma;
import lphy.core.lightweight.distributions.LogNormal;
import lphy.core.lightweight.distributions.Normal;
import lphy.core.lightweight.distributions.Poisson;
import lphy.evolution.substitutionmodel.GTR;
import lphy.evolution.substitutionmodel.HKY;
import lphy.evolution.substitutionmodel.JukesCantor;
import lphy.evolution.substitutionmodel.K80;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.Value;
import lphy.parser.SimulatorBaseListener;

public class AbstractLightweightBaseListener
extends SimulatorBaseListener {
    Map<String, Value<?>> dictionary;
    static Map<String, Set<Class<?>>> genDistDictionary;
    static Map<String, Set<Class<?>>> functionDictionary;
    static Set<String> bivarOperators;
    static Set<String> univarfunctions;

    static {
        Class[] functionClasses;
        Class[] genClasses;
        genDistDictionary = new TreeMap();
        functionDictionary = new TreeMap();
        for (Class genClass : genClasses = new Class[]{Normal.class, LogNormal.class, Exp.class, Dirichlet.class, Gamma.class, DiscretizedGamma.class, Beta.class, Poisson.class}) {
            String name = Generator.getGeneratorName(genClass);
            Set genDistSet = genDistDictionary.computeIfAbsent(name, k -> new HashSet());
            genDistSet.add(genClass);
        }
        for (Class functionClass : functionClasses = new Class[]{lphy.core.functions.Exp.class, JukesCantor.class, K80.class, HKY.class, GTR.class, Newick.class, BinaryRateMatrix.class, NodeCount.class, MigrationMatrix.class, MigrationCount.class, Range.class}) {
            String name = Generator.getGeneratorName(functionClass);
            Set funcSet = functionDictionary.computeIfAbsent(name, k -> new HashSet());
            funcSet.add(functionClass);
        }
        System.out.println(Arrays.toString(genDistDictionary.keySet().toArray()));
        System.out.println(Arrays.toString(functionDictionary.keySet().toArray()));
    }
}

