/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import java.util.function.Function;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;
import lphy.graphicalModel.types.DoubleArrayValue;
import lphy.graphicalModel.types.DoubleValue;
import lphy.graphicalModel.types.IntegerArray2DValue;
import lphy.graphicalModel.types.IntegerArrayValue;
import lphy.graphicalModel.types.IntegerValue;

public interface ElementWise1Arg<R> {
    public Value apply(R var1, Function var2);

    public static ElementWise1Arg<DoubleValue> elementWiseD() {
        return (a, o) -> {
            Double va = (Double)a.value();
            Double r = (Double)o.apply(va);
            return new DoubleValue("", r);
        };
    }

    public static ElementWise1Arg<DoubleArray2DValue> elementWiseD2() {
        return (a, o) -> {
            Double[][] va = (Double[][])a.value();
            Double[][] r = new Double[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Double)o.apply(va[i][j]);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise1Arg<DoubleArrayValue> elementWiseDA() {
        return (a, o) -> {
            Double[] va = (Double[])a.value();
            Double[] r = new Double[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = (Double)o.apply(va[i]);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise1Arg<IntegerValue> elementWiseI() {
        return (a, o) -> {
            Integer va = (Integer)a.value();
            return new Value(null, o.apply(va));
        };
    }

    public static ElementWise1Arg<IntegerArray2DValue> elementWiseI2() {
        return (a, o) -> {
            Integer[][] va = (Integer[][])a.value();
            Integer[][] r = new Integer[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Integer)o.apply(va[i][j]);
                }
            }
            return new IntegerArray2DValue("", r);
        };
    }

    public static ElementWise1Arg<IntegerArrayValue> elementWiseIA() {
        return (a, o) -> {
            Integer[] va = (Integer[])a.value();
            Integer[] r = new Integer[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = (Integer)o.apply(va[i]);
            }
            return new IntegerArrayValue("", r);
        };
    }

    public static ElementWise1Arg elementFactory(GraphicalModelNode[] values) {
        if (values.length != 1) {
            return null;
        }
        if (values[0].value() instanceof Double[][]) {
            return ElementWise1Arg.elementWiseD2();
        }
        if (values[0].value() instanceof Double[]) {
            return ElementWise1Arg.elementWiseDA();
        }
        if (values[0].value() instanceof Double) {
            return ElementWise1Arg.elementWiseD();
        }
        if (values[0].value() instanceof Integer[][]) {
            return ElementWise1Arg.elementWiseI2();
        }
        if (values[0].value() instanceof Integer[]) {
            return ElementWise1Arg.elementWiseIA();
        }
        if (values[0].value() instanceof Integer) {
            return ElementWise1Arg.elementWiseI();
        }
        return null;
    }
}

