/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import java.util.function.BinaryOperator;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;
import lphy.graphicalModel.types.DoubleArrayValue;
import lphy.graphicalModel.types.DoubleValue;
import lphy.graphicalModel.types.IntegerArray2DValue;
import lphy.graphicalModel.types.IntegerArrayValue;
import lphy.graphicalModel.types.IntegerValue;

public interface ElementWise2Args<R, S> {
    public Value apply(R var1, S var2, BinaryOperator var3);

    public static ElementWise2Args<Value<Double>, Value<Double>> elementWiseDD() {
        return (a, b, o) -> {
            Double va = (Double)a.value();
            Double vb = (Double)b.value();
            Double r = (Double)o.apply(va, vb);
            return new DoubleValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double[][]>, Value<Double[][]>> elementWiseD2D2() {
        return (a, b, o) -> {
            Double[][] va = (Double[][])a.value();
            Double[][] vb = (Double[][])b.value();
            Double[][] r = new Double[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Double)o.apply(va[i][j], vb[i][j]);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double[]>, Value<Double[]>> elementWiseDADA() {
        return (a, b, o) -> {
            Double[] va = (Double[])a.value();
            Double[] vb = (Double[])b.value();
            Double[] r = new Double[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = (Double)o.apply(va[i], vb[i]);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double>, Value<Double[]>> elementWiseDDA() {
        return (a, b, o) -> {
            Double va = (Double)a.value();
            Double[] vb = (Double[])b.value();
            Double[] r = new Double[vb.length];
            for (int i = 0; i < vb.length; ++i) {
                r[i] = (Double)o.apply(va, vb[i]);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double[]>, Value<Double>> elementWiseDAD() {
        return (a, b, o) -> {
            Double[] va = (Double[])a.value();
            Double vb = (Double)b.value();
            Double[] r = new Double[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = (Double)o.apply(va[i], vb);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double>, Value<Double[][]>> elementWiseDD2() {
        return (a, b, o) -> {
            Double va = (Double)a.value();
            Double[][] vb = (Double[][])b.value();
            Double[][] r = new Double[vb.length][vb[0].length];
            for (int i = 0; i < vb.length; ++i) {
                for (int j = 0; j < vb.length; ++j) {
                    r[i][j] = (Double)o.apply(va, vb[i][j]);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double[][]>, Value<Double>> elementWiseD2D() {
        return (a, b, o) -> {
            Double[][] va = (Double[][])a.value();
            Double vb = (Double)b.value();
            Double[][] r = new Double[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Double)o.apply(va[i][j], vb);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer>, Value<Integer>> elementWiseII() {
        return (a, b, o) -> {
            Integer va = (Integer)a.value();
            Integer vb = (Integer)b.value();
            Object result = o.apply(va, vb);
            Integer r = null;
            if (result instanceof Integer) {
                r = (Integer)result;
            } else if (result instanceof Number) {
                r = ((Number)result).intValue();
            }
            return new IntegerValue(null, r);
        };
    }

    public static ElementWise2Args<Value<Integer[][]>, Value<Integer[][]>> elementWiseI2I2() {
        return (a, b, o) -> {
            Integer[][] va = (Integer[][])a.value();
            Integer[][] vb = (Integer[][])b.value();
            Integer[][] r = new Integer[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Integer)o.apply(va[i][j], vb[i][j]);
                }
            }
            return new IntegerArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer[]>, Value<Integer[]>> elementWiseIAIA() {
        return (a, b, o) -> {
            Integer[] va = (Integer[])a.value();
            Integer[] vb = (Integer[])b.value();
            Integer[] r = new Integer[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = (Integer)o.apply(va[i], vb[i]);
            }
            return new IntegerArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer>, Value<Integer[]>> elementWiseIIA() {
        return (a, b, o) -> {
            Integer va = (Integer)a.value();
            Integer[] vb = (Integer[])b.value();
            Integer[] r = new Integer[vb.length];
            for (int i = 0; i < vb.length; ++i) {
                r[i] = (Integer)o.apply(va, vb[i]);
            }
            return new IntegerArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer[]>, Value<Integer>> elementWiseIAI() {
        return (a, b, o) -> {
            Integer[] va = (Integer[])a.value();
            Integer vb = (Integer)b.value();
            Integer[] r = new Integer[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = ((Double)o.apply(va[i], vb)).intValue();
            }
            return new IntegerArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer>, Value<Integer[][]>> elementWiseII2() {
        return (a, b, o) -> {
            Integer va = (Integer)a.value();
            Integer[][] vb = (Integer[][])b.value();
            Integer[][] r = new Integer[vb.length][vb[0].length];
            for (int i = 0; i < vb.length; ++i) {
                for (int j = 0; j < vb.length; ++j) {
                    r[i][j] = (Integer)o.apply(va, vb[i][j]);
                }
            }
            return new IntegerArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer[][]>, Value<Integer>> elementWiseI2I() {
        return (a, b, o) -> {
            Integer[][] va = (Integer[][])a.value();
            Integer vb = (Integer)b.value();
            Integer[][] r = new Integer[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Integer)o.apply(va[i][j], vb);
                }
            }
            return new IntegerArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer>, Value<Double>> elementWiseID() {
        return (a, b, o) -> {
            Integer va = (Integer)a.value();
            Double vb = (Double)b.value();
            Double r = (Double)o.apply(va, vb);
            return new DoubleValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double>, Value<Integer>> elementWiseDI() {
        return (a, b, o) -> {
            Double va = (Double)a.value();
            Integer vb = (Integer)b.value();
            Double r = (Double)o.apply(va, vb);
            return new DoubleValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer>, Value<Double[]>> elementWiseIDA() {
        return (a, b, o) -> {
            Integer va = (Integer)a.value();
            Double[] vb = (Double[])b.value();
            Double[] r = new Double[vb.length];
            for (int i = 0; i < vb.length; ++i) {
                r[i] = (Double)o.apply(va, vb[i]);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double[]>, Value<Integer>> elementWiseDAI() {
        return (a, b, o) -> {
            Double[] va = (Double[])a.value();
            Integer vb = (Integer)b.value();
            Double[] r = new Double[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = (Double)o.apply(va[i], vb);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer>, Value<Double[][]>> elementWiseID2() {
        return (a, b, o) -> {
            Integer va = (Integer)a.value();
            Double[][] vb = (Double[][])b.value();
            Double[][] r = new Double[vb.length][vb[0].length];
            for (int i = 0; i < vb.length; ++i) {
                for (int j = 0; j < vb.length; ++j) {
                    r[i][j] = (Double)o.apply(va, vb[i][j]);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double[][]>, Value<Integer>> elementWiseD2I() {
        return (a, b, o) -> {
            Double[][] va = (Double[][])a.value();
            Integer vb = (Integer)b.value();
            Double[][] r = new Double[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Double)o.apply(va[i][j], vb);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double>, Value<Integer[]>> elementWiseDIA() {
        return (a, b, o) -> {
            Double va = (Double)a.value();
            Integer[] vb = (Integer[])b.value();
            Double[] r = new Double[vb.length];
            for (int i = 0; i < vb.length; ++i) {
                r[i] = (Double)o.apply(va, vb[i]);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer[]>, Value<Double>> elementWiseIAD() {
        return (a, b, o) -> {
            Integer[] va = (Integer[])a.value();
            Double vb = (Double)b.value();
            Double[] r = new Double[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = (Double)o.apply(va[i], vb);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double>, Value<Integer[][]>> elementWiseDI2() {
        return (a, b, o) -> {
            Double va = (Double)a.value();
            Integer[][] vb = (Integer[][])b.value();
            Double[][] r = new Double[vb.length][vb[0].length];
            for (int i = 0; i < vb.length; ++i) {
                for (int j = 0; j < vb.length; ++j) {
                    r[i][j] = (Double)o.apply(va, vb[i][j]);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer[][]>, Value<Double>> elementWiseI2D() {
        return (a, b, o) -> {
            Integer[][] va = (Integer[][])a.value();
            Double vb = (Double)b.value();
            Double[][] r = new Double[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Double)o.apply(va[i][j], vb);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double[]>, Value<Integer[]>> elementWiseDAIA() {
        return (a, b, o) -> {
            Double[] va = (Double[])a.value();
            Integer[] vb = (Integer[])b.value();
            Double[] r = new Double[vb.length];
            for (int i = 0; i < vb.length; ++i) {
                r[i] = (Double)o.apply(va[i], vb[i]);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer[]>, Value<Double[]>> elementWiseIADA() {
        return (a, b, o) -> {
            Integer[] va = (Integer[])a.value();
            Double[] vb = (Double[])b.value();
            Double[] r = new Double[va.length];
            for (int i = 0; i < va.length; ++i) {
                r[i] = (Double)o.apply(va[i], vb[i]);
            }
            return new DoubleArrayValue("", r);
        };
    }

    public static ElementWise2Args<Value<Double[][]>, Value<Integer[][]>> elementWiseD2I2() {
        return (a, b, o) -> {
            Double[][] va = (Double[][])a.value();
            Integer[][] vb = (Integer[][])b.value();
            Double[][] r = new Double[vb.length][vb[0].length];
            for (int i = 0; i < vb.length; ++i) {
                for (int j = 0; j < vb.length; ++j) {
                    r[i][j] = (Double)o.apply(va[i][j], vb[i][j]);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args<Value<Integer[][]>, Value<Double[][]>> elementWiseI2D2() {
        return (a, b, o) -> {
            Integer[][] va = (Integer[][])a.value();
            Double[][] vb = (Double[][])b.value();
            Double[][] r = new Double[va.length][va[0].length];
            for (int i = 0; i < va.length; ++i) {
                for (int j = 0; j < va.length; ++j) {
                    r[i][j] = (Double)o.apply(va[i][j], vb[i][j]);
                }
            }
            return new DoubleArray2DValue("", r);
        };
    }

    public static ElementWise2Args elementFactory(GraphicalModelNode[] values) {
        if (values.length != 2) {
            return null;
        }
        if (values[0].value() instanceof Double[][]) {
            if (values[1].value() instanceof Double[][]) {
                return ElementWise2Args.elementWiseD2D2();
            }
            if (!(values[1].value() instanceof Double[])) {
                if (values[1].value() instanceof Double) {
                    return ElementWise2Args.elementWiseD2D();
                }
                if (values[1].value() instanceof Integer[][]) {
                    return ElementWise2Args.elementWiseD2I2();
                }
                if (!(values[1].value() instanceof Integer[]) && values[1].value() instanceof Integer) {
                    return ElementWise2Args.elementWiseD2I();
                }
            }
        } else if (values[0].value() instanceof Double[]) {
            if (!(values[1].value() instanceof Double[][])) {
                if (values[1].value() instanceof Double[]) {
                    return ElementWise2Args.elementWiseDADA();
                }
                if (values[1].value() instanceof Double) {
                    return ElementWise2Args.elementWiseDAD();
                }
                if (!(values[1].value() instanceof Integer[][])) {
                    if (values[1].value() instanceof Integer[]) {
                        return ElementWise2Args.elementWiseDAIA();
                    }
                    if (values[1].value() instanceof Integer) {
                        return ElementWise2Args.elementWiseDAI();
                    }
                }
            }
        } else if (values[0].value() instanceof Double) {
            if (values[1].value() instanceof Double[][]) {
                return ElementWise2Args.elementWiseDD2();
            }
            if (values[1].value() instanceof Double[]) {
                return ElementWise2Args.elementWiseDDA();
            }
            if (values[1].value() instanceof Double) {
                return ElementWise2Args.elementWiseDD();
            }
            if (values[1].value() instanceof Integer[][]) {
                return ElementWise2Args.elementWiseDI2();
            }
            if (values[1].value() instanceof Integer[]) {
                return ElementWise2Args.elementWiseDIA();
            }
            if (values[1].value() instanceof Integer) {
                return ElementWise2Args.elementWiseDI();
            }
        } else if (values[0].value() instanceof Integer[][]) {
            if (values[1].value() instanceof Double[][]) {
                return ElementWise2Args.elementWiseI2D2();
            }
            if (!(values[1].value() instanceof Double[])) {
                if (values[1].value() instanceof Double) {
                    return ElementWise2Args.elementWiseI2D();
                }
                if (values[1].value() instanceof Integer[][]) {
                    return ElementWise2Args.elementWiseI2I2();
                }
                if (!(values[1].value() instanceof Integer[]) && values[1].value() instanceof Integer) {
                    return ElementWise2Args.elementWiseI2I();
                }
            }
        } else if (values[0].value() instanceof Integer[]) {
            if (!(values[1].value() instanceof Double[][])) {
                if (values[1].value() instanceof Double[]) {
                    return ElementWise2Args.elementWiseIADA();
                }
                if (values[1].value() instanceof Double) {
                    return ElementWise2Args.elementWiseIAD();
                }
                if (!(values[1].value() instanceof Integer[][])) {
                    if (values[1].value() instanceof Integer[]) {
                        return ElementWise2Args.elementWiseIAIA();
                    }
                    if (values[1].value() instanceof Integer) {
                        return ElementWise2Args.elementWiseIAI();
                    }
                }
            }
        } else if (values[0].value() instanceof Integer) {
            if (values[1].value() instanceof Double[][]) {
                return ElementWise2Args.elementWiseID2();
            }
            if (values[1].value() instanceof Double[]) {
                return ElementWise2Args.elementWiseIDA();
            }
            if (values[1].value() instanceof Double) {
                return ElementWise2Args.elementWiseID();
            }
            if (values[1].value() instanceof Integer[][]) {
                return ElementWise2Args.elementWiseII2();
            }
            if (values[1].value() instanceof Integer[]) {
                return ElementWise2Args.elementWiseIIA();
            }
            if (values[1].value() instanceof Integer) {
                return ElementWise2Args.elementWiseII();
            }
        }
        return null;
    }
}

