/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jebl.evolution.sequences.SequenceType;
import lphy.LPhyExtensionFactory;
import lphy.core.distributions.IID;
import lphy.core.distributions.VectorizedDistribution;
import lphy.core.functions.VectorizedFunction;
import lphy.evolution.datatype.SequenceTypeFactory;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.Value;
import lphy.util.LoggerUtils;

public class ParserUtils {
    static Map<String, Set<Class<?>>> genDistDictionary;
    static Map<String, Set<Class<?>>> functionDictionary;
    public static Set<String> bivarOperators;
    static Set<String> univarfunctions;
    public static TreeSet<Class<?>> types;

    public static List<Generator> getMatchingFunctions(String name, Value[] values) {
        ArrayList<Generator> matches = new ArrayList<Generator>();
        for (Class<?> functionClass : ParserUtils.getFunctionClasses(name)) {
            matches.addAll(ParserUtils.getFunctionByArguments(name, values, functionClass));
        }
        return matches;
    }

    public static List<Generator> getMatchingFunctions(String name, Map<String, Value> arguments) {
        ArrayList<Generator> matches = new ArrayList<Generator>();
        for (Class<?> functionClass : ParserUtils.getFunctionClasses(name)) {
            matches.addAll(ParserUtils.getGeneratorByArguments(name, arguments, functionClass));
        }
        return matches;
    }

    public static List<Generator> getMatchingGenerativeDistributions(String name, Map<String, Value> arguments) {
        ArrayList<Generator> matches = new ArrayList<Generator>();
        Set<Class<?>> generators = ParserUtils.getGenerativeDistributionClasses(name);
        if (generators != null) {
            for (Class<?> genClass : ParserUtils.getGenerativeDistributionClasses(name)) {
                matches.addAll(ParserUtils.getGeneratorByArguments(name, arguments, genClass));
            }
        } else {
            LoggerUtils.log.severe("No generator with name " + name + " available.");
        }
        return matches;
    }

    public static List<Generator> getGeneratorByArguments(String name, Map<String, Value> arguments, Class generatorClass) {
        ArrayList<Generator> matches = new ArrayList<Generator>();
        for (Constructor<?> constructor : generatorClass.getConstructors()) {
            List<Argument> argumentInfo = Generator.getArguments(constructor);
            ArrayList<Value> initargs = new ArrayList<Value>();
            if (!ParserUtils.match(arguments, argumentInfo)) continue;
            for (int i = 0; i < argumentInfo.size(); ++i) {
                Value arg = arguments.get(argumentInfo.get((int)i).name);
                if (arg != null) {
                    initargs.add(arg);
                    continue;
                }
                if (!argumentInfo.get((int)i).optional) {
                    throw new RuntimeException("Required argument " + argumentInfo.get((int)i).name + " not found!");
                }
                initargs.add(null);
            }
            matches.add(ParserUtils.constructGenerator(name, constructor, argumentInfo, initargs.toArray(), arguments, false));
        }
        return matches;
    }

    private static boolean match(Map<String, Value> arguments, List<Argument> argumentInfo) {
        TreeSet<String> requiredArguments = new TreeSet<String>();
        TreeSet<String> optionalArguments = new TreeSet<String>();
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(arguments.keySet());
        for (Argument argumentInf : argumentInfo) {
            if (argumentInf.optional) {
                optionalArguments.add(argumentInf.name);
                continue;
            }
            requiredArguments.add(argumentInf.name);
        }
        if (!keys.containsAll(requiredArguments)) {
            return false;
        }
        keys.removeAll(requiredArguments);
        keys.removeAll(optionalArguments);
        return keys.size() == 0 || keys.size() == 1 && keys.contains("replicates");
    }

    private static List<DeterministicFunction> getFunctionByArguments(String name, Value[] values, Class generatorClass) {
        ArrayList<DeterministicFunction> matches = new ArrayList<DeterministicFunction>();
        for (Constructor<?> constructor : generatorClass.getConstructors()) {
            DeterministicFunction f;
            List<Argument> arguments = Generator.getArguments(constructor);
            if (values.length == arguments.size() && (values.length == 1 || values.length == 2)) {
                f = (DeterministicFunction)ParserUtils.constructGenerator(name, constructor, arguments, values, null, false);
                if (f == null) continue;
                matches.add(f);
                continue;
            }
            if (values.length != 0 || !arguments.stream().allMatch(x -> x.optional) || (f = (DeterministicFunction)ParserUtils.constructGenerator(name, constructor, arguments, new Object[arguments.size()], null, false)) == null) continue;
            matches.add(f);
        }
        return matches;
    }

    private static Generator constructGenerator(String name, Constructor constructor, List<Argument> arguments, Object[] initargs, Map<String, Value> params, boolean lightweight) {
        try {
            if (Generator.matchingParameterTypes(arguments, initargs, params, lightweight)) {
                return (Generator)constructor.newInstance(initargs);
            }
            if (IID.match(constructor, arguments, initargs, params)) {
                return new IID(constructor, initargs, params);
            }
            if (ParserUtils.vectorMatch(arguments, initargs) > 0) {
                return ParserUtils.vectorGenerator(constructor, arguments, initargs);
            }
            throw new RuntimeException("ERROR! No match, including vector match!");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            LoggerUtils.log.severe("Parsing generator " + name + " failed.");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            LoggerUtils.log.severe("Parsing generator " + name + " failed.");
        }
        catch (InvocationTargetException e) {
            LoggerUtils.log.severe("Parsing generator " + name + " failed.");
        }
        return null;
    }

    public static int vectorMatch(List<Argument> arguments, Object[] initargs) {
        int vectorMatches = 0;
        for (int i = 0; i < arguments.size(); ++i) {
            Argument argument = arguments.get(i);
            Value argValue = (Value)initargs[i];
            if (argValue == null) {
                if (argument.optional) continue;
                return 0;
            }
            if (argument.type.isAssignableFrom(argValue.value().getClass()) || !argValue.value().getClass().isArray() || !argument.type.isAssignableFrom(argValue.value().getClass().getComponentType())) continue;
            ++vectorMatches;
        }
        return vectorMatches;
    }

    public static Generator vectorGenerator(Constructor constructor, List<Argument> arguments, Object[] vectorArgs) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (GenerativeDistribution.class.isAssignableFrom(constructor.getDeclaringClass())) {
            return new VectorizedDistribution(constructor, arguments, vectorArgs);
        }
        if (DeterministicFunction.class.isAssignableFrom(constructor.getDeclaringClass())) {
            return new VectorizedFunction(constructor, arguments, vectorArgs);
        }
        throw new IllegalArgumentException("Unexpected Generator class! Expecting a GenerativeDistribution or a DeterministicFunction");
    }

    private static Set<Class<?>> getGenerativeDistributionClasses(String name) {
        return genDistDictionary.get(name);
    }

    static Set<Class<?>> getFunctionClasses(String name) {
        return functionDictionary.get(name);
    }

    public static List<Class<GenerativeDistribution>> getGenerativeDistributions() {
        ArrayList<Class<GenerativeDistribution>> genDists = new ArrayList<Class<GenerativeDistribution>>();
        for (Set<Class<?>> classes : genDistDictionary.values()) {
            for (Class<?> c : classes) {
                genDists.add(c);
            }
        }
        return genDists;
    }

    public static List<Class<DeterministicFunction>> getDeterministicFunctions() {
        ArrayList<Class<DeterministicFunction>> functions = new ArrayList<Class<DeterministicFunction>>();
        for (Set<Class<?>> classes : functionDictionary.values()) {
            for (Class<?> c : classes) {
                functions.add(c);
            }
        }
        return functions;
    }

    static {
        LPhyExtensionFactory factory = LPhyExtensionFactory.getInstance();
        genDistDictionary = factory.genDistDictionary;
        functionDictionary = factory.functionDictionary;
        types = factory.types;
        bivarOperators = new HashSet<String>();
        for (String s : new String[]{"+", "-", "*", "/", "**", "&&", "||", "<=", "<", ">=", ">", "%", ":", "^", "!=", "==", "&", "|", "<<", ">>", ">>>"}) {
            bivarOperators.add(s);
        }
        univarfunctions = new HashSet<String>();
        for (String s : new String[]{"abs", "acos", "acosh", "asin", "asinh", "atan", "atanh", "cLogLog", "cbrt", "ceil", "cos", "cosh", "exp", "expm1", "floor", "log", "log10", "log1p", "logFact", "logGamma", "logit", "phi", "probit", "round", "signum", "sin", "sinh", "sqrt", "step", "tan", "tanh"}) {
            univarfunctions.add(s);
        }
        Map<String, SequenceType> dataTypeMap = factory.dataTypeMap;
        SequenceTypeFactory.INSTANCE.setDataTypeMap(dataTypeMap);
    }
}

