/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import lphy.core.LPhyParser;
import lphy.core.Script;
import lphy.graphicalModel.Command;
import lphy.graphicalModel.GraphicalModel;
import lphy.graphicalModel.Value;
import lphy.parser.ParserUtils;
import lphy.parser.SimulatorListenerImpl;
import lphy.parser.SimulatorParsingException;

public class REPL
implements LPhyParser {
    SortedMap<String, Value<?>> modelDictionary = new TreeMap();
    SortedMap<String, Value<?>> dataDictionary = new TreeMap();
    Set<Value> modelValues = new HashSet<Value>();
    Set<Value> dataValues = new HashSet<Value>();
    String name = null;
    SortedMap<String, Command> commands = new TreeMap<String, Command>();
    private List<String> lines = new ArrayList<String>();

    public void doREPL() {
        while (true) {
            System.out.print(">");
            try {
                String cmd = new BufferedReader(new InputStreamReader(System.in)).readLine();
                this.parse(cmd);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Value<?>> getDataDictionary() {
        return this.dataDictionary;
    }

    @Override
    public Map<String, Value<?>> getModelDictionary() {
        return this.modelDictionary;
    }

    @Override
    public Set<Value> getModelValues() {
        return this.modelValues;
    }

    @Override
    public Set<Value> getDataValues() {
        return this.dataValues;
    }

    @Override
    public void parse(String cmd, GraphicalModel.Context context) throws SimulatorParsingException {
        if (cmd == null) {
            return;
        }
        String commandString = cmd;
        boolean[] found = new boolean[1];
        this.commands.forEach((key, command) -> {
            if (commandString.startsWith((String)key)) {
                command.execute(commandString, this);
                found[0] = true;
            }
        });
        if (!found[0]) {
            if (((String)cmd).trim().length() == 0) {
                return;
            }
            if (!((String)cmd).startsWith("?")) {
                SimulatorListenerImpl parser = new SimulatorListenerImpl(this, context);
                if (!((String)cmd).endsWith(";")) {
                    cmd = (String)cmd + ";";
                }
                Object o = parser.parse((String)cmd);
                this.lines.add((String)cmd);
                GraphicalModel.Utils.wrapExpressionNodes(this);
            } else {
                throw new RuntimeException();
            }
        }
    }

    @Override
    public Map<String, Set<Class<?>>> getGeneratorClasses() {
        TreeMap generatorClasses = new TreeMap();
        generatorClasses.putAll(ParserUtils.genDistDictionary);
        generatorClasses.putAll(ParserUtils.functionDictionary);
        return generatorClasses;
    }

    @Override
    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public void clear() {
        this.dataDictionary.clear();
        this.modelDictionary.clear();
        this.lines.clear();
        this.dataValues.clear();
        this.modelValues.clear();
    }

    @Override
    public void source(BufferedReader reader) throws IOException {
        Script script = Script.loadLPhyScript(reader);
        this.parse(script.dataLines, GraphicalModel.Context.data);
        this.parse(script.modelLines, GraphicalModel.Context.model);
        reader.close();
    }

    public static void main(String[] args) {
        System.out.println("A  simple Read-Eval-Print-Loop for the lphy language ");
        REPL repl = new REPL();
        repl.doREPL();
    }
}

