/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lphy.core.LPhyParser;
import lphy.core.functions.ArrayFunction;
import lphy.core.functions.BooleanArray;
import lphy.core.functions.DoubleArray;
import lphy.core.functions.IntegerArray;
import lphy.core.functions.NumberArray;
import lphy.core.functions.Range;
import lphy.core.functions.StringArray;
import lphy.graphicalModel.ArgumentValue;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GraphicalModel;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.RangeElement;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import lphy.graphicalModel.types.BooleanArray2DValue;
import lphy.graphicalModel.types.BooleanArrayValue;
import lphy.graphicalModel.types.BooleanValue;
import lphy.graphicalModel.types.DoubleArray2DValue;
import lphy.graphicalModel.types.DoubleArrayValue;
import lphy.graphicalModel.types.DoubleValue;
import lphy.graphicalModel.types.IntegerArray2DValue;
import lphy.graphicalModel.types.IntegerArrayValue;
import lphy.graphicalModel.types.IntegerValue;
import lphy.graphicalModel.types.NumberArrayValue;
import lphy.graphicalModel.types.StringArray2DValue;
import lphy.graphicalModel.types.StringArrayValue;
import lphy.graphicalModel.types.StringValue;
import lphy.parser.ParserUtils;
import lphy.parser.REPL;
import lphy.parser.SimulatorBaseListener;
import lphy.parser.SimulatorBaseVisitor;
import lphy.parser.SimulatorLexer;
import lphy.parser.SimulatorParser;
import lphy.parser.SimulatorParsingException;
import lphy.parser.Var;
import lphy.parser.functions.ExpressionNode;
import lphy.parser.functions.ExpressionNode1Arg;
import lphy.parser.functions.ExpressionNode2Args;
import lphy.parser.functions.MapFunction;
import lphy.parser.functions.MethodCall;
import lphy.parser.functions.RangeList;
import lphy.util.LoggerUtils;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class SimulatorListenerImpl
extends SimulatorBaseListener {
    GraphicalModel.Context context;
    LPhyParser parser;

    public SimulatorListenerImpl(LPhyParser parser, GraphicalModel.Context context) {
        this.parser = parser;
        this.context = context;
    }

    private void put(String id, Value val) {
        switch (this.context) {
            case data: {
                this.parser.getDataDictionary().put(id, val);
                this.parser.getDataValues().add(val);
                break;
            }
            default: {
                this.parser.getModelDictionary().put(id, val);
                this.parser.getModelValues().add(val);
            }
        }
    }

    private Value<?> get(String id) {
        return this.parser.getValue(id, this.context);
    }

    private boolean containsKey(String id) {
        return this.parser.hasValue(id, this.context);
    }

    private boolean allConstants(Value[] var) {
        for (Value v : var) {
            if (v == null || v.isConstant()) continue;
            return false;
        }
        return true;
    }

    public Object parse(String CASentence) {
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                e.printStackTrace();
                if (e instanceof NoViableAltException) {
                    NoViableAltException nvae = (NoViableAltException)e;
                    System.out.println(nvae.getLocalizedMessage());
                }
                throw new SimulatorParsingException(msg, charPositionInLine, line);
            }
        };
        SimulatorLexer lexer = new SimulatorLexer((CharStream)CharStreams.fromString((String)CASentence));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SimulatorParser parser = new SimulatorParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        SimulatorParser.InputContext parseTree = parser.input();
        SimulatorASTVisitor visitor = new SimulatorASTVisitor();
        return visitor.visit((ParseTree)parseTree);
    }

    public static void main(String[] args) throws IOException {
        StringBuffer buf;
        BufferedReader fin;
        SimulatorListenerImpl parser;
        if (args.length == 1) {
            parser = new SimulatorListenerImpl(new REPL(), GraphicalModel.Context.model);
            fin = new BufferedReader(new FileReader(args[0]));
            buf = new StringBuffer();
            String str = null;
            while (fin.ready()) {
                str = fin.readLine();
                buf.append(str);
                buf.append('\n');
            }
        } else {
            throw new IllegalArgumentException("Expected 1 argument: a file name");
        }
        fin.close();
        Object o = parser.parse(buf.toString());
        System.err.println("OK Done!");
    }

    public class SimulatorASTVisitor
    extends SimulatorBaseVisitor<Object> {
        @Override
        public Object visitRange_list(SimulatorParser.Range_listContext ctx) {
            ArrayList<GraphicalModelNode> nodes = new ArrayList<GraphicalModelNode>();
            for (int i = 0; i < ctx.getChildCount(); ++i) {
                Object o = this.visit(ctx.getChild(i));
                if (o instanceof IntegerValue || o instanceof IntegerArrayValue || o instanceof Range) {
                    nodes.add((GraphicalModelNode)o);
                    continue;
                }
                if (o instanceof DeterministicFunction) {
                    DeterministicFunction f = (DeterministicFunction)o;
                    if (f.value() instanceof Integer || f.value() instanceof Integer[]) {
                        nodes.add((GraphicalModelNode)o);
                        continue;
                    }
                    LoggerUtils.log.severe("Expected function returning Integer or Integer[]: " + o);
                    throw new SimulatorParsingException("Expected function returning Integer or Integer[]:  " + o == null ? "null" : o.getClass().getName(), ctx);
                }
                if (o == null) continue;
                LoggerUtils.log.severe("Expected Integer value, or Range, in range list, but found: " + o);
                throw new SimulatorParsingException("Expected Integer value, or Range, in range list, but don't know how to handle " + o == null ? "null" : o.getClass().getName(), ctx);
            }
            return new RangeList(nodes.toArray(new GraphicalModelNode[0]));
        }

        @Override
        public RangeElement visitRange_element(SimulatorParser.Range_elementContext ctx) {
            Object o = this.visitChildren((RuleNode)ctx);
            if (o instanceof RangeElement) {
                return (RangeElement)o;
            }
            LoggerUtils.log.severe("Expected Integer value, or Range, in range element, but found: " + o);
            throw new SimulatorParsingException("Expected integer value, or range, but don't know how to handle " + (o == null ? "null" : o.getClass().getName()), ctx);
        }

        @Override
        public Value visitConstant(SimulatorParser.ConstantContext ctx) {
            String text = ctx.getText();
            if (text.startsWith("\"")) {
                return new StringValue(null, this.stripQuotes(text));
            }
            try {
                long aLong = Long.parseLong(text);
                return new IntegerValue(null, (int)aLong);
            }
            catch (NumberFormatException e) {
                try {
                    double d = Double.parseDouble(text);
                    return new DoubleValue(null, d);
                }
                catch (NumberFormatException e2) {
                    boolean bool = Boolean.parseBoolean(text);
                    return new BooleanValue(null, bool);
                }
            }
        }

        private String stripQuotes(String stringWithQuotes) {
            if (stringWithQuotes.startsWith("\"") && stringWithQuotes.endsWith("\"")) {
                return stringWithQuotes.substring(1, stringWithQuotes.length() - 1);
            }
            throw new RuntimeException("Attempted to strip quotes, but the string was not quoted.");
        }

        @Override
        public Value visitDeterm_relation(SimulatorParser.Determ_relationContext ctx) {
            LoggerUtils.log.fine(" visitDeterm_relation");
            Object expr = this.visit(ctx.getChild(2));
            Var var = (Var)this.visit((ParseTree)ctx.children.get(0));
            String id = var.id;
            if (expr instanceof DeterministicFunction) {
                DeterministicFunction f = (DeterministicFunction)expr;
                Value value = f.apply();
                var.assign(value, f, SimulatorListenerImpl.this.context);
                return value;
            }
            if (expr instanceof Value) {
                Value value = (Value)expr;
                var.assign(value, null, SimulatorListenerImpl.this.context);
                return value;
            }
            LoggerUtils.log.severe("in visitDeterm_relation() expecting a function or a value!");
            return null;
        }

        @Override
        public Value visitStoch_relation(SimulatorParser.Stoch_relationContext ctx) {
            if (SimulatorListenerImpl.this.context == GraphicalModel.Context.data) {
                throw new SimulatorParsingException("Generative distributions are not allowed in the data block!", ctx);
            }
            GenerativeDistribution genDist = (GenerativeDistribution)this.visit(ctx.getChild(2));
            Var var = (Var)this.visit(ctx.getChild(0));
            RandomVariable variable = genDist.sample(var.id);
            if (!var.isRangedVar()) {
                SimulatorListenerImpl.this.put(variable.getId(), variable);
                return variable;
            }
            throw new SimulatorParsingException("Ranged variables are not currently handled!", ctx);
        }

        protected Object aggregateResult(Object aggregate, Object nextResult) {
            if (nextResult != null) {
                return nextResult;
            }
            return aggregate;
        }

        @Override
        public Var visitVar(SimulatorParser.VarContext ctx) {
            String id = ctx.getChild(0).getText();
            if (ctx.getChildCount() > 1) {
                Object o = this.visit(ctx.getChild(2));
                if (o instanceof RangeList) {
                    return new Var(id, (RangeList)o, SimulatorListenerImpl.this.parser);
                }
                throw new SimulatorParsingException("Expected variable id, or id and range list", ctx);
            }
            return new Var(id, SimulatorListenerImpl.this.parser);
        }

        private Object visitIndexRange(SimulatorParser.ExpressionContext ctx) {
            Object child = this.visit(ctx.getChild(0));
            Value array = new ValueOrFunction(child, ctx).getValue();
            if (!array.value().getClass().isArray()) {
                throw new SimulatorParsingException("Expected value " + array + " to be an array.", ctx);
            }
            RangeList rangeList = (RangeList)this.visit(ctx.getChild(2));
            return Var.getIndexedValue(array, rangeList);
        }

        @Override
        public Object visitExpression(SimulatorParser.ExpressionContext ctx) {
            if (ctx.getChildCount() == 1) {
                ParseTree childContext = ctx.getChild(0);
                if (childContext.getText().startsWith("{")) {
                    Object obj = this.visit(childContext);
                    return obj;
                }
                String key = childContext.getText();
                if (SimulatorListenerImpl.this.containsKey(key)) {
                    return SimulatorListenerImpl.this.get(key);
                }
            }
            ExpressionNode expression = null;
            if (ctx.getChildCount() >= 2) {
                String s = ctx.getChild(1).getText();
                if (s.equals("[")) {
                    return this.visitIndexRange(ctx);
                }
                if (ParserUtils.bivarOperators.contains(s)) {
                    Value f1 = new ValueOrFunction(this.visit(ctx.getChild(0)), ctx).getValue();
                    Value f2 = new ValueOrFunction(this.visit(ctx.getChild(ctx.getChildCount() - 1)), ctx).getValue();
                    block19 : switch (s) {
                        case "+": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.plus(), f1, f2);
                            break;
                        }
                        case "-": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.minus(), f1, f2);
                            break;
                        }
                        case "*": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.times(), f1, f2);
                            break;
                        }
                        case "/": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.divide(), f1, f2);
                            break;
                        }
                        case "**": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.pow(), f1, f2);
                            break;
                        }
                        case "&&": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.and(), f1, f2);
                            break;
                        }
                        case "||": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.or(), f1, f2);
                            break;
                        }
                        case "<=": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.le(), f1, f2);
                            break;
                        }
                        case "<": {
                            switch (ctx.getChildCount()) {
                                case 3: {
                                    expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.less(), f1, f2);
                                    break block19;
                                }
                            }
                            break;
                        }
                        case ">=": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.ge(), f1, f2);
                            break;
                        }
                        case ">": {
                            switch (ctx.getChildCount()) {
                                case 3: {
                                    expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.greater(), f1, f2);
                                    break block19;
                                }
                            }
                            break;
                        }
                        case "!=": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.ne(), f1, f2);
                            break;
                        }
                        case "==": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.equals(), f1, f2);
                            break;
                        }
                        case "%": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.mod(), f1, f2);
                            break;
                        }
                        case "&": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.bitwiseand(), f1, f2);
                            break;
                        }
                        case "|": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.bitwiseor(), f1, f2);
                            break;
                        }
                        case ":": {
                            return new Range(f1, f2);
                        }
                    }
                    return expression;
                }
                s = ctx.getChild(0).getText();
                if (s.equals("!")) {
                    Value f1 = (Value)this.visit(ctx.getChild(2));
                    expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.not(), f1);
                    return expression;
                }
                if (s.equals("[")) {
                    Value[] var = (Value[])this.visit(ctx.getChild(1));
                    Class<?> type = ValueUtils.getType(var);
                    if (type == Double.class) {
                        if (SimulatorListenerImpl.this.allConstants(var)) {
                            Double[] value = new Double[var.length];
                            for (int i = 0; i < value.length; ++i) {
                                if (var[i] == null) continue;
                                value[i] = (Double)var[i].value();
                            }
                            return new DoubleArrayValue(null, value);
                        }
                        DoubleArray doubleArray = new DoubleArray(var);
                        return doubleArray.apply();
                    }
                    if (type == Double[].class) {
                        Double[][] value = new Double[var.length][];
                        for (int i = 0; i < value.length; ++i) {
                            if (var[i] == null) continue;
                            value[i] = (Double[])var[i].value();
                        }
                        return new DoubleArray2DValue(null, value);
                    }
                    if (type == Integer[].class) {
                        Integer[][] value = new Integer[var.length][];
                        for (int i = 0; i < value.length; ++i) {
                            if (var[i] == null) continue;
                            value[i] = (Integer[])var[i].value();
                        }
                        return new IntegerArray2DValue(null, value);
                    }
                    if (type == Integer.class) {
                        if (SimulatorListenerImpl.this.allConstants(var)) {
                            Integer[] value = new Integer[var.length];
                            for (int i = 0; i < value.length; ++i) {
                                if (var[i] == null) continue;
                                value[i] = (Integer)var[i].value();
                            }
                            return new IntegerArrayValue(null, value);
                        }
                        IntegerArray intArray = new IntegerArray(var);
                        return intArray.apply();
                    }
                    if (type == Boolean[].class) {
                        Boolean[][] value = new Boolean[var.length][];
                        for (int i = 0; i < value.length; ++i) {
                            if (var[i] == null) continue;
                            value[i] = (Boolean[])var[i].value();
                        }
                        BooleanArray2DValue v = new BooleanArray2DValue(null, value);
                        return v;
                    }
                    if (type == Boolean.class) {
                        if (SimulatorListenerImpl.this.allConstants(var)) {
                            Boolean[] value = new Boolean[var.length];
                            for (int i = 0; i < value.length; ++i) {
                                if (var[i] == null) continue;
                                value[i] = (Boolean)var[i].value();
                            }
                            BooleanArrayValue v = new BooleanArrayValue(null, value);
                            return v;
                        }
                        BooleanArray booleanArray = new BooleanArray(var);
                        return booleanArray.apply();
                    }
                    if (type == String[].class) {
                        String[][] value = new String[var.length][];
                        for (int i = 0; i < value.length; ++i) {
                            if (var[i] == null) continue;
                            value[i] = (String[])var[i].value();
                        }
                        StringArray2DValue v = new StringArray2DValue(null, value);
                        return v;
                    }
                    if (type == String.class) {
                        if (SimulatorListenerImpl.this.allConstants(var)) {
                            String[] value = new String[var.length];
                            for (int i = 0; i < value.length; ++i) {
                                value[i] = (String)var[i].value();
                            }
                            StringArrayValue v = new StringArrayValue(null, value);
                            return v;
                        }
                        StringArray stringArray = new StringArray(var);
                        return stringArray.apply();
                    }
                    if (type == Number.class) {
                        if (SimulatorListenerImpl.this.allConstants(var)) {
                            Number[] value = new Number[var.length];
                            for (int i = 0; i < value.length; ++i) {
                                value[i] = (Number)var[i].value();
                            }
                            NumberArrayValue v = new NumberArrayValue(null, value);
                            return v;
                        }
                        NumberArray numberArray = new NumberArray(var);
                        return numberArray.apply();
                    }
                    ArrayFunction arrayFunction = new ArrayFunction(var);
                    return arrayFunction.apply();
                }
            }
            return super.visitExpression(ctx);
        }

        @Override
        public Object visitNamed_expression(SimulatorParser.Named_expressionContext ctx) {
            String name = ctx.getChild(0).getText();
            Object obj = this.visit(ctx.getChild(2));
            if (obj instanceof DeterministicFunction) {
                Value value = ((DeterministicFunction)obj).apply();
                value.setFunction((DeterministicFunction)obj);
                ArgumentValue v = new ArgumentValue(name, value, SimulatorListenerImpl.this.parser, SimulatorListenerImpl.this.context);
                return v;
            }
            if (obj instanceof Value) {
                Value value = (Value)obj;
                ArgumentValue v = new ArgumentValue(name, value, SimulatorListenerImpl.this.parser, SimulatorListenerImpl.this.context);
                return v;
            }
            return obj;
        }

        @Override
        public Object visitDistribution(SimulatorParser.DistributionContext ctx) {
            String name = ctx.getChild(0).getText();
            ArgumentValue[] f = (ArgumentValue[])this.visit(ctx.getChild(2));
            HashMap<String, Value> arguments = new HashMap<String, Value>();
            for (int i = 0; i < f.length; ++i) {
                ArgumentValue v = f[i];
                if (v == null) {
                    throw new SimulatorParsingException("Argument " + i + " unexpectedly null", ctx);
                }
                arguments.put(v.getName(), v.getValue());
            }
            List<Generator> matches = ParserUtils.getMatchingGenerativeDistributions(name, arguments);
            switch (matches.size()) {
                case 0: {
                    throw new SimulatorParsingException("No generative distribution named " + name + " found matching arguments " + arguments, ctx);
                }
            }
            if (matches.size() > 1) {
                LoggerUtils.log.warning("Found " + matches.size() + " matches for " + name + ". Picking first one!");
            }
            Generator generator = matches.get(0);
            for (Map.Entry entry : arguments.entrySet()) {
                generator.setInput((String)entry.getKey(), (Value)entry.getValue());
            }
            return generator;
        }

        @Override
        public Object visitFor_loop(SimulatorParser.For_loopContext ctx) {
            Integer[] intRange;
            ParseTree counter = ctx.getChild(0);
            String name = counter.getChild(2).getText();
            GraphicalModelNode range = (GraphicalModelNode)this.visit(counter.getChild(4));
            Object rangeValue = range.value();
            if (rangeValue instanceof Integer[]) {
                intRange = (Integer[])rangeValue;
            } else if (rangeValue instanceof Integer) {
                intRange = new Integer[]{(Integer)rangeValue};
            } else {
                throw new SimulatorParsingException("Unexpected type of range element in for loop: " + rangeValue, ctx);
            }
            final String forLoopName = "for " + name + " in " + Arrays.toString((Object[])((Integer[])rangeValue));
            for (Integer i : intRange) {
                SimulatorListenerImpl.this.put(name, new IntegerValue(name, i, null));
                ParseTree relations = ctx.getChild(1);
                this.visit(relations);
            }
            return new Object(){

                public String toString() {
                    return forLoopName;
                }
            };
        }

        @Override
        public Object visitExpression_list(SimulatorParser.Expression_listContext ctx) {
            ArrayList<ArgumentValue> list = new ArrayList<ArgumentValue>();
            for (int i = 0; i < ctx.getChildCount(); i += 2) {
                list.add((ArgumentValue)this.visit(ctx.getChild(i)));
            }
            return list.toArray(new ArgumentValue[0]);
        }

        @Override
        public Object visitUnnamed_expression_list(SimulatorParser.Unnamed_expression_listContext ctx) {
            ArrayList<Value> list = new ArrayList<Value>();
            for (int i = 0; i < ctx.getChildCount(); i += 2) {
                Value value;
                Object obj = this.visit(ctx.getChild(i));
                if (obj instanceof DeterministicFunction) {
                    value = ((DeterministicFunction)obj).apply();
                    value.setFunction((DeterministicFunction)obj);
                    list.add(value);
                    continue;
                }
                if (obj instanceof Value) {
                    value = (Value)obj;
                    list.add(value);
                    continue;
                }
                if (obj == null) {
                    list.add(null);
                    continue;
                }
                throw new SimulatorParsingException("Found a non-value, non-function in unnamed expression list: " + obj, ctx);
            }
            return list.toArray(new Value[0]);
        }

        @Override
        public Object visitMapFunction(SimulatorParser.MapFunctionContext ctx) {
            ParseTree ctx1 = ctx.getChild(1);
            LoggerUtils.log.info("parsing a map expression: " + ctx1.getText());
            ArgumentValue[] argumentObject = (ArgumentValue[])this.visit(ctx1);
            MapFunction generator = new MapFunction(argumentObject);
            return generator;
        }

        @Override
        public Object visitObjectMethodCall(SimulatorParser.ObjectMethodCallContext ctx) {
            Var var = (Var)this.visit((ParseTree)ctx.children.get(0));
            String methodName = ((ParseTree)ctx.children.get(2)).getText();
            Value<Object> value = null;
            value = !var.isRangedVar() ? SimulatorListenerImpl.this.get(var.id) : Var.getIndexedValue(SimulatorListenerImpl.this.get(var.id), var.rangeList).apply();
            if (value == null) {
                throw new SimulatorParsingException("Value " + ((ParseTree)ctx.children.get(0)).getText() + " not found for method call " + methodName, ctx);
            }
            ParseTree ctx2 = ctx.getChild(4);
            Value[] f1 = new Value[]{};
            Object argumentObject = null;
            ArgumentValue[] argumentValues = null;
            if (ctx2.getText().equals(")")) {
                f1 = new Value[]{};
            } else {
                argumentObject = this.visit(ctx2);
                if (argumentObject instanceof Value[]) {
                    f1 = (Value[])argumentObject;
                } else if (argumentObject instanceof ArgumentValue[]) {
                    argumentValues = (ArgumentValue[])argumentObject;
                    f1 = new Value[argumentValues.length];
                    for (int i = 0; i < argumentValues.length; ++i) {
                        f1[i] = argumentValues[i].getValue();
                    }
                }
            }
            try {
                return new MethodCall(methodName, value, f1);
            }
            catch (NoSuchMethodException e) {
                LoggerUtils.log.severe("Method call " + methodName + " failed on object " + value.getId());
                throw new SimulatorParsingException(e.getMessage(), ctx);
            }
        }

        @Override
        public Object visitMethodCall(SimulatorParser.MethodCallContext ctx) {
            String functionName = ((ParseTree)ctx.children.get(0)).getText();
            ParseTree ctx2 = ctx.getChild(2);
            GraphicalModelNode[] f1 = null;
            Object argumentObject = null;
            ArgumentValue[] argumentValues = null;
            if (ctx2.getText().equals(")")) {
                f1 = new Value[]{};
            } else {
                argumentObject = this.visit(ctx2);
                if (argumentObject instanceof Value[]) {
                    f1 = (Value[])argumentObject;
                } else if (argumentObject instanceof ArgumentValue[]) {
                    argumentValues = (ArgumentValue[])argumentObject;
                    f1 = new Value[argumentValues.length];
                    for (int i = 0; i < argumentValues.length; ++i) {
                        if (argumentValues[i] == null) {
                            throw new SimulatorParsingException("Argument " + (i + 1) + " from " + functionName + " is null ! ", ctx);
                        }
                        f1[i] = argumentValues[i].getValue();
                    }
                }
            }
            if (ParserUtils.univarfunctions.contains(functionName)) {
                ExpressionNode1Arg expression = null;
                switch (functionName) {
                    case "abs": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.abs(), f1);
                        break;
                    }
                    case "acos": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.acos(), f1);
                        break;
                    }
                    case "acosh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.acosh(), f1);
                        break;
                    }
                    case "asin": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.asin(), f1);
                        break;
                    }
                    case "asinh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.asinh(), f1);
                        break;
                    }
                    case "atan": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.atan(), f1);
                        break;
                    }
                    case "atanh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.atanh(), f1);
                        break;
                    }
                    case "cLogLog": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.cLogLog(), f1);
                        break;
                    }
                    case "cbrt": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.cbrt(), f1);
                        break;
                    }
                    case "ceil": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.ceil(), f1);
                        break;
                    }
                    case "cos": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.cos(), f1);
                        break;
                    }
                    case "cosh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.cosh(), f1);
                        break;
                    }
                    case "exp": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.exp(), f1);
                        break;
                    }
                    case "expm1": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.expm1(), f1);
                        break;
                    }
                    case "floor": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.floor(), f1);
                        break;
                    }
                    case "log": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.log(), f1);
                        break;
                    }
                    case "log10": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.log10(), f1);
                        break;
                    }
                    case "log1p": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.log1p(), f1);
                        break;
                    }
                    case "logFact": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.logFact(), f1);
                        break;
                    }
                    case "logGamma": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.logGamma(), f1);
                        break;
                    }
                    case "logit": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.logit(), f1);
                        break;
                    }
                    case "phi": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.phi(), f1);
                        break;
                    }
                    case "probit": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.probit(), f1);
                        break;
                    }
                    case "round": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.round(), f1);
                        break;
                    }
                    case "signum": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.signum(), f1);
                        break;
                    }
                    case "sin": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.sin(), f1);
                        break;
                    }
                    case "sinh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.sinh(), f1);
                        break;
                    }
                    case "sqrt": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.sqrt(), f1);
                        break;
                    }
                    case "step": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.step(), f1);
                        break;
                    }
                    case "tan": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.tan(), f1);
                        break;
                    }
                    case "tanh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.tanh(), f1);
                    }
                }
                return expression;
            }
            Set<Class<?>> functionClasses = ParserUtils.getFunctionClasses(functionName);
            if (functionClasses == null) {
                throw new SimulatorParsingException("Found no implementation for function with name " + functionName, ctx);
            }
            GraphicalModelNode[] arguments = new HashMap();
            if (argumentValues != null) {
                for (ArgumentValue v : argumentValues) {
                    arguments.put(v.getName(), v.getValue());
                }
            }
            List<Generator> matches = argumentValues == null ? ParserUtils.getMatchingFunctions(functionName, (Value[])f1) : ParserUtils.getMatchingFunctions(functionName, arguments);
            switch (matches.size()) {
                case 0: {
                    LoggerUtils.log.severe("Found no function for " + functionName + " matching arguments " + (argumentValues != null ? arguments : f1));
                    return null;
                }
            }
            if (matches.size() > 1) {
                LoggerUtils.log.severe("Found " + matches.size() + " matches for " + functionName + ". Picking first one!");
            }
            Generator generator = matches.get(0);
            for (Map.Entry entry : arguments.entrySet()) {
                generator.setInput((String)entry.getKey(), (Value)entry.getValue());
            }
            return generator.generate();
        }

        class ValueOrFunction {
            Object obj;
            ParserRuleContext ctx;

            public ValueOrFunction(Object obj, ParserRuleContext ctx) {
                this.obj = obj;
                this.ctx = ctx;
                if (!(obj instanceof Value) && !(obj instanceof DeterministicFunction)) {
                    throw new SimulatorParsingException("Expected value or function but got " + obj + (String)(obj != null ? " of class " + obj.getClass().getName() : ""), ctx);
                }
                if (SimulatorListenerImpl.this.context == GraphicalModel.Context.data) {
                    SimulatorListenerImpl.this.parser.getDataValues().add(this.getValue());
                } else {
                    SimulatorListenerImpl.this.parser.getModelValues().add(this.getValue());
                }
            }

            Value getValue() {
                if (this.obj instanceof Value) {
                    return (Value)this.obj;
                }
                if (this.obj instanceof DeterministicFunction) {
                    DeterministicFunction func = (DeterministicFunction)this.obj;
                    Value val = func.apply();
                    val.setFunction(func);
                    return val;
                }
                throw new SimulatorParsingException("Expected value or function but got " + this.obj + (String)(this.obj != null ? " of class " + this.obj.getClass().getName() : ""), this.ctx);
            }
        }
    }
}

