/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import lphy.core.functions.DoubleArray;
import lphy.core.functions.IntegerArray;
import lphy.core.functions.Range;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;
import lphy.graphicalModel.types.DoubleArrayValue;
import lphy.graphicalModel.types.DoubleValue;
import lphy.graphicalModel.types.IntegerArray2DValue;
import lphy.graphicalModel.types.IntegerArrayValue;
import lphy.graphicalModel.types.IntegerValue;
import lphy.graphicalModel.types.StringValue;
import lphy.parser.AbstractLightweightBaseListener;
import lphy.parser.SimulatorBaseVisitor;
import lphy.parser.SimulatorLexer;
import lphy.parser.SimulatorParser;
import lphy.parser.SimulatorParsingException;
import lphy.parser.functions.ExpressionNode;
import lphy.parser.functions.ExpressionNode1Arg;
import lphy.parser.functions.ExpressionNode2Args;
import lphy.util.LoggerUtils;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class SimulatorListenerLightweightImpl
extends AbstractLightweightBaseListener {
    public SimulatorListenerLightweightImpl(SortedMap<String, Value<?>> dictionary) {
        this.dictionary = dictionary;
    }

    private boolean allConstants(Value[] var) {
        for (Value v : var) {
            if (v.isConstant()) continue;
            return false;
        }
        return true;
    }

    private Constructor getConstructorByArguments(Map<String, Value> arguments, Class generatorClass, List<Object> initargs) {
        for (Constructor<?> constructor : generatorClass.getConstructors()) {
            List<ParameterInfo> pInfo = Generator.getParameterInfo(constructor);
            if (!this.match(arguments, pInfo)) continue;
            for (int i = 0; i < pInfo.size(); ++i) {
                Value arg = arguments.get(pInfo.get(i).name());
                if (arg != null) {
                    initargs.add(arg);
                    continue;
                }
                if (!pInfo.get(i).optional()) {
                    throw new RuntimeException("Required argument " + pInfo.get(i).name() + " not found!");
                }
                initargs.add(null);
            }
            return constructor;
        }
        return null;
    }

    private boolean match(Map<String, Value> arguments, List<ParameterInfo> pInfo) {
        TreeSet<String> requiredArguments = new TreeSet<String>();
        TreeSet<String> optionalArguments = new TreeSet<String>();
        for (ParameterInfo pinfo : pInfo) {
            if (pinfo.optional()) {
                optionalArguments.add(pinfo.name());
                continue;
            }
            requiredArguments.add(pinfo.name());
        }
        if (!arguments.keySet().containsAll(requiredArguments)) {
            return false;
        }
        TreeSet<String> allArguments = optionalArguments;
        allArguments.addAll(requiredArguments);
        return allArguments.containsAll(arguments.keySet());
    }

    public Object parse(String CASentence) {
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                e.printStackTrace();
                if (e instanceof NoViableAltException) {
                    NoViableAltException nvae = (NoViableAltException)e;
                    System.out.println(nvae.getLocalizedMessage());
                }
                throw new SimulatorParsingException(msg, charPositionInLine, line);
            }
        };
        SimulatorLexer lexer = new SimulatorLexer((CharStream)CharStreams.fromString((String)CASentence));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SimulatorParser parser = new SimulatorParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        SimulatorParser.InputContext parseTree = parser.input();
        SimulatorASTVisitor visitor = new SimulatorASTVisitor();
        return visitor.visit((ParseTree)parseTree);
    }

    public static void main(String[] args) throws IOException {
        StringBuffer buf;
        BufferedReader fin;
        SimulatorListenerLightweightImpl parser;
        if (args.length == 1) {
            parser = new SimulatorListenerLightweightImpl(new TreeMap());
            fin = new BufferedReader(new FileReader(args[0]));
            buf = new StringBuffer();
            String str = null;
            while (fin.ready()) {
                str = fin.readLine();
                buf.append(str);
                buf.append('\n');
            }
        } else {
            throw new IllegalArgumentException("Expected 1 argument: a file name");
        }
        fin.close();
        Object o = parser.parse(buf.toString());
        System.err.println("OK Done!");
    }

    public class SimulatorASTVisitor
    extends SimulatorBaseVisitor<Object> {
        public SimulatorASTVisitor() {
            AbstractLightweightBaseListener.bivarOperators = new HashSet<String>();
            for (String s : new String[]{"+", "-", "*", "/", "**", "&&", "||", "<=", "<", ">=", ">", "%", ":", "^", "!=", "==", "&", "|", "<<", ">>", ">>>"}) {
                AbstractLightweightBaseListener.bivarOperators.add(s);
            }
            AbstractLightweightBaseListener.univarfunctions = new HashSet<String>();
            for (String s : new String[]{"abs", "acos", "acosh", "asin", "asinh", "atan", "atanh", "cLogLog", "cbrt", "ceil", "cos", "cosh", "exp", "expm1", "floor", "log", "log10", "log1p", "logFact", "logGamma", "logit", "phi", "probit", "round", "signum", "sin", "sinh", "sqrt", "step", "tan", "tanh"}) {
                AbstractLightweightBaseListener.univarfunctions.add(s);
            }
        }

        @Override
        public Object visitRange_list(SimulatorParser.Range_listContext ctx) {
            System.out.println("Visiting a range list:" + ctx.getText());
            return this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Object visitRange_element(SimulatorParser.Range_elementContext ctx) {
            System.out.println("Visiting a range element:" + ctx.getText());
            return this.visitChildren((RuleNode)ctx);
        }

        @Override
        public Value visitConstant(SimulatorParser.ConstantContext ctx) {
            String text = ctx.getText();
            if (text.startsWith("\"")) {
                StringValue v = new StringValue(null, this.stripQuotes(text));
                return v;
            }
            double d = 0.0;
            try {
                d = Long.parseLong(text);
                IntegerValue v = new IntegerValue(null, (int)d);
                return v;
            }
            catch (NumberFormatException e) {
                try {
                    d = Double.parseDouble(text);
                    DoubleValue v = new DoubleValue(null, d);
                    return v;
                }
                catch (NumberFormatException e2) {
                    int i = Boolean.parseBoolean(text) ? 1 : 0;
                    IntegerValue v = new IntegerValue(null, i);
                    return v;
                }
            }
        }

        private String stripQuotes(String stringWithQuotes) {
            if (stringWithQuotes.startsWith("\"") && stringWithQuotes.endsWith("\"")) {
                return stringWithQuotes.substring(1, stringWithQuotes.length() - 1);
            }
            throw new RuntimeException();
        }

        private String nextID(String id) {
            int k = 0;
            while (SimulatorListenerLightweightImpl.this.dictionary.containsKey(id + k)) {
                ++k;
            }
            return id + k;
        }

        @Override
        public Value visitDeterm_relation(SimulatorParser.Determ_relationContext ctx) {
            LoggerUtils.log.fine(" visitDeterm_relation");
            Object expr = this.visit(ctx.getChild(2));
            String id = ((ParseTree)ctx.children.get(0)).getText();
            LoggerUtils.log.fine("   id = " + id);
            if (expr instanceof DeterministicFunction) {
                DeterministicFunction f = (DeterministicFunction)expr;
                Value value = f.apply();
                value.setFunction(f);
                value.setId(id);
                SimulatorListenerLightweightImpl.this.dictionary.put(id, value);
                return value;
            }
            if (expr instanceof Value) {
                Value value = (Value)expr;
                value.setId(id);
                SimulatorListenerLightweightImpl.this.dictionary.put(id, value);
                LoggerUtils.log.fine("   adding value " + value + " to the dictionary");
                return value;
            }
            LoggerUtils.log.severe("in visitDeterm_relation() expecting a function or a value!");
            return null;
        }

        @Override
        public Value visitStoch_relation(SimulatorParser.Stoch_relationContext ctx) {
            GenerativeDistribution genDist = (GenerativeDistribution)this.visit(ctx.getChild(2));
            String id = ctx.getChild(0).getText();
            RandomVariable var = genDist.sample(id);
            SimulatorListenerLightweightImpl.this.dictionary.put(var.getId(), var);
            return var;
        }

        protected Object aggregateResult(Object aggregate, Object nextResult) {
            if (nextResult != null) {
                return nextResult;
            }
            return aggregate;
        }

        @Override
        public Object visitVar(SimulatorParser.VarContext ctx) {
            String id = ctx.getChild(0).getText();
            LoggerUtils.log.log(Level.FINE, "  visitVar: " + id);
            return id;
        }

        @Override
        public Object visitExpression(SimulatorParser.ExpressionContext ctx) {
            String key;
            if (ctx.getChildCount() == 1 && SimulatorListenerLightweightImpl.this.dictionary.containsKey(key = ctx.getChild(0).getText())) {
                return SimulatorListenerLightweightImpl.this.dictionary.get(key);
            }
            ExpressionNode expression = null;
            if (ctx.getChildCount() >= 2) {
                String s = ctx.getChild(1).getText();
                if (AbstractLightweightBaseListener.bivarOperators.contains(s)) {
                    Value f1 = new ValueOrFunction(this.visit(ctx.getChild(0))).getValue();
                    Value f2 = new ValueOrFunction(this.visit(ctx.getChild(ctx.getChildCount() - 1))).getValue();
                    block19 : switch (s) {
                        case "+": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.plus(), f1, f2);
                            break;
                        }
                        case "-": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.minus(), f1, f2);
                            break;
                        }
                        case "*": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.times(), f1, f2);
                            break;
                        }
                        case "/": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.divide(), f1, f2);
                            break;
                        }
                        case "**": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.pow(), f1, f2);
                            break;
                        }
                        case "&&": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.and(), f1, f2);
                            break;
                        }
                        case "||": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.or(), f1, f2);
                            break;
                        }
                        case "<=": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.le(), f1, f2);
                            break;
                        }
                        case "<": {
                            switch (ctx.getChildCount()) {
                                case 3: {
                                    expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.less(), f1, f2);
                                    break block19;
                                }
                            }
                            break;
                        }
                        case ">=": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.ge(), f1, f2);
                            break;
                        }
                        case ">": {
                            switch (ctx.getChildCount()) {
                                case 3: {
                                    expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.greater(), f1, f2);
                                    break block19;
                                }
                            }
                            break;
                        }
                        case "!=": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.ne(), f1, f2);
                            break;
                        }
                        case "==": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.equals(), f1, f2);
                            break;
                        }
                        case "%": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.mod(), f1, f2);
                            break;
                        }
                        case "&": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.bitwiseand(), f1, f2);
                            break;
                        }
                        case "|": {
                            expression = new ExpressionNode2Args(ctx.getText(), ExpressionNode2Args.bitwiseor(), f1, f2);
                            break;
                        }
                        case ":": {
                            return new Range(f1, f2);
                        }
                    }
                    return expression;
                }
                s = ctx.getChild(0).getText();
                if (s.equals("!")) {
                    Value f1 = (Value)this.visit(ctx.getChild(2));
                    expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.not(), f1);
                    return expression;
                }
                if (s.equals("[")) {
                    Value[] var = (Value[])this.visit(ctx.getChild(1));
                    if (var[0].value() instanceof Double[]) {
                        Double[][] value = new Double[var.length][];
                        for (int i = 0; i < value.length; ++i) {
                            value[i] = (Double[])var[i].value();
                        }
                        DoubleArray2DValue v = new DoubleArray2DValue(null, value);
                        return v;
                    }
                    if (var[0].value() instanceof Double) {
                        if (SimulatorListenerLightweightImpl.this.allConstants(var)) {
                            Double[] value = new Double[var.length];
                            for (int i = 0; i < value.length; ++i) {
                                value[i] = (Double)var[i].value();
                            }
                            DoubleArrayValue v = new DoubleArrayValue(null, value);
                            return v;
                        }
                        DoubleArray doubleArray = new DoubleArray(var);
                        return doubleArray.apply();
                    }
                    if (var[0].value() instanceof Integer[]) {
                        Integer[][] value = new Integer[var.length][];
                        for (int i = 0; i < value.length; ++i) {
                            value[i] = (Integer[])var[i].value();
                        }
                        IntegerArray2DValue v = new IntegerArray2DValue(null, value);
                        return v;
                    }
                    if (var[0].value() instanceof Integer) {
                        if (SimulatorListenerLightweightImpl.this.allConstants(var)) {
                            Integer[] value = new Integer[var.length];
                            for (int i = 0; i < value.length; ++i) {
                                value[i] = (Integer)var[i].value();
                            }
                            IntegerArrayValue v = new IntegerArrayValue(null, value);
                            return v;
                        }
                        IntegerArray intArray = new IntegerArray(var);
                        return intArray.apply();
                    }
                    throw new RuntimeException("Don't know how to handle 3D matrices");
                }
            }
            return super.visitExpression(ctx);
        }

        @Override
        public Object visitNamed_expression(SimulatorParser.Named_expressionContext ctx) {
            String name = ctx.getChild(0).getText();
            Object obj = this.visit(ctx.getChild(2));
            LoggerUtils.log.log(Level.FINE, " Visiting named expression:");
            LoggerUtils.log.log(Level.FINE, "   name: " + name + " child2: " + obj);
            if (obj instanceof DeterministicFunction) {
                Value value = ((DeterministicFunction)obj).apply();
                value.setFunction((DeterministicFunction)obj);
                NamedValue v = new NamedValue(name, value);
                return v;
            }
            if (obj instanceof Value) {
                Value value = (Value)obj;
                NamedValue v = new NamedValue(name, value);
                return v;
            }
            return obj;
        }

        @Override
        public Object visitDistribution(SimulatorParser.DistributionContext ctx) {
            String name = ctx.getChild(0).getText();
            NamedValue[] f = (NamedValue[])this.visit(ctx.getChild(2));
            HashMap<String, Value> arguments = new HashMap<String, Value>();
            for (NamedValue v : f) {
                arguments.put(v.name, v.value);
            }
            Set<Class<?>> genDistClasses = AbstractLightweightBaseListener.genDistDictionary.get(name);
            if (genDistClasses == null) {
                throw new RuntimeException("Found no implementation for generative distribution " + name);
            }
            for (Class<?> genDistClass : genDistClasses) {
                try {
                    ArrayList<Object> initargs = new ArrayList<Object>();
                    Constructor constructor = SimulatorListenerLightweightImpl.this.getConstructorByArguments(arguments, genDistClass, initargs);
                    if (constructor == null) continue;
                    GenerativeDistribution dist = (GenerativeDistribution)constructor.newInstance(initargs.toArray());
                    for (String parameterName : arguments.keySet()) {
                        Value value = (Value)arguments.get(parameterName);
                        dist.setInput(parameterName, value);
                    }
                    return dist;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Parsing generative distribution " + name + " failed.");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Parsing generative distribution " + name + " failed.");
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Parsing generative distribution " + name + " failed.");
                }
            }
            throw new RuntimeException("Parser exception: no constructor found for " + name);
        }

        @Override
        public Object visitExpression_list(SimulatorParser.Expression_listContext ctx) {
            ArrayList<NamedValue> list = new ArrayList<NamedValue>();
            for (int i = 0; i < ctx.getChildCount(); i += 2) {
                list.add((NamedValue)this.visit(ctx.getChild(i)));
            }
            return list.toArray(new NamedValue[0]);
        }

        @Override
        public Object visitUnnamed_expression_list(SimulatorParser.Unnamed_expression_listContext ctx) {
            ArrayList<Value> list = new ArrayList<Value>();
            for (int i = 0; i < ctx.getChildCount(); i += 2) {
                list.add((Value)this.visit(ctx.getChild(i)));
            }
            return list.toArray(new Value[0]);
        }

        @Override
        public Object visitMethodCall(SimulatorParser.MethodCallContext ctx) {
            String functionName = ((ParseTree)ctx.children.get(0)).getText();
            ParseTree ctx2 = ctx.getChild(2);
            GraphicalModelNode[] f1 = null;
            NamedValue[] values = new NamedValue[]{};
            if (ctx2.getText().equals(")")) {
                f1 = new Value[]{};
            } else {
                values = (NamedValue[])this.visit(ctx2);
                f1 = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    f1[i] = values[i].value;
                }
            }
            if (AbstractLightweightBaseListener.univarfunctions.contains(functionName)) {
                ExpressionNode1Arg expression = null;
                switch (functionName) {
                    case "abs": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.abs(), f1);
                        break;
                    }
                    case "acos": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.acos(), f1);
                        break;
                    }
                    case "acosh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.acosh(), f1);
                        break;
                    }
                    case "asin": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.asin(), f1);
                        break;
                    }
                    case "asinh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.asinh(), f1);
                        break;
                    }
                    case "atan": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.atan(), f1);
                        break;
                    }
                    case "atanh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.atanh(), f1);
                        break;
                    }
                    case "cLogLog": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.cLogLog(), f1);
                        break;
                    }
                    case "cbrt": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.cbrt(), f1);
                        break;
                    }
                    case "ceil": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.ceil(), f1);
                        break;
                    }
                    case "cos": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.cos(), f1);
                        break;
                    }
                    case "cosh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.cosh(), f1);
                        break;
                    }
                    case "exp": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.exp(), f1);
                        break;
                    }
                    case "expm1": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.expm1(), f1);
                        break;
                    }
                    case "floor": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.floor(), f1);
                        break;
                    }
                    case "log": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.log(), f1);
                        break;
                    }
                    case "log10": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.log10(), f1);
                        break;
                    }
                    case "log1p": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.log1p(), f1);
                        break;
                    }
                    case "logFact": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.logFact(), f1);
                        break;
                    }
                    case "logGamma": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.logGamma(), f1);
                        break;
                    }
                    case "logit": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.logit(), f1);
                        break;
                    }
                    case "phi": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.phi(), f1);
                        break;
                    }
                    case "probit": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.probit(), f1);
                        break;
                    }
                    case "round": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.round(), f1);
                        break;
                    }
                    case "signum": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.signum(), f1);
                        break;
                    }
                    case "sin": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.sin(), f1);
                        break;
                    }
                    case "sinh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.sinh(), f1);
                        break;
                    }
                    case "sqrt": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.sqrt(), f1);
                        break;
                    }
                    case "step": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.step(), f1);
                        break;
                    }
                    case "tan": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.tan(), f1);
                        break;
                    }
                    case "tanh": {
                        expression = new ExpressionNode1Arg(ctx.getText(), ExpressionNode1Arg.tanh(), f1);
                    }
                }
                return expression;
            }
            Set<Class<?>> functionClasses = AbstractLightweightBaseListener.functionDictionary.get(functionName);
            if (functionClasses == null) {
                throw new RuntimeException("Found no implementation for function " + functionName);
            }
            HashMap<String, Value> arguments = new HashMap<String, Value>();
            for (NamedValue v : values) {
                arguments.put(v.name, v.value);
            }
            for (Class clazz : functionClasses) {
                try {
                    ArrayList<Object> initargs = new ArrayList<Object>();
                    Constructor constructor = SimulatorListenerLightweightImpl.this.getConstructorByArguments(arguments, clazz, initargs);
                    if (constructor == null) continue;
                    DeterministicFunction f = (DeterministicFunction)constructor.newInstance(initargs.toArray());
                    for (String parameterName : arguments.keySet()) {
                        Value value = (Value)arguments.get(parameterName);
                        f.setInput(parameterName, value);
                    }
                    Value val = f.apply();
                    return val;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Parsing generative distribution " + functionName + " failed.");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Parsing generative distribution " + functionName + " failed.");
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Parsing generative distribution " + functionName + " failed.");
                }
            }
            throw new RuntimeException("Parser exception: no constructor found for " + functionName);
        }

        class ValueOrFunction {
            Object obj;

            public ValueOrFunction(Object obj) {
                this.obj = obj;
                if (!(obj instanceof Value) && !(obj instanceof DeterministicFunction)) {
                    throw new RuntimeException();
                }
            }

            Value getValue() {
                if (this.obj instanceof Value) {
                    return (Value)this.obj;
                }
                if (this.obj instanceof DeterministicFunction) {
                    DeterministicFunction func = (DeterministicFunction)this.obj;
                    Value val = func.apply();
                    val.setFunction(func);
                    return val;
                }
                throw new RuntimeException();
            }
        }

        class NamedValue {
            String name;
            Value value;

            public NamedValue(String name, Value value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

