/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import org.antlr.v4.runtime.ParserRuleContext;

public class SimulatorParsingException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    String message;
    Integer characterNum;
    Integer lineNum;
    ParserRuleContext context;

    public SimulatorParsingException(String message, Integer characterNum, Integer lineNum) {
        this.message = message;
        this.characterNum = characterNum;
        this.lineNum = lineNum;
    }

    public SimulatorParsingException(String message, ParserRuleContext context) {
        this.message = message;
        this.context = context;
        this.lineNum = context.getStart().getLine();
        this.characterNum = context.getStart().getCharPositionInLine();
    }

    SimulatorParsingException(String message) {
        this(message, null, null);
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder(this.message);
        msg.append(" line ");
        msg.append(this.lineNum);
        msg.append(" character ");
        msg.append(this.characterNum);
        if (this.context != null) {
            msg.append("\n -> ");
            String text = this.context.getText();
            msg.append(text);
            msg.append("\n    ");
            msg.append("^".repeat(text.length()));
        }
        return msg.toString();
    }

    public Integer getCharacterNum() {
        return this.characterNum;
    }

    public Integer getLineNum() {
        return this.lineNum;
    }
}

