/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lphy.core.functions.ElementsAt;
import lphy.core.functions.Range;
import lphy.core.functions.SliceDoubleArray;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GraphicalModel;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.BooleanArrayValue;
import lphy.graphicalModel.types.DoubleArrayValue;
import lphy.graphicalModel.types.IntegerArrayValue;
import lphy.graphicalModel.types.StringArrayValue;
import lphy.parser.functions.RangeList;
import lphy.util.LoggerUtils;

public class Var {
    String id;
    RangeList rangeList;
    GraphicalModel graphicalModel;

    public Var(String id, GraphicalModel graphicalModel) {
        this(id, null, graphicalModel);
    }

    public Var(String id, RangeList rangeList, GraphicalModel graphicalModel) {
        this.id = id;
        this.graphicalModel = graphicalModel;
        this.rangeList = rangeList;
    }

    public boolean isRangedVar() {
        return this.rangeList != null;
    }

    public Value getValue(GraphicalModel.Context context) {
        Value val = this.graphicalModel.getValue(this.id, context);
        if (!this.isRangedVar()) {
            return val;
        }
        return Var.getIndexedValue(val, this.rangeList).apply();
    }

    public static DeterministicFunction getIndexedValue(Value array, RangeList rangeList) {
        if (array.value() instanceof Double[]) {
            if (rangeList.isRange()) {
                Range range = (Range)rangeList.getRangeElement(0);
                return new SliceDoubleArray(range.start(), range.end(), array);
            }
            if (rangeList.isSingle()) {
                Value i = (Value)rangeList.getRangeElement(0);
                return new SliceDoubleArray((Value<Integer>)i, (Value<Integer>)i, array);
            }
        }
        IntegerArrayValue indices = rangeList.apply();
        return new ElementsAt(indices, array);
    }

    public Value assign(Value value, DeterministicFunction function, GraphicalModel.Context context) {
        if (!this.isRangedVar()) {
            if (function != null) {
                value.setFunction(function);
            }
            value.setId(this.id);
            this.graphicalModel.put(this.id, value, context);
            return value;
        }
        List<Integer> range = Arrays.asList((Integer[])this.rangeList.apply().value());
        int max = Collections.max(range);
        if (this.graphicalModel.hasValue(this.id, context)) {
            Value v = this.graphicalModel.getValue(this.id, context);
            if (v.value().getClass().isArray()) {
                int currentLength = Array.getLength(v.value());
                if (currentLength <= max) {
                    Object newArray = Array.newInstance(v.value().getClass().getComponentType(), max + 1);
                    for (int i = 0; i < currentLength; ++i) {
                        Array.set(newArray, i, Array.get(v.value(), i));
                    }
                    v.setValue(newArray);
                }
                Object source = value.value();
                Object destinationArray = v.value();
                for (int i = 0; i < range.size(); ++i) {
                    int index = range.get(i);
                    if (source.getClass().isArray()) {
                        Array.set(destinationArray, index, Array.get(source, i));
                        continue;
                    }
                    Array.set(destinationArray, index, source);
                }
            }
            return v;
        }
        if (value.value().getClass().isArray()) {
            Object sourceArray = value.value();
            Object destinationArray = Array.newInstance(sourceArray.getClass().getComponentType(), max + 1);
            for (int i = 0; i < range.size(); ++i) {
                int index = range.get(i);
                Array.set(destinationArray, index, Array.get(sourceArray, i));
            }
            Value v = destinationArray instanceof Double[] ? new DoubleArrayValue(this.id, (Double[])destinationArray, function) : (destinationArray instanceof Integer[] ? new IntegerArrayValue(this.id, (Integer[])destinationArray, function) : (destinationArray instanceof Boolean[] ? new BooleanArrayValue(this.id, (Boolean[])destinationArray, function) : (destinationArray instanceof String[] ? new StringArrayValue(this.id, (String[])destinationArray, function) : new Value<Object>(this.id, destinationArray, function))));
            LoggerUtils.log.fine("   adding value " + v + " to the dictionary");
            return v;
        }
        Object sourceValue = value.value();
        Object destinationArray = Array.newInstance(sourceValue.getClass(), max + 1);
        for (int i = 0; i < range.size(); ++i) {
            int index = range.get(i);
            Array.set(destinationArray, index, sourceValue);
        }
        Value v = null;
        v = destinationArray instanceof Double[] ? new DoubleArrayValue(this.id, (Double[])destinationArray, function) : (destinationArray instanceof Integer[] ? new IntegerArrayValue(this.id, (Integer[])destinationArray, function) : (destinationArray instanceof Boolean[] ? new BooleanArrayValue(this.id, (Boolean[])destinationArray, function) : (destinationArray instanceof String[] ? new StringArrayValue(this.id, (String[])destinationArray, function) : new Value<Object>(this.id, destinationArray, function))));
        this.graphicalModel.put(this.id, v, context);
        return v;
    }

    public String getId() {
        return this.id;
    }

    public RangeList getRangeList() {
        return this.rangeList;
    }
}

