/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser.functions;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.Value;

public abstract class ExpressionNode<T>
extends DeterministicFunction<T>
implements Generator {
    String expression;
    Map<String, Value> params;
    GraphicalModelNode[] inputValues;
    boolean isAnonymous = false;

    ExpressionNode() {
    }

    @Override
    public String getName() {
        return this.expression;
    }

    @Override
    public Map<String, Value> getParams() {
        return new LinkedHashMap<String, Value>(this.params);
    }

    @Override
    public void setParam(String paramName, Value value) {
        this.params.put(paramName, value);
    }

    @Override
    public String codeString() {
        return this.expression;
    }

    @Override
    public List<GraphicalModelNode> getInputs() {
        return new ArrayList<GraphicalModelNode>(this.params.values());
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean b) {
        this.isAnonymous = b;
    }

    public String toString() {
        return this.getName();
    }

    public Value updateInputsAndApply() {
        Value[] newInputValues = new Value[this.inputValues.length];
        for (int i = 0; i < this.inputValues.length; ++i) {
            if (this.inputValues[i] instanceof Value) {
                Value v = (Value)this.inputValues[i];
                if (!(v.getGenerator() instanceof DeterministicFunction)) continue;
                DeterministicFunction f = (DeterministicFunction)v.getGenerator();
                Value newValue = f.apply();
                if (!v.isAnonymous()) {
                    newValue.setId(v.getId());
                    this.paramMap.put(v.getId(), newValue);
                }
                this.inputValues[i] = newValue;
                continue;
            }
            throw new RuntimeException("This code assumes all inputs are values!");
        }
        return this.apply();
    }
}

