/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser.functions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.Value;
import lphy.parser.ElementWise2Args;
import lphy.parser.functions.ExpressionNode;
import lphy.util.LoggerUtils;

public class ExpressionNode2Args<T>
extends ExpressionNode {
    BinaryOperator func;
    ElementWise2Args elementWise;

    public ExpressionNode2Args(String expression, BinaryOperator func, GraphicalModelNode ... values) {
        this.expression = expression;
        this.func = func;
        this.params = new LinkedHashMap();
        for (GraphicalModelNode node : values) {
            if (node instanceof ExpressionNode) {
                throw new RuntimeException();
            }
            if (!(node instanceof Value)) continue;
            Value value = (Value)node;
            String key = null;
            if (!value.isAnonymous()) {
                key = value.getId();
            } else if (value.isRandom() || value.getGenerator() != null) {
                key = value.codeString();
            }
            if (key != null) {
                this.params.put(key, value);
            }
            value.addOutput(this);
        }
        this.inputValues = values;
        this.elementWise = ElementWise2Args.elementFactory(values);
    }

    @Override
    @GeneratorInfo(name="expression", verbClause="is calculated by", description="expression")
    public Map<String, Value> getParams() {
        return this.params;
    }

    @Override
    public void setParam(String paramName, Value value) {
        this.params.put(paramName, value);
        for (int i = 0; i < this.inputValues.length; ++i) {
            Value v = (Value)this.inputValues[i];
            if (!v.isAnonymous() && v.getId().equals(paramName)) {
                this.inputValues[i] = value;
                LoggerUtils.log.fine("Setting input value " + i + " to " + value);
                continue;
            }
            if (!v.isAnonymous() || !v.codeString().equals(paramName)) continue;
            this.inputValues[i] = value;
            LoggerUtils.log.fine("Setting input value " + i + " to " + value + " based on code string.");
        }
    }

    @Override
    public Value<T> apply() {
        Value value = this.elementWise.apply(this.inputValues[0], this.inputValues[1], this.func);
        value.setFunction(this);
        return value;
    }

    public static BinaryOperator<Number> plus() {
        return (a, b) -> a.doubleValue() + b.doubleValue();
    }

    public static BinaryOperator<Number> minus() {
        return (a, b) -> a.doubleValue() - b.doubleValue();
    }

    public static BinaryOperator<Number> times() {
        return (a, b) -> a.doubleValue() * b.doubleValue();
    }

    public static BinaryOperator<Number> divide() {
        return (a, b) -> a.doubleValue() / b.doubleValue();
    }

    public static BinaryOperator<Number> and() {
        return (a, b) -> a.doubleValue() != 0.0 && b.doubleValue() != 0.0 ? 1.0 : 0.0;
    }

    public static BinaryOperator<Number> or() {
        return (a, b) -> a.doubleValue() != 0.0 || b.doubleValue() != 0.0 ? 1.0 : 0.0;
    }

    public static BinaryOperator<Integer> bitwiseand() {
        return (a, b) -> (int)a.doubleValue() & (int)b.doubleValue();
    }

    public static BinaryOperator<Integer> bitwiseor() {
        return (a, b) -> (int)a.doubleValue() | (int)b.doubleValue();
    }

    public static BinaryOperator<Number> le() {
        return (a, b) -> a.doubleValue() <= b.doubleValue() ? 1.0 : 0.0;
    }

    public static BinaryOperator<Number> less() {
        return (a, b) -> a.doubleValue() < b.doubleValue() ? 1.0 : 0.0;
    }

    public static BinaryOperator<Number> ge() {
        return (a, b) -> a.doubleValue() >= b.doubleValue() ? 1.0 : 0.0;
    }

    public static BinaryOperator<Number> greater() {
        return (a, b) -> a.doubleValue() > b.doubleValue() ? 1.0 : 0.0;
    }

    public static BinaryOperator<Number> equals() {
        return (a, b) -> a.doubleValue() == b.doubleValue() ? 1.0 : 0.0;
    }

    public static BinaryOperator<Number> ne() {
        return (a, b) -> a.doubleValue() == b.doubleValue() ? 1.0 : 0.0;
    }

    public static BinaryOperator<Number> pow() {
        return (a, b) -> Math.pow(a.doubleValue(), b.doubleValue());
    }

    public static BinaryOperator<Number> mod() {
        return (a, b) -> a.doubleValue() % b.doubleValue();
    }
}

