/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser.functions;

import java.util.Map;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.Value;
import lphy.parser.functions.ExpressionNode;

public class ExpressionNodeWrapper
extends DeterministicFunction {
    ExpressionNode nodeToWrap;

    public ExpressionNodeWrapper(ExpressionNode nodeToWrap) {
        this.nodeToWrap = nodeToWrap;
        this.extractAllParams(nodeToWrap);
        this.rewireAllOutputs(nodeToWrap, false);
    }

    public static int expressionSubtreeSize(ExpressionNode eNode) {
        int size = 1;
        for (GraphicalModelNode childNode : eNode.getInputs()) {
            Value v;
            if (!(childNode instanceof Value) || !((v = (Value)childNode).getGenerator() instanceof ExpressionNode)) continue;
            size += ExpressionNodeWrapper.expressionSubtreeSize((ExpressionNode)v.getGenerator());
        }
        return size;
    }

    private void rewireAllOutputs(ExpressionNode expressionNode, boolean makeAnonymous) {
        for (GraphicalModelNode childNode : expressionNode.getInputs()) {
            Value v;
            if (!(childNode instanceof Value) || !((v = (Value)childNode).getGenerator() instanceof ExpressionNode)) continue;
            this.rewireAllOutputs((ExpressionNode)v.getGenerator(), true);
        }
        expressionNode.getParams().forEach((key, value) -> {
            ((Value)value).removeOutput((Generator)((Value)value).getOutputs().get(0));
            ((Value)value).addOutput(this);
        });
        if (makeAnonymous) {
            expressionNode.setAnonymous(true);
        }
    }

    private void extractAllParams(ExpressionNode expressionNode) {
        for (GraphicalModelNode childNode : expressionNode.getInputs()) {
            Value v;
            if (!(childNode instanceof Value) || !((v = (Value)childNode).getGenerator() instanceof ExpressionNode)) continue;
            this.extractAllParams((ExpressionNode)v.getGenerator());
        }
        expressionNode.getParams().forEach((key, value) -> {
            if (!((Value)value).isAnonymous()) {
                this.paramMap.put((String)key, (Value)value);
            }
        });
    }

    @Override
    public void setParam(String paramName, Value value) {
        this.paramMap.put(paramName, value);
        this.setParamRecursively(paramName, value, this.nodeToWrap);
    }

    @Override
    public Map<String, Value> getParams() {
        return this.paramMap;
    }

    @Override
    public String getName() {
        return this.nodeToWrap.getName();
    }

    private void setParamRecursively(String paramName, Value<?> value, ExpressionNode expressionNode) {
        if (expressionNode.getParams().containsKey(paramName)) {
            expressionNode.setParam(paramName, (Value)value);
        } else {
            for (GraphicalModelNode childNode : expressionNode.inputValues) {
                if (childNode instanceof Value) {
                    Value v = (Value)childNode;
                    if (!(v.getGenerator() instanceof ExpressionNode)) continue;
                    this.setParamRecursively(paramName, value, (ExpressionNode)v.getGenerator());
                    continue;
                }
                throw new RuntimeException("This code assumes all inputs are values!");
            }
        }
    }

    public Value apply() {
        return this.applyRecursively();
    }

    public Value applyRecursively() {
        Value v = this.applyRecursively(this.nodeToWrap);
        v.setFunction(this);
        return v;
    }

    private Value applyRecursively(ExpressionNode expressionNode) {
        for (int i = 0; i < expressionNode.inputValues.length; ++i) {
            if (expressionNode.inputValues[i] instanceof Value) {
                Value v = (Value)expressionNode.inputValues[i];
                if (!(v.getGenerator() instanceof ExpressionNode)) continue;
                ExpressionNode childExpressionNode = (ExpressionNode)v.getGenerator();
                Value newValue = this.applyRecursively(childExpressionNode);
                if (!v.isAnonymous()) {
                    newValue.setId(v.getId());
                    this.paramMap.put(v.getId(), newValue);
                }
                expressionNode.inputValues[i] = newValue;
                continue;
            }
            throw new RuntimeException("This code assumes all inputs are values!");
        }
        return expressionNode.apply();
    }

    @Override
    public String codeString() {
        return this.nodeToWrap.codeString();
    }
}

