/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser.functions;

import java.util.HashMap;
import java.util.Map;
import lphy.core.narrative.Narrative;
import lphy.graphicalModel.ArgumentValue;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.NarrativeUtils;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.MapValue;

public class MapFunction
extends DeterministicFunction<Map<String, Object>> {
    public MapFunction(ArgumentValue ... argumentValues) {
        for (ArgumentValue argumentValue : argumentValues) {
            this.setParam(argumentValue.getName(), argumentValue.getValue());
        }
    }

    @Override
    @GeneratorInfo(name="map", description="A map defined by the argumentName=value pairs of its arguments.")
    public Value<Map<String, Object>> apply() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, Value> valueMap = this.getParams();
        for (Map.Entry<String, Value> entry : valueMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().value());
        }
        return new MapValue(null, (Map<String, Object>)map, this);
    }

    @Override
    public String getInferenceNarrative(Value value, boolean unique, Narrative narrative) {
        StringBuilder builder = new StringBuilder();
        builder.append(NarrativeUtils.getValueClause(value, unique, narrative));
        Map<String, Value> valueMap = this.getParams();
        builder.append(" are ");
        int count = 0;
        for (Map.Entry<String, Value> entry : valueMap.entrySet()) {
            if (count > 0) {
                if (count == valueMap.size() - 1) {
                    builder.append(" and ");
                } else {
                    builder.append(", ");
                }
            }
            builder.append(entry.getKey());
            builder.append("=");
            if (entry.getValue().isAnonymous()) {
                builder.append(narrative.text(entry.getValue().codeString()));
            } else {
                builder.append(entry.getValue().getId());
            }
            ++count;
        }
        builder.append(".");
        return builder.toString();
    }

    @Override
    public String codeString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        Map<String, Value> valueMap = this.getParams();
        int count = 0;
        for (Map.Entry<String, Value> entry : valueMap.entrySet()) {
            if (count > 0) {
                builder.append(", ");
            }
            builder.append(entry.getKey());
            builder.append("=");
            if (entry.getValue().isAnonymous()) {
                builder.append(entry.getValue().codeString());
            } else {
                builder.append(entry.getValue().getId());
            }
            ++count;
        }
        builder.append("}");
        return builder.toString();
    }
}

