/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser.functions;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.core.functions.ElementsAt;
import lphy.core.functions.Slice;
import lphy.core.functions.VectorizedFunction;
import lphy.core.narrative.Narrative;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.MethodInfo;
import lphy.graphicalModel.NarrativeUtils;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import lphy.graphicalModel.Vector;
import lphy.graphicalModel.types.CompoundVectorValue;
import org.apache.commons.lang3.BooleanUtils;

public class MethodCall
extends DeterministicFunction {
    public static final String objectParamName = "object";
    public static final String argParamName = "arg";
    Value<?> value;
    final String methodName;
    MethodInfo methodInfo;
    Value<?>[] arguments;
    Class<?>[] paramTypes;
    Class<?> c;
    Method method;
    boolean vectorizedArguments;
    boolean vectorizedObject;

    public MethodCall(String methodName, Value<?> value, Value<?>[] arguments) throws NoSuchMethodException {
        block11: {
            this.method = null;
            this.vectorizedArguments = false;
            this.vectorizedObject = false;
            this.value = value;
            this.methodName = methodName;
            this.arguments = arguments;
            this.paramTypes = new Class[arguments.length];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                this.paramTypes[i] = arguments[i].value().getClass();
            }
            this.c = value.value().getClass();
            try {
                this.method = this.c.getMethod(methodName, this.paramTypes);
            }
            catch (NoSuchMethodException nsme) {
                block10: {
                    if (value instanceof Vector) {
                        Class componentClass = ((Vector)((Object)value)).getComponentType();
                        try {
                            this.method = componentClass.getMethod(methodName, this.paramTypes);
                            this.vectorizedObject = true;
                        }
                        catch (NoSuchMethodException nsme2) {
                            this.method = this.getVectorMatch(methodName, componentClass, this.paramTypes);
                            if (this.method == null) break block10;
                            this.vectorizedObject = true;
                            this.vectorizedArguments = true;
                        }
                    }
                }
                if (this.method == null) {
                    this.method = this.getVectorMatch(methodName, value, arguments);
                    if (this.method != null) {
                        this.vectorizedArguments = true;
                    }
                }
                if (this.method != null) break block11;
                throw nsme;
            }
        }
        this.methodInfo = this.getMethodInfo(this.method);
        if (this.methodInfo == null) {
            throw new IllegalArgumentException("This method is not permitted to be passed through! Methods must have MethodInfo annotation to allow pass through to LPhy.");
        }
        this.setInput(objectParamName, value);
        for (int i = 0; i < arguments.length; ++i) {
            this.setInput(argParamName + i, arguments[i]);
        }
    }

    public static boolean isMethodCall(Object o) {
        return o instanceof MethodCall || o instanceof VectorizedFunction && ((VectorizedFunction)o).getComponentFunction(0) instanceof MethodCall;
    }

    private MethodInfo getMethodInfo(Method method) {
        MethodInfo methodInfo = method.getAnnotation(MethodInfo.class);
        if (methodInfo != null) {
            return methodInfo;
        }
        return null;
    }

    public Method getVectorMatch(String methodName, Class c, Class[] paramTypes) {
        for (Method method : c.getMethods()) {
            if (!method.getName().equals(methodName) || !BooleanUtils.or((boolean[])MethodCall.isVectorMatch(method, paramTypes))) continue;
            return method;
        }
        return null;
    }

    public Method getVectorMatch(String methodName, Value<?> value, Value<?>[] arguments) {
        Class[] paramTypes = new Class[arguments.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = arguments[i].value().getClass();
        }
        Class<?> c = value.value().getClass();
        try {
            Method method = c.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            for (Method method : c.getMethods()) {
                if (!method.getName().equals(methodName) || !BooleanUtils.or((boolean[])MethodCall.isVectorMatch(method, paramTypes))) continue;
                return method;
            }
            return null;
        }
        return null;
    }

    private static boolean[] isVectorMatch(Method method, Class<?>[] paramTypes) {
        Class<?>[] methodParamTypes = method.getParameterTypes();
        if (methodParamTypes.length == paramTypes.length) {
            boolean[] vectorMatch = new boolean[paramTypes.length];
            for (int i = 0; i < methodParamTypes.length; ++i) {
                vectorMatch[i] = MethodCall.isVectorMatch(methodParamTypes[i], paramTypes[i]);
            }
            return vectorMatch;
        }
        throw new IllegalArgumentException("paramTypes array must be same length as method param types array!");
    }

    private static boolean isVectorMatch(Class<?> methodParamType, Class<?> paramType) {
        return paramType.isArray() && methodParamType.isAssignableFrom(paramType.getComponentType());
    }

    @Override
    public String getRichDescription(int index) {
        String html = "<html><h3>" + this.c.getSimpleName() + this.getName() + " method call</h3> <ul>";
        html = html + "<li>" + this.methodInfo.description();
        html = html + "</ul></html>";
        return html;
    }

    @Override
    public String getName() {
        return "." + this.methodName;
    }

    @Override
    public String getDescription() {
        return this.methodInfo.description();
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put(MethodCall.objectParamName, MethodCall.this.value);
                for (int i = 0; i < MethodCall.this.arguments.length; ++i) {
                    this.put(MethodCall.argParamName + i, MethodCall.this.arguments[i]);
                }
            }
        };
    }

    @Override
    public void setParam(String paramName, Value param) {
        if (paramName.equals(objectParamName)) {
            this.value = param;
        } else if (paramName.startsWith(argParamName)) {
            int index = Integer.parseInt(paramName.substring(argParamName.length()));
            this.arguments[index] = param;
        } else {
            throw new IllegalArgumentException("Param name " + paramName + " not recognised!");
        }
    }

    public Value<?> apply() {
        if (this.vectorizedArguments && this.vectorizedObject) {
            throw new UnsupportedOperationException("Doubly vectorized method calls not supported!");
        }
        Object[] args = new Object[this.arguments.length];
        for (int i = 0; i < this.paramTypes.length; ++i) {
            args[i] = this.arguments[i].value();
        }
        try {
            if (this.vectorizedObject) {
                int size = ((Vector)((Object)this.value)).size();
                ArrayList<Value> resultValues = new ArrayList<Value>();
                for (int i = 0; i < size; ++i) {
                    resultValues.add(ValueUtils.createValue(this.method.invoke(((Vector)((Object)this.value)).getComponent(i), args), (DeterministicFunction)this));
                }
                return new CompoundVectorValue(null, (List<Value>)resultValues, (DeterministicFunction)this);
            }
            if (this.vectorizedArguments) {
                return this.vectorApply(args);
            }
            Object obj = this.method.invoke(this.value.value(), args);
            if (obj instanceof Value) {
                obj = ((Value)obj).value();
            }
            return ValueUtils.createValue(obj, (DeterministicFunction)this);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Value<?> vectorApply(Object[] args) throws IllegalAccessException, InvocationTargetException {
        int vectorSize = this.getVectorSize(args);
        boolean[] isVector = MethodCall.isVectorMatch(this.method, (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new));
        ArrayList<Value> returnValues = new ArrayList<Value>();
        Object[] callArgs = new Object[args.length];
        for (int i = 0; i < vectorSize; ++i) {
            for (int j = 0; j < args.length; ++j) {
                callArgs[j] = isVector[j] ? Array.get(args[j], i) : args[j];
            }
            returnValues.add(ValueUtils.createValue(this.method.invoke(this.value.value(), callArgs), (DeterministicFunction)this));
        }
        return new CompoundVectorValue(null, (List<Value>)returnValues, (DeterministicFunction)this);
    }

    private int getVectorSize(Object[] args) {
        int size = 1;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(args[i].getClass())) continue;
            if (args[i].getClass().isArray() && parameterTypes[i].isAssignableFrom(args[i].getClass().getComponentType())) {
                int vecSize = Array.getLength(args[i]);
                if (vecSize <= size) continue;
                size = vecSize;
                continue;
            }
            throw new RuntimeException("Argument mismatch!");
        }
        return size;
    }

    @Override
    public String getInferenceNarrative(Value value, boolean unique, Narrative narrative) {
        String narrativeName = this.getNarrativeName();
        if (this.vectorizedArguments || this.vectorizedObject) {
            narrativeName = NarrativeUtils.pluralize(narrativeName);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(NarrativeUtils.getValueClause(value, unique, narrative));
        builder.append(this.vectorizedArguments || this.vectorizedObject ? " are " : " is ");
        builder.append(NarrativeUtils.getDefiniteArticle(narrativeName, true));
        builder.append(" ");
        builder.append(narrativeName);
        if (this.arguments.length > 0) {
            builder.append(" ");
            int count = 0;
            for (Value<?> arg : this.arguments) {
                if (count > 0) {
                    if (count == this.arguments.length - 1) {
                        builder.append(" and ");
                    } else {
                        builder.append(", ");
                    }
                }
                builder.append(narrative.text(arg.toString()));
                ++count;
            }
        }
        builder.append(" of " + (this.vectorizedObject ? " each element in " : ""));
        builder.append(NarrativeUtils.getValueClause(this.value, this.vectorizedObject, true, this.vectorizedObject, narrative));
        builder.append(".");
        return builder.toString();
    }

    @Override
    public String codeString() {
        StringBuilder builder = new StringBuilder();
        String id = this.value.getId();
        if (this.value.isAnonymous() && (this.value.getGenerator() instanceof ElementsAt || this.value.getGenerator() instanceof Slice)) {
            id = this.value.getGenerator().codeString();
        }
        builder.append(id + this.getName());
        builder.append("(");
        if (this.arguments.length > 0) {
            builder.append(this.argumentString(this.arguments[0]));
        }
        for (int i = 1; i < this.arguments.length; ++i) {
            builder.append(", ");
            builder.append(this.argumentString(this.arguments[i]));
        }
        builder.append(")");
        return builder.toString();
    }

    private String argumentString(Value value) {
        if (value.isAnonymous()) {
            return value.codeString();
        }
        return value.getId();
    }

    @Override
    public String getNarrativeName() {
        String narrativeName = this.methodInfo.narrativeName();
        if (narrativeName.length() > 0) {
            return narrativeName;
        }
        return this.getName();
    }

    @Override
    public String getTypeName() {
        if (this.vectorizedArguments || this.vectorizedObject) {
            return "vector of " + NarrativeUtils.pluralize(this.method.getReturnType().getSimpleName());
        }
        return this.method.getReturnType().getSimpleName();
    }

    @Override
    public String getNarrativeName(Value value) {
        String paramName = this.getParamName(value);
        if (paramName.startsWith(argParamName)) {
            int argumentIndex = Integer.parseInt(paramName.substring(argParamName.length()));
            return "argument " + argumentIndex;
        }
        if (paramName.equals(objectParamName)) {
            return NarrativeUtils.getTypeName(value);
        }
        throw new RuntimeException("Expected either arg[0-9] or object, but got " + paramName);
    }
}

