/*
 * Decompiled with CFR 0.152.
 */
package lphy.parser.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lphy.core.functions.Range;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GraphicalModelNode;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.IntegerArrayValue;
import lphy.util.LoggerUtils;

public class RangeList
extends DeterministicFunction<Integer[]> {
    List<GraphicalModelNode> rangeElements = new ArrayList<GraphicalModelNode>();

    public RangeList(GraphicalModelNode ... rangeElements) {
        int arg = 0;
        for (GraphicalModelNode node : rangeElements) {
            Object value = node.value();
            if (value instanceof Integer || value instanceof Integer[]) {
                this.rangeElements.add(node);
                if (node instanceof Value) {
                    this.setInput("" + arg, (Value)node);
                } else if (node instanceof DeterministicFunction) {
                    this.setInput("" + arg, ((DeterministicFunction)node).apply());
                }
                ++arg;
                continue;
            }
            LoggerUtils.log.severe("Non integer in RangeList: " + value);
        }
    }

    public IntegerArrayValue apply() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (GraphicalModelNode node : this.rangeElements) {
            Object value = node.value();
            if (value instanceof Integer) {
                indices.add((Integer)value);
                continue;
            }
            indices.addAll(Arrays.asList((Integer[])value));
        }
        return new IntegerArrayValue(null, indices.toArray(new Integer[0]), (DeterministicFunction)this);
    }

    public boolean isRange() {
        return this.rangeElements.size() == 1 && this.rangeElements.get(0) instanceof Range;
    }

    public boolean isSingle() {
        return this.rangeElements.size() == 1 && this.rangeElements.get(0).value() instanceof Integer;
    }

    public GraphicalModelNode getRangeElement(int i) {
        return this.rangeElements.get(i);
    }

    public int size() {
        return this.rangeElements.size();
    }

    @Override
    public String codeString() {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (GraphicalModelNode node : this.rangeElements) {
            if (count > 0) {
                builder.append(",");
            }
            if (node instanceof Value) {
                if (((Value)node).isAnonymous()) {
                    builder.append(((Value)node).codeString());
                } else {
                    builder.append(((Value)node).getId());
                }
            } else if (node instanceof DeterministicFunction) {
                builder.append(((DeterministicFunction)node).codeString());
            }
            ++count;
        }
        return builder.toString();
    }
}

