/*
 * Decompiled with CFR 0.152.
 */
package lphy.util;

import java.nio.file.Path;
import java.nio.file.Paths;

public class IOUtils {
    public static final String USER_DIR = "user.dir";

    public static Path getUserPath(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        return IOUtils.getUserPath(path);
    }

    public static Path getUserPath(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        String wd = System.getProperty(USER_DIR);
        return Paths.get(wd, path.toString());
    }

    public static void setUserDir(String pathStr) {
        if (pathStr != null) {
            System.setProperty(USER_DIR, pathStr);
            System.out.println("Set user.dir = " + pathStr);
        }
    }

    public static Path getUserDir() {
        String wd = System.getProperty(USER_DIR);
        if (wd != null) {
            return Paths.get(wd, new String[0]);
        }
        return Paths.get("", new String[0]);
    }
}

