/*
 * Decompiled with CFR 0.152.
 */
package lphy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Symbols {
    public static final String[] symbolNames = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "Gamma", "Delta", "Theta", "Lambda", "Xi", "Pi", "Sigma", "Omega", "propto"};
    public static final String[] symbolCodes = Symbols.prepend("\\", symbolNames);
    public static final String[] unicodeSymbols = new String[]{"\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b6", "\u03b7", "\u03b8", "\u03b9", "\u03ba", "\u03bb", "\u03bc", "\u03bd", "\u03be", "\u03bf", "\u03c0", "\u03c1", "\u03c3", "\u03c4", "\u03c5", "\u03c6", "\u03c7", "\u03c8", "\u03c9", "\u0393", "\u0394", "\u0398", "\u039b", "\u039e", "\u03a0", "\u03a3", "\u03a9", "\u221d"};
    public static final String allUnicodeSymbols = String.join((CharSequence)"", unicodeSymbols);
    static final Map<String, String> symbolToNameMap = IntStream.range(0, unicodeSymbols.length).boxed().collect(Collectors.toMap(i -> unicodeSymbols[i], i -> symbolNames[i]));
    static final Map<String, String> nameToSymbolMap = IntStream.range(0, unicodeSymbols.length).boxed().collect(Collectors.toMap(i -> symbolNames[i], i -> unicodeSymbols[i]));

    private static String[] prepend(String pre, String[] array) {
        String[] prepended = new String[array.length];
        for (int i = 0; i < prepended.length; ++i) {
            prepended[i] = pre + array[i];
        }
        return prepended;
    }

    public static String getCanonical(String name) {
        return Symbols.getCanonical(name, "", "");
    }

    public static String getCanonical(String name, String prefix, String suffix) {
        if (name == null) {
            return null;
        }
        for (String unicodeSymbol : unicodeSymbols) {
            if (!((String)name).contains(unicodeSymbol)) continue;
            int index = ((String)name).indexOf(unicodeSymbol);
            String newname = ((String)name).substring(0, index) + prefix + symbolToNameMap.get(unicodeSymbol) + suffix;
            if (index < ((String)name).length() - 1) {
                newname = newname + ((String)name).substring(index + 1);
            }
            name = newname;
        }
        return name;
    }

    public static List<Block> getCanonicalizedName(String name) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        StringBuilder currentAsciiBlock = new StringBuilder();
        boolean inAsciiBlock = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            int index = allUnicodeSymbols.indexOf(c);
            if (index >= 0) {
                if (inAsciiBlock) {
                    blocks.add(new Block(currentAsciiBlock.toString(), false));
                    currentAsciiBlock = new StringBuilder();
                }
                blocks.add(new Block(symbolNames[index], true));
                continue;
            }
            if (!inAsciiBlock) {
                inAsciiBlock = true;
            }
            currentAsciiBlock.append(c);
        }
        if (inAsciiBlock) {
            inAsciiBlock = false;
            blocks.add(new Block(currentAsciiBlock.toString(), false));
        }
        return blocks;
    }

    public static class Block {
        public final String string;
        public final boolean isCanonicalized;

        public Block(String string, boolean isCanonicalized) {
            this.string = string;
            this.isCanonicalized = isCanonicalized;
        }
    }
}

