/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AutoMapperProperties;
import io.github.linpeilie.processor.metadata.AbstractAdapterMethodMetadata;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public abstract class AbstractAdapterMapperGenerator {
    public void write(ProcessingEnvironment processingEnv, Collection<AbstractAdapterMethodMetadata> adapterMethods, String adapterClassName) {
        try (Writer writer = processingEnv.getFiler().createSourceFile(this.adapterPackage() + "." + adapterClassName, new Element[0]).openWriter();){
            JavaFile.builder((String)this.adapterPackage(), (TypeSpec)this.createTypeSpec(adapterMethods, adapterClassName)).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + adapterClassName + " output file: " + e.getMessage());
        }
    }

    protected abstract TypeSpec createTypeSpec(Collection<AbstractAdapterMethodMetadata> var1, String var2);

    protected String adapterPackage() {
        return AutoMapperProperties.getAdapterPackage();
    }
}

