/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import io.github.linpeilie.annotations.AutoEnumMapper;
import io.github.linpeilie.annotations.AutoMapMapper;
import io.github.linpeilie.annotations.ComponentModelConfig;
import io.github.linpeilie.processor.AbstractAdapterMapperGenerator;
import io.github.linpeilie.processor.AdapterMapperGeneratorFactory;
import io.github.linpeilie.processor.AutoMapperProperties;
import io.github.linpeilie.processor.BuildCollator;
import io.github.linpeilie.processor.DuplicateMapperException;
import io.github.linpeilie.processor.ProcessorOptions;
import io.github.linpeilie.processor.gem.AutoMapperGem;
import io.github.linpeilie.processor.gem.AutoMappersGem;
import io.github.linpeilie.processor.gem.AutoMappingGem;
import io.github.linpeilie.processor.gem.AutoMappingsGem;
import io.github.linpeilie.processor.gem.BuilderGem;
import io.github.linpeilie.processor.gem.MapperConfigGem;
import io.github.linpeilie.processor.gem.ReverseAutoMappingGem;
import io.github.linpeilie.processor.gem.ReverseAutoMappingsGem;
import io.github.linpeilie.processor.generator.AutoEnumMapperGenerator;
import io.github.linpeilie.processor.generator.AutoMapperGenerator;
import io.github.linpeilie.processor.generator.MapperConfigGenerator;
import io.github.linpeilie.processor.metadata.AbstractAdapterMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterEnumMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterMapMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterMethodMetadata;
import io.github.linpeilie.processor.metadata.AutoEnumMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMapMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMappingMetadata;
import io.github.linpeilie.processor.utils.ExceptionUtils;
import io.github.linpeilie.processor.utils.MapperUtils;
import io.github.linpeilie.processor.utils.ObjectUtils;
import io.github.linpeilie.utils.CollectionUtils;
import io.github.linpeilie.utils.StrUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.github.linpeilie.annotations.AutoMapper", "io.github.linpeilie.annotations.AutoMappers", "io.github.linpeilie.annotations.AutoMapMapper", "io.github.linpeilie.annotations.AutoEnumMapper", "io.github.linpeilie.annotations.MapperConfig", "io.github.linpeilie.annotations.ComponentModelConfig", "org.mapstruct.Mapper"})
@SupportedOptions(value={"mapstruct.plus.mapperConfigClass", "mapstruct.plus.mapperPackage", "mapstruct.plus.unmappedSourcePolicy", "mapstruct.plus.unmappedTargetPolicy", "mapstruct.plus.nullValueMappingStrategy", "mapstruct.plus.nullValuePropertyMappingStrategy", "mapstruct.plus.builder.buildMethod", "mapstruct.plus.builder.disableBuilder", "mapstruct.plus.adapterPackage", "mapstruct.plus.adapterClassName", "mapstruct.plus.mapAdapterClassName", "mapstruct.plus.typeConversionPolicy", "mapstruct.plus.collectionMappingStrategy", "mapstruct.plus.nullValueIterableMappingStrategy", "mapstruct.plus.nullValueMapMappingStrategy", "mapstruct.plus.nullValueCheckStrategy", "mapstruct.plus.suppressTimestampInGenerated"})
public class AutoMapperProcessor
extends AbstractProcessor {
    private static final ClassName MAPPING_DEFAULT_TARGET = ClassName.get((String)"io.github.linpeilie", (String)"DefaultMapping", (String[])new String[0]);
    private final AutoMapperGenerator mapperGenerator;
    private AbstractAdapterMapperGenerator adapterMapperGenerator;
    private final MapperConfigGenerator mapperConfigGenerator;
    private final Map<String, AbstractAdapterMethodMetadata> methodMap = new HashMap<String, AbstractAdapterMethodMetadata>();
    private final Map<String, AbstractAdapterMethodMetadata> mapMethodMap = new HashMap<String, AbstractAdapterMethodMetadata>();
    private final List<AutoMapperMetadata> mapperList = new ArrayList<AutoMapperMetadata>();
    private final List<TypeMirror> customMapperList = new ArrayList<TypeMirror>();
    private final Set<String> mapperSet = new HashSet<String>();
    private static final Map<String, Integer> AUTO_MAPPER_INDEX = new HashMap<String, Integer>();
    private final Map<String, List<ClassName>> typeRelationMappers = new HashMap<String, List<ClassName>>();
    private Messager messager;

    public AutoMapperProcessor() {
        this.mapperGenerator = new AutoMapperGenerator();
        this.mapperConfigGenerator = new MapperConfigGenerator();
    }

    private boolean isAutoMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isAutoMappersAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMappers".contentEquals(annotation.getQualifiedName());
    }

    private boolean isAutoMapMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMapMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isAutoEnumMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoEnumMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isMapperConfigAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.MapperConfig".contentEquals(annotation.getQualifiedName());
    }

    private boolean isComponentModelConfigAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.ComponentModelConfig".contentEquals(annotation.getQualifiedName());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.doProcess(annotations, roundEnv);
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ExceptionUtils.getStackTrace(e));
        }
        return false;
    }

    private void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean hasAutoMapper = annotations.stream().anyMatch(this::isAutoMapperAnnotation);
        boolean hasAutoMapMapper = annotations.stream().anyMatch(this::isAutoMapMapperAnnotation);
        boolean hasAutoEnumMapper = annotations.stream().anyMatch(this::isAutoEnumMapperAnnotation);
        boolean hasAutoMapMappers = annotations.stream().anyMatch(this::isAutoMappersAnnotation);
        boolean hasMapperConfig = annotations.stream().anyMatch(this::isMapperConfigAnnotation);
        if (!(hasAutoMapper || hasAutoMapMapper || hasAutoEnumMapper || hasAutoMapMappers || hasMapperConfig)) {
            return;
        }
        this.refreshProperties(annotations, roundEnv);
        this.adapterMapperGenerator = AdapterMapperGeneratorFactory.instance(AutoMapperProperties.getComponentModel());
        TypeElement autoMapMapperAnnotation = this.processingEnv.getElementUtils().getTypeElement("io.github.linpeilie.annotations.AutoMapMapper");
        this.processAutoMapMapperAnnotation(roundEnv, autoMapMapperAnnotation);
        TypeElement autoEnumMapperAnnotation = this.processingEnv.getElementUtils().getTypeElement("io.github.linpeilie.annotations.AutoEnumMapper");
        this.processAutoEnumMapperAnnotation(roundEnv, autoEnumMapperAnnotation);
        TypeElement autoMapperAnnotation = this.processingEnv.getElementUtils().getTypeElement("io.github.linpeilie.annotations.AutoMapper");
        this.processAutoMapperAnnotation(roundEnv, autoMapperAnnotation);
        TypeElement autoMappersAnnotation = this.processingEnv.getElementUtils().getTypeElement("io.github.linpeilie.annotations.AutoMappers");
        this.processAutoMappersAnnotation(roundEnv, autoMappersAnnotation);
        TypeElement mapperAnnotation = this.processingEnv.getElementUtils().getTypeElement("org.mapstruct.Mapper");
        this.processMapperAnnotation(roundEnv, mapperAnnotation);
        this.generateMapper();
    }

    private List<TypeElement> getElementAndMergeHistory(RoundEnvironment roundEnv, TypeElement annotation, BuildCollator buildCollator) {
        buildCollator.appendNonexistent(roundEnv.getElementsAnnotatedWith(annotation));
        return buildCollator.getRecords();
    }

    private void processMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        if (annotation == null) {
            return;
        }
        List<TypeElement> elements = this.getElementAndMergeHistory(roundEnv, annotation, new BuildCollator(this.processingEnv, "mappers"));
        elements.forEach(element -> this.customMapperList.add(element.asType()));
    }

    private void processAutoEnumMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        if (annotation == null) {
            return;
        }
        List<TypeElement> elements = this.getElementAndMergeHistory(roundEnv, annotation, new BuildCollator(this.processingEnv, "enumMappers"));
        elements.stream().map(this::buildAutoEnumMapperMetadata).filter(Objects::nonNull).forEach(this::writeAutoEnumMapperFile);
    }

    private void writeAutoEnumMapperFile(AutoEnumMapperMetadata autoEnumMapperMetadata) {
        AutoEnumMapperGenerator autoEnumMapperGenerator = new AutoEnumMapperGenerator();
        try (Writer writer = this.processingEnv.getFiler().createSourceFile(autoEnumMapperMetadata.mapperPackage() + "." + autoEnumMapperMetadata.mapperName(), new Element[0]).openWriter();){
            autoEnumMapperGenerator.write(autoEnumMapperMetadata, writer);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + autoEnumMapperMetadata.mapperName() + " output file : " + e.getMessage());
        }
        this.addAdapterMethodMetadata(autoEnumMapperMetadata);
    }

    private void addAdapterMethodMetadata(AutoEnumMapperMetadata autoEnumMapperMetadata) {
        if (autoEnumMapperMetadata == null) {
            return;
        }
        AdapterEnumMethodMetadata toValueProxyMethod = new AdapterEnumMethodMetadata((TypeName)autoEnumMapperMetadata.getSourceClassName(), ClassName.get((String)autoEnumMapperMetadata.mapperPackage(), (String)autoEnumMapperMetadata.mapperName(), (String[])new String[0]), autoEnumMapperMetadata.toValueMethodName(), autoEnumMapperMetadata.getReturnType());
        AdapterEnumMethodMetadata toEnumProxyMethod = new AdapterEnumMethodMetadata(autoEnumMapperMetadata.getReturnType(), ClassName.get((String)autoEnumMapperMetadata.mapperPackage(), (String)autoEnumMapperMetadata.mapperName(), (String[])new String[0]), autoEnumMapperMetadata.toEnumMethodName(), (TypeName)autoEnumMapperMetadata.getSourceClassName());
        this.methodMap.putIfAbsent(autoEnumMapperMetadata.getSourceClassName().simpleName() + toValueProxyMethod.getMapperMethodName(), toValueProxyMethod);
        this.methodMap.put(autoEnumMapperMetadata.getSourceClassName().simpleName() + toEnumProxyMethod.getMapperMethodName(), toEnumProxyMethod);
    }

    private AutoEnumMapperMetadata buildAutoEnumMapperMetadata(Element element) {
        AutoEnumMapper autoEnumMapper = element.getAnnotation(AutoEnumMapper.class);
        ClassName enumClassName = ClassName.get((TypeElement)((TypeElement)element));
        String enumCodeFieldName = autoEnumMapper.value();
        Element enumCodeGetterElement = null;
        List<? extends Element> enclosedElements = element.getEnclosedElements();
        for (Element element2 : enclosedElements) {
            boolean isGetter;
            if (!ElementKind.METHOD.equals((Object)element2.getKind()) || !(isGetter = StrUtil.equalsIgnoreCase((CharSequence)element2.getSimpleName(), (CharSequence)("get" + enumCodeFieldName)) || StrUtil.equalsIgnoreCase((CharSequence)element2.getSimpleName(), (CharSequence)("is" + enumCodeFieldName)))) continue;
            enumCodeGetterElement = element2;
            break;
        }
        if (enumCodeGetterElement == null) {
            return null;
        }
        String getter = enumCodeGetterElement.getSimpleName().toString();
        TypeName typeName = TypeName.get((TypeMirror)((ExecutableElement)enumCodeGetterElement).getReturnType());
        AutoEnumMapperMetadata autoEnumMapperMetadata = new AutoEnumMapperMetadata();
        autoEnumMapperMetadata.setSourceClassName(enumClassName);
        autoEnumMapperMetadata.setGetter(getter);
        autoEnumMapperMetadata.setReturnType(typeName);
        return autoEnumMapperMetadata;
    }

    private void processAutoMapMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        if (annotation == null) {
            return;
        }
        List<TypeElement> elements = this.getElementAndMergeHistory(roundEnv, annotation, new BuildCollator(this.processingEnv, "autoMapMappers"));
        elements.stream().map(this::buildAutoMapMapperMetadata).filter(Objects::nonNull).forEach(metadata -> {
            this.writeAutoMapperClassFile((AutoMapperMetadata)metadata);
            this.addAdapterMapMethod((AutoMapperMetadata)metadata);
        });
        if (this.mapMethodMap.isEmpty()) {
            return;
        }
        this.adapterMapperGenerator.write(this.processingEnv, this.mapMethodMap.values(), AutoMapperProperties.getMapAdapterClassName(), false);
        this.mapperConfigGenerator.write(this.processingEnv, AutoMapperProperties.getMapConfigClassName(), AutoMapperProperties.getMapAdapterClassName(), null);
    }

    private AutoMapperMetadata buildAutoMapMapperMetadata(TypeElement element) {
        if (element.getAnnotation(AutoMapMapper.class) == null) {
            return null;
        }
        ClassName source = ClassName.get((String)"java.util", (String)"Map", (String[])new String[0]);
        ClassName target = ClassName.get((TypeElement)element);
        List<ClassName> uses = Collections.singletonList(ClassName.get((String)"io.github.linpeilie.map", (String)"MapObjectConvert", (String[])new String[0]));
        AutoMapMapperMetadata autoMapperMetadata = new AutoMapMapperMetadata(source, target);
        autoMapperMetadata.setUsesClassNameList(uses);
        autoMapperMetadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseMapMapper", (String[])new String[0]));
        autoMapperMetadata.setSuperGenerics(new ClassName[]{target});
        autoMapperMetadata.setMapstructConfigClass(ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getMapConfigClassName(), (String[])new String[0]));
        return autoMapperMetadata;
    }

    private void addAdapterMapMethod(AutoMapperMetadata metadata) {
        if (metadata == null) {
            return;
        }
        this.addAdapterMapMethod(metadata.getSourceClassName(), metadata.getTargetClassName(), metadata.mapperClass(), false);
    }

    private void loadMapperConfig(MapperConfigGem mapperConfigGem) {
        if (mapperConfigGem == null || !mapperConfigGem.isValid()) {
            return;
        }
        if (mapperConfigGem.mapperPackage().hasValue()) {
            AutoMapperProperties.setMapperPackage((String)mapperConfigGem.mapperPackage().get());
        }
        AutoMapperProperties.setUnmappedSourcePolicy((String)mapperConfigGem.unmappedSourcePolicy().getValue());
        AutoMapperProperties.setUnmappedTargetPolicy((String)mapperConfigGem.unmappedTargetPolicy().get());
        AutoMapperProperties.setTypeConversionPolicy((String)mapperConfigGem.typeConversionPolicy().getValue());
        AutoMapperProperties.setCollectionMappingStrategy((String)mapperConfigGem.collectionMappingStrategy().getValue());
        AutoMapperProperties.setNullValueMappingStrategy((String)mapperConfigGem.nullValueMappingStrategy().getValue());
        AutoMapperProperties.setNullValueIterableMappingStrategy((String)mapperConfigGem.nullValueIterableMappingStrategy().getValue());
        AutoMapperProperties.setNullValueMapMappingStrategy((String)mapperConfigGem.nullValueMapMappingStrategy().getValue());
        AutoMapperProperties.setNullValuePropertyMappingStrategy((String)mapperConfigGem.nullValuePropertyMappingStrategy().getValue());
        AutoMapperProperties.setNullValueCheckStrategy((String)mapperConfigGem.nullValueCheckStrategy().getValue());
        if (mapperConfigGem.mappingControl().hasValue()) {
            AutoMapperProperties.setMappingControl(this.transToClassName((TypeMirror)mapperConfigGem.mappingControl().get()));
        }
        if (mapperConfigGem.unexpectedValueMappingException().hasValue()) {
            AutoMapperProperties.setUnexpectedValueMappingException(this.transToClassName((TypeMirror)mapperConfigGem.unexpectedValueMappingException().get()));
        }
        AutoMapperProperties.setSuppressTimestampInGenerated((Boolean)mapperConfigGem.suppressTimestampInGenerated().getValue());
        BuilderGem builderGem = (BuilderGem)mapperConfigGem.builder().get();
        if (builderGem.buildMethod().hasValue()) {
            AutoMapperProperties.setBuildMethod((String)builderGem.buildMethod().get());
        }
        AutoMapperProperties.setDisableBuilder((Boolean)builderGem.disableBuilder().get());
        if (mapperConfigGem.adapterPackage().hasValue()) {
            AutoMapperProperties.setAdapterPackage((String)mapperConfigGem.adapterPackage().get());
        }
        if (mapperConfigGem.adapterClassName().hasValue()) {
            AutoMapperProperties.setAdapterClassName((String)mapperConfigGem.adapterClassName().get());
        }
        if (mapperConfigGem.mapAdapterClassName().hasValue()) {
            AutoMapperProperties.setMapAdapterClassName((String)mapperConfigGem.mapAdapterClassName().get());
        }
        if (mapperConfigGem.autoConfigPackage().hasValue()) {
            AutoMapperProperties.setAutoConfigPackage((String)mapperConfigGem.autoConfigPackage().get());
        }
        if (mapperConfigGem.autoMapperConfigClassName().hasValue()) {
            AutoMapperProperties.setAutoMapperConfigClassName((String)mapperConfigGem.autoMapperConfigClassName().get());
        }
        if (mapperConfigGem.autoMapMapperConfigClassName().hasValue()) {
            AutoMapperProperties.setAutoMapMapperConfigClassName((String)mapperConfigGem.autoMapMapperConfigClassName().get());
        }
    }

    private void refreshProperties(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement typeElement;
        String mapperConfigClass;
        Optional mapperConfigOptional;
        TypeElement mapperConfigAnnotation;
        BuildCollator buildCollator = new BuildCollator(this.processingEnv, "config");
        List<TypeElement> typeElements = buildCollator.getRecords();
        if (CollectionUtils.isNotEmpty(typeElements)) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "The previous Mapper Config Class was read , class name : " + typeElements.get(0));
            this.loadMapperConfig(MapperConfigGem.instanceOn(typeElements.get(0)));
        }
        if ((mapperConfigAnnotation = this.processingEnv.getElementUtils().getTypeElement("io.github.linpeilie.annotations.MapperConfig")) != null && (mapperConfigOptional = roundEnv.getElementsAnnotatedWith(mapperConfigAnnotation).stream().findFirst()).isPresent()) {
            this.loadMapperConfig(MapperConfigGem.instanceOn((Element)mapperConfigOptional.get()));
            buildCollator.writeTypeElements(Collections.singletonList((TypeElement)mapperConfigOptional.get()));
        }
        if (StrUtil.isNotEmpty((CharSequence)(mapperConfigClass = this.processingEnv.getOptions().get("mapstruct.plus.mapperConfigClass"))) && (typeElement = this.processingEnv.getElementUtils().getTypeElement(mapperConfigClass)) != null) {
            this.loadMapperConfig(MapperConfigGem.instanceOn(typeElement));
        }
        annotations.stream().filter(this::isComponentModelConfigAnnotation).findFirst().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().findFirst()).ifPresent(element -> {
            ComponentModelConfig componentModelConfig = element.getAnnotation(ComponentModelConfig.class);
            String componentModelByAnnotation = componentModelConfig.componentModel();
            AutoMapperProperties.setComponentModel(componentModelByAnnotation);
        });
        this.loadCompilerArgs();
    }

    private void loadCompilerArgs() {
        ProcessorOptions.optionConsumers().forEach((key, consumer) -> {
            String value = this.processingEnv.getOptions().get(key);
            if (StrUtil.isNotEmpty((CharSequence)value)) {
                consumer.accept(value);
            }
        });
    }

    private void processAutoMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        if (annotation == null) {
            return;
        }
        List<TypeElement> elements = this.getElementAndMergeHistory(roundEnv, annotation, new BuildCollator(this.processingEnv, "autoMapper"));
        List autoMapperMetadataList = elements.stream().map(this::buildAutoMapperMetadata).filter(Objects::nonNull).collect(Collectors.toList());
        this.mapperList.addAll(autoMapperMetadataList);
    }

    private void processAutoMappersAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        if (annotation == null) {
            return;
        }
        List autoMapperMetadata = this.getElementAndMergeHistory(roundEnv, annotation, new BuildCollator(this.processingEnv, "autoMappers")).stream().map(this::buildAutoMapperMetadataByAutoMappers).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        this.mapperList.addAll(autoMapperMetadata);
    }

    private List<AutoMapperMetadata> generateReverseConverters() {
        ArrayList<AutoMapperMetadata> reverseMapperMetadataList = new ArrayList<AutoMapperMetadata>();
        this.mapperList.forEach(autoMapperMetadata -> {
            if (!autoMapperMetadata.isReverseConvertGenerate()) {
                return;
            }
            boolean defineReverseMapping = CollectionUtils.isNotEmpty(autoMapperMetadata.getFieldReverseMappingList());
            AutoMapperMetadata reverseMapperMetadata = this.reverseMapper((AutoMapperMetadata)autoMapperMetadata);
            if (defineReverseMapping) {
                this.addMapper(reverseMapperMetadata, true);
            } else if (!this.addMapper(reverseMapperMetadata, false)) {
                return;
            }
            reverseMapperMetadataList.add(reverseMapperMetadata);
        });
        return reverseMapperMetadataList;
    }

    private void typeRelationMapper(AutoMapperMetadata metadata) {
        String source = metadata.getSourceClassName().reflectionName();
        if (!this.typeRelationMappers.containsKey(source)) {
            this.typeRelationMappers.put(source, new ArrayList());
        }
        this.typeRelationMappers.get(source).add(metadata.mapperClass());
        String target = metadata.getTargetClassName().reflectionName();
        if (!this.typeRelationMappers.containsKey(target)) {
            this.typeRelationMappers.put(target, new ArrayList());
        }
        this.typeRelationMappers.get(target).add(metadata.mapperClass());
    }

    private void generateMapper() {
        this.mapperList.addAll(this.generateReverseConverters());
        this.mapperList.removeIf(metadata -> !metadata.isConvertGenerate());
        this.mapperList.forEach(metadata -> {
            this.mapperNameAddSuffix((AutoMapperMetadata)metadata);
            if (metadata.isCycleAvoiding()) {
                this.addAdapterMethod((AutoMapperMetadata)metadata);
            } else {
                this.typeRelationMapper((AutoMapperMetadata)metadata);
            }
        });
        this.mapperList.forEach(metadata -> {
            this.relationDependencies((AutoMapperMetadata)metadata);
            this.usesRemoveItself((AutoMapperMetadata)metadata);
            this.writeAutoMapperClassFile((AutoMapperMetadata)metadata);
        });
        this.adapterMapperGenerator.write(this.processingEnv, this.methodMap.values(), AutoMapperProperties.getAdapterClassName(), false);
        this.mapperConfigGenerator.write(this.processingEnv, AutoMapperProperties.getConfigClassName(), AutoMapperProperties.getAdapterClassName(), this.customMapperList);
        boolean needCycleAvoiding = this.methodMap.values().stream().anyMatch(AbstractAdapterMethodMetadata::needCycleAvoiding);
        if (needCycleAvoiding) {
            this.adapterMapperGenerator.write(this.processingEnv, this.methodMap.values(), AutoMapperProperties.getCycleAvoidingAdapterClassName(), true);
            this.mapperConfigGenerator.write(this.processingEnv, AutoMapperProperties.getCycleAvoidingConfigClassName(), AutoMapperProperties.getCycleAvoidingAdapterClassName(), this.customMapperList);
        }
    }

    private void mapperNameAddSuffix(AutoMapperMetadata metadata) {
        String mapperName = metadata.mapperName();
        Integer index = AUTO_MAPPER_INDEX.getOrDefault(mapperName, 0);
        if (index > 0) {
            mapperName = mapperName + "__" + index;
        }
        index = index + 1;
        AUTO_MAPPER_INDEX.put(metadata.mapperName(), index);
        metadata.setMapperName(mapperName);
    }

    private void relationDependencies(AutoMapperMetadata metadata) {
        List<ClassName> sourceDependencies;
        List<ClassName> dependencyMappers;
        Set<TypeName> dependencies = metadata.getDependencies();
        if (CollectionUtils.isNotEmpty(dependencies) && CollectionUtils.isNotEmpty(dependencyMappers = dependencies.stream().map(dependency -> this.typeRelationMappers.get(dependency.toString())).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()))) {
            metadata.addUseList(dependencyMappers);
        }
        if (CollectionUtils.isNotEmpty(sourceDependencies = this.typeRelationMappers.get(metadata.getSourceClassName().reflectionName()))) {
            metadata.addUseList(sourceDependencies);
        }
    }

    private void usesRemoveItself(AutoMapperMetadata metadata) {
        if (CollectionUtils.isNotEmpty(metadata.getUsesClassNameList())) {
            metadata.getUsesClassNameList().removeIf(use -> use.reflectionName().equals(metadata.mapperClass().reflectionName()));
        }
    }

    private Set<TypeName> listDependencies(TypeElement autoMapperEle) {
        HashSet<TypeName> set = new HashSet<TypeName>();
        if (!autoMapperEle.getKind().isClass() && !autoMapperEle.getKind().isInterface()) {
            return set;
        }
        for (Element element : autoMapperEle.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD) continue;
            TypeName typeName = ClassName.get((TypeMirror)element.asType());
            if (typeName instanceof ArrayTypeName) {
                ArrayTypeName arrayTypeName = (ArrayTypeName)typeName;
                typeName = arrayTypeName.componentType;
            } else if (typeName instanceof ParameterizedTypeName) {
                ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
                List typeArguments = parameterizedTypeName.typeArguments;
                set.addAll(typeArguments);
                continue;
            }
            set.add(typeName);
        }
        this.getSuperClass(autoMapperEle).ifPresent(superClass -> set.addAll(this.listDependencies((TypeElement)superClass)));
        set.removeIf(ele -> {
            if (ele == null) {
                return true;
            }
            try {
                if (ele.box().isBoxedPrimitive()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        });
        return set;
    }

    private AutoMapperMetadata reverseMapper(AutoMapperMetadata autoMapperMetadata) {
        AutoMapperMetadata reverseMapperMetadata = this.initAutoMapperMetadata(autoMapperMetadata.getTargetClassName(), autoMapperMetadata.getSourceClassName(), autoMapperMetadata.isCycleAvoiding());
        reverseMapperMetadata.setConvertGenerate(autoMapperMetadata.isReverseConvertGenerate());
        reverseMapperMetadata.setUsesClassNameList(autoMapperMetadata.getUsesClassNameList());
        reverseMapperMetadata.setImportsClassNameList(autoMapperMetadata.getImportsClassNameList());
        reverseMapperMetadata.setCycleAvoiding(autoMapperMetadata.isCycleAvoiding());
        if (reverseMapperMetadata.isCycleAvoiding()) {
            reverseMapperMetadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseCycleAvoidingMapper", (String[])new String[0]));
        } else {
            reverseMapperMetadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseMapper", (String[])new String[0]));
        }
        reverseMapperMetadata.setUnmappedSourcePolicy(autoMapperMetadata.getUnmappedSourcePolicy());
        reverseMapperMetadata.setUnmappedTargetPolicy(autoMapperMetadata.getUnmappedTargetPolicy());
        reverseMapperMetadata.setTypeConversionPolicy(autoMapperMetadata.getTypeConversionPolicy());
        reverseMapperMetadata.setCollectionMappingStrategy(autoMapperMetadata.getCollectionMappingStrategy());
        reverseMapperMetadata.setNullValueMappingStrategy(autoMapperMetadata.getNullValueMappingStrategy());
        reverseMapperMetadata.setNullValueIterableMappingStrategy(autoMapperMetadata.getNullValueIterableMappingStrategy());
        reverseMapperMetadata.setNullValuePropertyMappingStrategy(autoMapperMetadata.getNullValuePropertyMappingStrategy());
        reverseMapperMetadata.setNullValueCheckStrategy(autoMapperMetadata.getNullValueCheckStrategy());
        reverseMapperMetadata.setMappingControl(autoMapperMetadata.getMappingControl());
        reverseMapperMetadata.setMapperNameSuffix(autoMapperMetadata.getMapperNameSuffix());
        List<AutoMappingMetadata> fieldReverseMappingList = autoMapperMetadata.getFieldReverseMappingList();
        if (CollectionUtils.isEmpty(fieldReverseMappingList)) {
            Map autoMappingMap = autoMapperMetadata.getFieldMappingList().stream().filter(AutoMappingMetadata::getReverseConvertGenerate).map(fieldMapping -> {
                AutoMappingMetadata autoMappingMetadata = new AutoMappingMetadata();
                autoMappingMetadata.setSource(fieldMapping.getTarget());
                autoMappingMetadata.setTarget(fieldMapping.getSource());
                return autoMappingMetadata;
            }).collect(Collectors.toMap(AutoMappingMetadata::getTarget, Function.identity(), (a, b) -> a));
            fieldReverseMappingList = new ArrayList(autoMappingMap.values());
        }
        reverseMapperMetadata.setFieldMappingList(fieldReverseMappingList);
        return reverseMapperMetadata;
    }

    private void writeAutoMapperClassFile(AutoMapperMetadata metadata) {
        this.mapperGenerator.write(metadata, this.processingEnv);
    }

    private void addAdapterMethod(AutoMapperMetadata metadata) {
        if (metadata == null) {
            return;
        }
        AdapterMethodMetadata adapterMethodMetadata = AdapterMethodMetadata.newInstance(metadata.getSourceClassName(), metadata.getTargetClassName(), metadata.mapperClass(), metadata.isCycleAvoiding());
        this.methodMap.putIfAbsent(adapterMethodMetadata.getMethodName(), adapterMethodMetadata);
    }

    private void addAdapterMapMethod(ClassName source, ClassName target, ClassName mapper, boolean objectConverter) {
        AdapterMapMethodMetadata adapterMapMethodMetadata = new AdapterMapMethodMetadata(source, target, mapper, objectConverter);
        this.mapMethodMap.putIfAbsent(adapterMapMethodMetadata.getMethodName(), adapterMapMethodMetadata);
    }

    private AutoMapperMetadata initAutoMapperMetadata(ClassName source, ClassName target, boolean cycleAvoiding) {
        AutoMapperMetadata metadata = new AutoMapperMetadata(source, target);
        metadata.setSuperGenerics(new ClassName[]{source, target});
        ClassName mapStructConfigClass = cycleAvoiding ? ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getCycleAvoidingConfigClassName(), (String[])new String[0]) : ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getConfigClassName(), (String[])new String[0]);
        metadata.setMapstructConfigClass(mapStructConfigClass);
        return metadata;
    }

    private List<AutoMapperMetadata> buildAutoMapperMetadataByAutoMappers(Element ele) {
        AutoMappersGem autoMappersGem = AutoMappersGem.instanceOn(ele);
        if (autoMappersGem == null || !autoMappersGem.isValid()) {
            return null;
        }
        HashSet targetClassNames = new HashSet();
        return ((List)autoMappersGem.value().getValue()).stream().filter(autoMapperGem -> {
            if (autoMapperGem == null || !autoMapperGem.isValid()) {
                return false;
            }
            TypeMirror target = (TypeMirror)autoMapperGem.target().getValue();
            return targetClassNames.add(target.toString());
        }).map(autoMapperGem -> this.buildAutoMapperMetadata((AutoMapperGem)autoMapperGem, ele)).collect(Collectors.toList());
    }

    private AutoMapperMetadata buildAutoMapperMetadata(Element ele) {
        AutoMapperGem autoMapperGem = AutoMapperGem.instanceOn(ele);
        if (autoMapperGem == null || !autoMapperGem.isValid()) {
            return null;
        }
        return this.buildAutoMapperMetadata(autoMapperGem, ele);
    }

    private List<AutoMappingMetadata> matchTargetFieldMapping(List<AutoMappingMetadata> autoMappingMetadataList, ClassName target) {
        autoMappingMetadataList.removeIf(mappingMetadata -> !this.isTargetFieldMapping(target, (AutoMappingMetadata)mappingMetadata));
        Map<String, List<AutoMappingMetadata>> targetFieldAutoMappingMap = autoMappingMetadataList.stream().collect(Collectors.groupingBy(AutoMappingMetadata::getTarget));
        ArrayList<AutoMappingMetadata> result = new ArrayList<AutoMappingMetadata>();
        targetFieldAutoMappingMap.forEach((key, list) -> {
            if (list.size() == 1) {
                result.add((AutoMappingMetadata)list.get(0));
                return;
            }
            ClassName targetClassName = target;
            while (targetClassName != null) {
                ClassName finalTargetClassName = targetClassName;
                List matchedList = list.stream().filter(mappingMetadata -> mappingMetadata.getTargetClass().reflectionName().equals(finalTargetClassName.reflectionName())).collect(Collectors.toList());
                if (!matchedList.isEmpty()) {
                    result.addAll(matchedList);
                    return;
                }
                targetClassName = this.getSuperClass(this.classNameToTypeElement(targetClassName)).map(ClassName::get).orElse(null);
            }
            result.addAll((Collection<AutoMappingMetadata>)list);
        });
        return result;
    }

    private boolean isTargetFieldMapping(ClassName target, AutoMappingMetadata mappingMetadata) {
        if (MAPPING_DEFAULT_TARGET.reflectionName().contentEquals(mappingMetadata.getTargetClass().reflectionName())) {
            return true;
        }
        if (target.reflectionName().contentEquals(mappingMetadata.getTargetClass().reflectionName())) {
            return true;
        }
        TypeElement targetTypeElement = this.classNameToTypeElement(target);
        Optional<TypeElement> superClass = this.getSuperClass(targetTypeElement);
        return superClass.filter(typeElement -> this.isTargetFieldMapping(ClassName.get((TypeElement)typeElement), mappingMetadata)).isPresent();
    }

    private Optional<TypeElement> getSuperClass(TypeElement ele) {
        TypeMirror superclass = ele.getSuperclass();
        if (superclass == null) {
            return Optional.empty();
        }
        if ("java.lang.Object".equals(superclass.toString())) {
            return Optional.empty();
        }
        if (ele.getQualifiedName().contentEquals(superclass.toString())) {
            return Optional.empty();
        }
        return Optional.of((TypeElement)this.processingEnv.getTypeUtils().asElement(superclass));
    }

    private AutoMapperMetadata buildAutoMapperMetadata(AutoMapperGem autoMapperGem, Element ele) {
        ClassName source = ClassName.get((TypeElement)((TypeElement)ele));
        ClassName target = (ClassName)ClassName.get((TypeMirror)((TypeMirror)autoMapperGem.target().getValue()));
        if (target == null) {
            return null;
        }
        List<AutoMappingMetadata> autoMappingMetadataList = this.matchTargetFieldMapping(this.buildFieldMappingMetadata((TypeElement)ele), target);
        List<AutoMappingMetadata> reverseMappingMetadataList = this.matchTargetFieldMapping(this.buildFieldReverseMappingMetadata((TypeElement)ele), target);
        AutoMapperMetadata metadata = this.initAutoMapperMetadata(source, target, (Boolean)autoMapperGem.cycleAvoiding().get());
        List<ClassName> usesClassNameList = this.transToClassNameList((List)autoMapperGem.uses().get());
        List useEnumClassNameList = this.transToClassNameList((List)autoMapperGem.useEnums().get()).stream().map(enumClass -> ClassName.get((String)MapperUtils.getMapperPackage(enumClass.packageName()), (String)MapperUtils.getEnumMapperClassName(enumClass.simpleName()), (String[])new String[0])).collect(Collectors.toList());
        Set<TypeName> dependencies = this.listDependencies((TypeElement)ele);
        usesClassNameList.addAll(useEnumClassNameList);
        metadata.setUsesClassNameList(usesClassNameList);
        metadata.setImportsClassNameList(this.transToClassNameList((List)autoMapperGem.imports().get()));
        metadata.setFieldMappingList(autoMappingMetadataList);
        metadata.setFieldReverseMappingList(reverseMappingMetadataList);
        metadata.setConvertGenerate((Boolean)autoMapperGem.convertGenerate().get());
        metadata.setReverseConvertGenerate((Boolean)autoMapperGem.reverseConvertGenerate().get());
        metadata.setCycleAvoiding((Boolean)autoMapperGem.cycleAvoiding().get());
        if (metadata.isCycleAvoiding()) {
            metadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseCycleAvoidingMapper", (String[])new String[0]));
        } else {
            metadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseMapper", (String[])new String[0]));
        }
        metadata.setUnmappedSourcePolicy((String)autoMapperGem.unmappedSourcePolicy().getValue());
        metadata.setUnmappedTargetPolicy((String)autoMapperGem.unmappedTargetPolicy().getValue());
        metadata.setTypeConversionPolicy((String)autoMapperGem.typeConversionPolicy().getValue());
        metadata.setCollectionMappingStrategy((String)autoMapperGem.collectionMappingStrategy().getValue());
        metadata.setNullValueMappingStrategy((String)autoMapperGem.nullValueMappingStrategy().getValue());
        metadata.setNullValueIterableMappingStrategy((String)autoMapperGem.nullValueIterableMappingStrategy().getValue());
        metadata.setNullValuePropertyMappingStrategy((String)autoMapperGem.nullValuePropertyMappingStrategy().getValue());
        metadata.setNullValueCheckStrategy((String)autoMapperGem.nullValueCheckStrategy().getValue());
        metadata.setMappingControl(this.transToClassName((TypeMirror)autoMapperGem.mappingControl().getValue()));
        if (StrUtil.isNotEmpty((CharSequence)((CharSequence)autoMapperGem.mapperName().getValue()))) {
            metadata.setMapperName((String)autoMapperGem.mapperName().getValue());
        }
        metadata.setMapperNameSuffix((String)autoMapperGem.mapperNameSuffix().getValue());
        metadata.setDependencies(dependencies);
        this.addMapper(metadata, true);
        return metadata;
    }

    private List<AutoMappingMetadata> buildFieldReverseMappingMetadata(TypeElement ele) {
        ArrayList<AutoMappingMetadata> list = new ArrayList<AutoMappingMetadata>();
        if (!ele.getKind().isClass() && !ele.getKind().isInterface()) {
            return list;
        }
        for (Element element : ele.getEnclosedElements()) {
            ReverseAutoMappingsGem reverseAutoMappingsGem;
            if (element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.METHOD) continue;
            ReverseAutoMappingGem reverseAutoMappingGem = ReverseAutoMappingGem.instanceOn(element);
            if (reverseAutoMappingGem != null && reverseAutoMappingGem.isValid()) {
                list.add(this.buildAutoMappingMetadata(reverseAutoMappingGem, element));
            }
            if ((reverseAutoMappingsGem = ReverseAutoMappingsGem.instanceOn(element)) == null || !reverseAutoMappingsGem.isValid()) continue;
            ((List)reverseAutoMappingsGem.value().get()).forEach(a -> this.buildAutoMappingMetadata((ReverseAutoMappingGem)a, field));
        }
        this.getSuperClass(ele).ifPresent(superClass -> list.addAll(this.buildFieldReverseMappingMetadata((TypeElement)superClass)));
        list.removeIf(Objects::isNull);
        return list;
    }

    private AutoMappingMetadata buildAutoMappingMetadata(ReverseAutoMappingGem reverseAutoMappingGem, Element ele) {
        ClassName targetClass = this.transToClassName((TypeMirror)reverseAutoMappingGem.targetClass().get());
        if (targetClass == null) {
            return null;
        }
        AutoMappingMetadata metadata = new AutoMappingMetadata();
        if (StrUtil.isNotEmpty((CharSequence)((CharSequence)reverseAutoMappingGem.source().get()))) {
            metadata.setSource((String)reverseAutoMappingGem.source().get());
        } else {
            metadata.setSource(ele.getSimpleName().toString());
        }
        if (StrUtil.isNotEmpty((CharSequence)((CharSequence)reverseAutoMappingGem.target().get()))) {
            metadata.setTarget((String)reverseAutoMappingGem.target().get());
        } else {
            metadata.setTarget(ele.getSimpleName().toString());
        }
        metadata.setTargetClass(targetClass);
        metadata.setDefaultValue((String)reverseAutoMappingGem.defaultValue().getValue());
        metadata.setIgnore((Boolean)reverseAutoMappingGem.ignore().getValue());
        metadata.setExpression((String)reverseAutoMappingGem.expression().getValue());
        metadata.setDefaultExpression((String)reverseAutoMappingGem.defaultExpression().getValue());
        metadata.setConditionExpression((String)reverseAutoMappingGem.conditionExpression().getValue());
        metadata.setDateFormat((String)reverseAutoMappingGem.dateFormat().getValue());
        metadata.setNumberFormat((String)reverseAutoMappingGem.numberFormat().getValue());
        metadata.setQualifiedByName((List)reverseAutoMappingGem.qualifiedByName().getValue());
        metadata.setConditionQualifiedByName((List)reverseAutoMappingGem.conditionQualifiedByName().getValue());
        metadata.setDependsOn((List)reverseAutoMappingGem.dependsOn().getValue());
        metadata.setConstant((String)reverseAutoMappingGem.constant().getValue());
        metadata.setQualifiedBy(this.transToClassNameList((List)reverseAutoMappingGem.qualifiedBy().getValue()));
        metadata.setNullValueCheckStrategy((String)reverseAutoMappingGem.nullValueCheckStrategy().getValue());
        metadata.setNullValuePropertyMappingStrategy((String)reverseAutoMappingGem.nullValuePropertyMappingStrategy().getValue());
        metadata.setMappingControl(this.transToClassName((TypeMirror)reverseAutoMappingGem.mappingControl().getValue()));
        return metadata;
    }

    private boolean addMapper(AutoMapperMetadata metadata, boolean throwsException) {
        boolean addSuccess = this.mapperSet.add(metadata.getSourceClassName().reflectionName() + "To" + metadata.getTargetClassName().reflectionName());
        if (throwsException && !addSuccess) {
            throw new DuplicateMapperException("An exception occurred to generate " + metadata.mapperName() + ", check the mapping configuration for " + metadata.getSourceClassName().reflectionName() + " or " + metadata.getTargetClassName().reflectionName());
        }
        return addSuccess;
    }

    private List<AutoMappingMetadata> buildFieldMappingMetadata(TypeElement autoMapperEle) {
        ArrayList<AutoMappingMetadata> list = new ArrayList<AutoMappingMetadata>();
        if (!autoMapperEle.getKind().isClass() && !autoMapperEle.getKind().isInterface()) {
            return list;
        }
        for (Element element : autoMapperEle.getEnclosedElements()) {
            AutoMappingsGem autoMappingsGem;
            if (element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.METHOD) continue;
            AutoMappingGem autoMappingGem = AutoMappingGem.instanceOn(element);
            if (autoMappingGem != null && autoMappingGem.isValid()) {
                list.add(this.buildAutoMappingMetadata(autoMappingGem, element));
            }
            if ((autoMappingsGem = AutoMappingsGem.instanceOn(element)) == null || !autoMappingsGem.isValid()) continue;
            ((List)autoMappingsGem.value().get()).forEach(a -> list.add(this.buildAutoMappingMetadata((AutoMappingGem)a, ele)));
        }
        this.getSuperClass(autoMapperEle).ifPresent(superClass -> list.addAll(this.buildFieldMappingMetadata((TypeElement)superClass)));
        list.removeIf(Objects::isNull);
        return list;
    }

    private AutoMappingMetadata buildAutoMappingMetadata(AutoMappingGem autoMappingGem, Element ele) {
        ClassName targetClass = this.transToClassName((TypeMirror)autoMappingGem.targetClass().get());
        if (targetClass == null) {
            return null;
        }
        AutoMappingMetadata metadata = new AutoMappingMetadata();
        String elementName = ele.getSimpleName().toString();
        if (ele.getKind() == ElementKind.METHOD) {
            elementName = ObjectUtils.defaultIfNull(StrUtil.getGeneralField((CharSequence)elementName), elementName);
        }
        if (StrUtil.isNotEmpty((CharSequence)((CharSequence)autoMappingGem.source().get()))) {
            metadata.setSource((String)autoMappingGem.source().get());
        } else {
            metadata.setSource(elementName);
        }
        if (StrUtil.isNotEmpty((CharSequence)((CharSequence)autoMappingGem.target().get()))) {
            metadata.setTarget((String)autoMappingGem.target().get());
        } else {
            metadata.setTarget(elementName);
        }
        metadata.setTargetClass(targetClass);
        metadata.setReverseConvertGenerate((Boolean)autoMappingGem.reverseConvertGenerate().get());
        metadata.setDefaultValue((String)autoMappingGem.defaultValue().getValue());
        metadata.setIgnore((Boolean)autoMappingGem.ignore().getValue());
        metadata.setExpression((String)autoMappingGem.expression().getValue());
        metadata.setDefaultExpression((String)autoMappingGem.defaultExpression().getValue());
        metadata.setConditionExpression((String)autoMappingGem.conditionExpression().getValue());
        metadata.setDateFormat((String)autoMappingGem.dateFormat().getValue());
        metadata.setNumberFormat((String)autoMappingGem.numberFormat().getValue());
        metadata.setQualifiedByName((List)autoMappingGem.qualifiedByName().getValue());
        metadata.setConditionQualifiedByName((List)autoMappingGem.conditionQualifiedByName().getValue());
        metadata.setDependsOn((List)autoMappingGem.dependsOn().getValue());
        metadata.setConstant((String)autoMappingGem.constant().getValue());
        metadata.setQualifiedBy(this.transToClassNameList((List)autoMappingGem.qualifiedBy().getValue()));
        metadata.setNullValueCheckStrategy((String)autoMappingGem.nullValueCheckStrategy().getValue());
        metadata.setNullValuePropertyMappingStrategy((String)autoMappingGem.nullValuePropertyMappingStrategy().getValue());
        metadata.setMappingControl(this.transToClassName((TypeMirror)autoMappingGem.mappingControl().getValue()));
        return metadata;
    }

    private ClassName transToClassName(Supplier<Class<?>> classSupplier) {
        TypeMirror typeMirror = null;
        try {
            Class<?> clazz = classSupplier.get();
        }
        catch (MirroredTypeException e) {
            typeMirror = e.getTypeMirror();
        }
        if (typeMirror == null) {
            return null;
        }
        return (ClassName)ClassName.get((TypeMirror)typeMirror);
    }

    private List<ClassName> transToClassNameList(Supplier<Class<?>[]> classSuppler) {
        List<? extends TypeMirror> typeMirrors = null;
        try {
            Class<?>[] classArray = classSuppler.get();
        }
        catch (MirroredTypesException e) {
            typeMirrors = e.getTypeMirrors();
        }
        return typeMirrors.stream().map(typeMirror -> (ClassName)ClassName.get((TypeMirror)typeMirror)).collect(Collectors.toList());
    }

    private List<ClassName> transToClassNameList(List<TypeMirror> typeMirrors) {
        if (typeMirrors == null) {
            return new ArrayList<ClassName>();
        }
        return typeMirrors.stream().map(this::transToClassName).collect(Collectors.toList());
    }

    private ClassName transToClassName(TypeMirror typeMirror) {
        if (typeMirror == null) {
            return null;
        }
        return (ClassName)ClassName.get((TypeMirror)typeMirror);
    }

    private TypeElement classNameToTypeElement(ClassName className) {
        String classNameString = className.toString();
        return this.processingEnv.getElementUtils().getTypeElement(classNameString);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

