/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie;

import io.github.linpeilie.BaseMapMapper;
import io.github.linpeilie.BaseMapper;
import io.github.linpeilie.ConverterFactory;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCachedConverterFactory
implements ConverterFactory {
    private final ConcurrentHashMap<String, BaseMapper> mapperMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BaseMapMapper> mapMapperMap = new ConcurrentHashMap();

    @Override
    public <S, T> BaseMapper<S, T> getMapper(Class<S> sourceType, Class<T> targetType) {
        String key = this.key(sourceType, targetType);
        if (this.mapperMap.containsKey(key)) {
            return this.mapperMap.get(key);
        }
        BaseMapper mapper = this.findMapper(sourceType, targetType);
        if (mapper != null) {
            this.mapperMap.put(key, mapper);
            return mapper;
        }
        return null;
    }

    @Override
    public <S> BaseMapMapper<S> getMapMapper(Class<S> sourceType) {
        String key = sourceType.getName();
        if (this.mapMapperMap.containsKey(key)) {
            return this.mapMapperMap.get(key);
        }
        BaseMapMapper mapper = this.findMapMapper(sourceType);
        if (mapper != null) {
            this.mapMapperMap.put(key, mapper);
            return mapper;
        }
        return null;
    }

    protected abstract <S, T> BaseMapper findMapper(Class<S> var1, Class<T> var2);

    protected abstract <S> BaseMapMapper findMapMapper(Class<?> var1);

    private String key(Class<?> source, Class<?> target) {
        return source.getName() + "__" + target.getName();
    }
}

