/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.text.DateFormat;

public class ObjectMapperUtil {
    private static ObjectMapperUtil objectMapperUtilYAML = new ObjectMapperUtil(true);
    private static ObjectMapperUtil objectMapperUtilJSON = new ObjectMapperUtil(false);
    private ObjectMapper objectMapper;

    private ObjectMapperUtil(boolean isyaml) {
        if (isyaml) {
            this.objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        } else {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.objectMapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static ObjectMapper getYAMLInstance() {
        return ObjectMapperUtil.objectMapperUtilYAML.objectMapper;
    }

    public static ObjectMapper getJSONInstance() {
        return ObjectMapperUtil.objectMapperUtilJSON.objectMapper;
    }
}

