/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.expression;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.data.DataTypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SimpleEvaluationResult<V>
implements EvaluationResult {
    private UUID groupId;
    private V value;
    private Class<?> klass;
    private String klassName;
    private List<ResourceValue> additionalResources;

    public SimpleEvaluationResult(V value) {
        this(value, new ArrayList<ResourceValue>());
    }

    public SimpleEvaluationResult(V value, List<ResourceValue> additionalResources, UUID groupId) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value cannot be null");
        Preconditions.checkArgument((additionalResources != null ? 1 : 0) != 0, (Object)"additionalResources cannot be null");
        this.value = value;
        this.klass = value.getClass();
        this.klassName = DataTypeUtil.getDataType(value);
        this.additionalResources = new ArrayList<ResourceValue>();
        this.additionalResources.addAll(additionalResources);
        this.groupId = groupId;
    }

    public SimpleEvaluationResult(V value, List<ResourceValue> additionalResources) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value cannot be null");
        Preconditions.checkArgument((additionalResources != null ? 1 : 0) != 0, (Object)"additionalResources cannot be null");
        this.value = value;
        this.klass = value.getClass();
        this.klassName = DataTypeUtil.getDataType(value);
        this.additionalResources = new ArrayList<ResourceValue>();
        this.additionalResources.addAll(additionalResources);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public String toString() {
        if (this.value != null) {
            return "Type: [" + this.klassName + "] Value : [" + this.value.toString() + "]";
        }
        return "";
    }

    @Override
    public Class<?> getValueType() {
        return this.klass;
    }

    @Override
    public String getIdentifier() {
        return this.klassName;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public List<ResourceValue> getAdditionalResources() {
        return new ArrayList<ResourceValue>(this.additionalResources);
    }

    public UUID getGroupId() {
        return this.groupId;
    }
}

