/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.terminology;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class CodingSystem {
    private String id;
    private String description;
    private String url;
    private String oid;

    @JsonCreator
    public CodingSystem(@JsonProperty(value="id") String id, @JsonProperty(value="description") String description, @JsonProperty(value="url") String url, @JsonProperty(value="oid") String oid) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id cannot be null or blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)url), (Object)"url cannot be null or blank");
        Preconditions.checkArgument((StringUtils.isBlank((CharSequence)oid) || StringUtils.isNotBlank((CharSequence)oid) && StringUtils.startsWith((CharSequence)oid, (CharSequence)"urn:oid:") ? 1 : 0) != 0, (Object)(oid + " OID can be null or blank, but if its not blank it  should start with  urn:oid:"));
        this.id = id;
        this.description = description;
        this.url = url;
        this.oid = oid;
    }

    public String getId() {
        return StringUtils.upperCase((String)this.id, (Locale)Locale.ENGLISH);
    }

    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonGetter(value="oid")
    public String getOid() {
        return this.oid;
    }
}

